/*
 * Decompiled with CFR 0.152.
 */
package nor.http;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.util.zip.DeflaterInputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import nor.http.HeaderName;
import nor.http.HttpHeader;
import nor.http.io.ChunkedInputStream;
import nor.http.io.ChunkedOutputStream;
import nor.util.io.LimitedInputStream;
import nor.util.io.LimitedOutputStream;
import nor.util.io.Stream;
import nor.util.log.Logger;

public abstract class HttpMessage
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(HttpMessage.class);
    private InputStream body;

    protected HttpMessage() {
    }

    public InputStream getBody() {
        InputStream ret = this.body;
        this.body = null;
        return ret;
    }

    public void setBody(InputStream body) {
        this.body = body;
    }

    public void writeTo(OutputStream output) throws IOException {
        LOGGER.entering("writeMessage", output);
        assert (output != null);
        HttpHeader header = this.getHeader();
        if (this.body == null) {
            header.set(HeaderName.ContentLength, "0");
            header.remove(HeaderName.TransferEncoding);
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output));
        writer.append(this.getHeadLine());
        writer.append('\r');
        writer.append('\n');
        writer.flush();
        header.output(writer);
        writer.append('\r');
        writer.append('\n');
        writer.flush();
        writer.close();
        this.writeBodyTo(output);
        LOGGER.exiting("writeMessage");
    }

    public void writeTo(HttpURLConnection con) throws IOException {
        HttpHeader header = this.getHeader();
        if (this.body == null) {
            header.remove(HeaderName.ContentLength);
            header.remove(HeaderName.TransferEncoding);
        }
        for (String key : header.keySet()) {
            con.addRequestProperty(key, header.get(key));
        }
        if (header.containsKey(HeaderName.ContentLength)) {
            int length = Integer.parseInt(header.get(HeaderName.ContentLength));
            con.setFixedLengthStreamingMode(length);
            con.setDoOutput(true);
            this.writeBodyTo(con.getOutputStream());
        } else if (header.containsKey(HeaderName.TransferEncoding)) {
            con.setDoOutput(true);
            this.writeBodyTo(con.getOutputStream());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.body != null) {
            this.body.close();
        }
    }

    public String toString() {
        LOGGER.entering("toString", new Object[0]);
        StringBuilder ret = new StringBuilder();
        ret.append(this.getHeadLine());
        ret.append("\n");
        ret.append(this.getHeader());
        ret.append("\n");
        LOGGER.exiting("toString", (Object)ret.toString());
        return ret.toString();
    }

    public abstract String getVersion();

    public abstract String getPath();

    public abstract HttpHeader getHeader();

    public abstract String getHeadLine();

    private void writeBodyTo(OutputStream out) throws IOException {
        if (this.body != null) {
            HttpHeader header = this.getHeader();
            OutputStream cout = out;
            if (header.containsKey(HeaderName.ContentLength)) {
                String length = header.get(HeaderName.ContentLength).split(",")[0];
                cout = new LimitedOutputStream(cout, Integer.parseInt(length));
            } else if ("chunked".equalsIgnoreCase(header.get(HeaderName.TransferEncoding))) {
                cout = new ChunkedOutputStream(cout);
            }
            if (header.containsKey(HeaderName.ContentEncoding)) {
                String encode = header.get(HeaderName.ContentEncoding);
                if ("gzip".equalsIgnoreCase(encode)) {
                    cout = new GZIPOutputStream(cout, 65536);
                } else if ("deflate".equalsIgnoreCase(encode)) {
                    cout = new DeflaterOutputStream(cout);
                }
            }
            Stream.copy(this.body, cout);
            cout.flush();
            cout.close();
        }
        out.close();
    }

    static InputStream decodeStream(InputStream input, HttpHeader header) {
        InputStream cin = input;
        if (header.containsKey(HeaderName.TransferEncoding)) {
            cin = new ChunkedInputStream(cin);
        } else if (header.containsKey(HeaderName.ContentLength)) {
            String length = header.get(HeaderName.ContentLength);
            cin = new LimitedInputStream(cin, Long.valueOf(length));
        }
        if (header.containsKey(HeaderName.ContentEncoding)) {
            String encode = header.get(HeaderName.ContentEncoding);
            if ("gzip".equalsIgnoreCase(encode)) {
                try {
                    cin = new GZIPInputStream(cin);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if ("deflate".equalsIgnoreCase(encode)) {
                cin = new DeflaterInputStream(cin);
            }
        }
        return cin;
    }
}

