/*
 * Decompiled with CFR 0.152.
 */
package nor.http.io;

import java.io.IOException;
import java.io.InputStream;
import nor.util.log.Logger;

public class HeaderInputStream
extends InputStream {
    private final InputStream in;
    private State state = State.SecondCR;
    private int nilCount = 0;
    private static int MAX_NIL = 128;
    private static final Logger LOGGER = Logger.getLogger(HeaderInputStream.class);

    public HeaderInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        LOGGER.entering("read", new Object[0]);
        if (this.state == State.SecondLF) {
            return -1;
        }
        int ret = this.in.read();
        block0 : switch (this.state) {
            case Default: {
                switch (ret) {
                    case 13: {
                        this.state = State.FirstCR;
                    }
                }
                break;
            }
            case FirstCR: {
                switch (ret) {
                    case 10: {
                        this.state = State.FirstLF;
                        break block0;
                    }
                }
                this.state = State.Default;
                break;
            }
            case FirstLF: {
                switch (ret) {
                    case 13: {
                        this.state = State.SecondCR;
                        break block0;
                    }
                }
                this.state = State.Default;
                break;
            }
            case SecondCR: {
                switch (ret) {
                    case 10: {
                        this.state = State.SecondLF;
                        break block0;
                    }
                }
                this.state = State.Default;
            }
        }
        if (ret == 0) {
            ++this.nilCount;
            LOGGER.fine("read", "{0} continuous zero bits", this.nilCount);
            if (this.nilCount > MAX_NIL) {
                ret = -1;
            }
        } else {
            this.nilCount = 0;
        }
        if (ret == -1) {
            this.state = State.SecondLF;
        }
        LOGGER.exiting("read", ret);
        return ret;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long n) throws IOException {
        long i;
        LOGGER.entering("skip", n);
        for (i = 0L; i != n && this.read() != -1; ++i) {
        }
        LOGGER.exiting("skip", i);
        return i;
    }

    public void clearState() {
        this.state = State.SecondCR;
    }

    private static enum State {
        Default,
        FirstCR,
        FirstLF,
        SecondCR,
        SecondLF;

    }
}

