/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import nor.http.ContentType;
import nor.http.HeaderName;
import nor.http.HttpHeader;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.Status;
import nor.http.error.HttpException;
import nor.http.error.NotFoundException;
import nor.http.server.local.Resource;
import nor.util.log.Logger;

public class ReadonlyFileResource
extends Resource {
    private final File file;
    private final ContentType type;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss zzz", Locale.US);
    private static final Logger LOGGER = Logger.getLogger(ReadonlyFileResource.class);

    public ReadonlyFileResource(String name, File file, ContentType type) {
        super(name);
        LOGGER.entering("<init>", name, file, type);
        assert (name != null);
        assert (file != null);
        assert (type != null);
        this.file = file;
        this.type = type;
        LOGGER.exiting("<init>");
    }

    public ReadonlyFileResource(String name, File file, String type) {
        this(name, file, new ContentType(type));
    }

    public ReadonlyFileResource(String name, String file, ContentType type) {
        this(name, new File(file), type);
    }

    public ReadonlyFileResource(String name, String file, String type) {
        this(name, new File(file), new ContentType(type));
    }

    public ReadonlyFileResource(File file, ContentType type) {
        this(file.getName(), file, type);
    }

    public ReadonlyFileResource(File file, String type) {
        this(file.getName(), file, type);
    }

    public ReadonlyFileResource(String file, ContentType type) {
        this(new File(file), type);
    }

    public ReadonlyFileResource(String file, String type) {
        this(file, new ContentType(type));
    }

    @Override
    public HttpResponse doGet(String path, HttpRequest request) throws HttpException {
        LOGGER.entering("doGet", path, request);
        assert (path != null);
        assert (request != null);
        HttpResponse ret = null;
        if (this.file.canRead()) {
            try {
                ret = request.createResponse(Status.OK, new FileInputStream(this.file), this.file.length());
                HttpHeader header = ret.getHeader();
                header.add(HeaderName.ContentType, this.type.toString());
                header.add(HeaderName.LastModified, DATE_FORMAT.format(new Date(this.file.lastModified())));
                header.add(HeaderName.Date, DATE_FORMAT.format(Calendar.getInstance().getTime()));
            }
            catch (FileNotFoundException e) {
                throw new NotFoundException();
            }
        }
        LOGGER.exiting("doGet", ret);
        return ret;
    }
}

