/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.nserver;

import java.io.IOException;
import java.util.logging.Level;
import nor.http.server.HttpRequestHandler;
import nor.http.server.HttpServer;
import nor.http.server.nserver.ConnectionManager;
import nor.http.server.nserver.NServer;
import nor.network.Connection;
import nor.network.PortListener;
import nor.network.SelectionWorker;
import nor.util.log.Logger;

public class HttpNServer
implements HttpServer {
    public static final String VERSION = "1.1";
    private final HttpRequestHandler handler;
    private SelectionWorker selecter;
    private PortListener listener;
    private Thread selectionThread;
    private ConnectionManager workerThreadManager;
    private static final Logger LOGGER = Logger.getLogger(HttpNServer.class);

    public HttpNServer(HttpRequestHandler handler) {
        LOGGER.entering("<init>", handler);
        assert (handler != null);
        this.handler = handler;
        LOGGER.exiting("<init>");
    }

    @Override
    public void start(String hostname, int port) throws IOException {
        LOGGER.entering("start", hostname, port);
        if (this.selecter != null || this.workerThreadManager != null) {
            this.close();
        }
        this.selecter = new SelectionWorker();
        this.workerThreadManager = new ConnectionManager(this.handler, NServer.MaxThreads);
        this.listener = this.selecter.createPortListener(hostname, port);
        this.listener.addHandler(new PortListener.AcceptEventHandler(){

            @Override
            public void onAccept(Connection con) {
                HttpNServer.this.workerThreadManager.offer(con);
            }
        });
        this.selectionThread = new Thread(this.selecter);
        this.selectionThread.start();
        LOGGER.exiting("service");
    }

    @Override
    public void close() throws IOException {
        LOGGER.entering("close", new Object[0]);
        this.listener.close();
        if (this.selecter != null) {
            this.selectionThread.interrupt();
            try {
                this.selectionThread.join();
            }
            catch (InterruptedException e) {
                LOGGER.catched(Level.WARNING, "close", e);
                Thread.currentThread().interrupt();
            }
            this.selecter = null;
        }
        if (this.workerThreadManager != null) {
            this.workerThreadManager.close();
            this.workerThreadManager = null;
        }
        LOGGER.exiting("close");
    }
}

