/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.nserver;

import java.io.IOException;
import java.util.Properties;
import nor.util.log.Logger;

final class NServer {
    public static final int BufferSize;
    public static final int MaxThreads;

    private NServer() {
    }

    static {
        Logger LOGGER = Logger.getLogger(NServer.class);
        String classname = NServer.class.getName();
        Properties defaults = new Properties();
        try {
            defaults.load(NServer.class.getResourceAsStream("default.conf"));
        }
        catch (IOException e) {
            LOGGER.severe("<class init>", "Cannot load default configs ({0})", e);
        }
        String bsize = String.format("%s.BufferSize", classname);
        BufferSize = Integer.valueOf(System.getProperty(bsize, defaults.getProperty(bsize)));
        String mthreads = String.format("%s.MaxThreads", classname);
        MaxThreads = Integer.valueOf(System.getProperty(mthreads, defaults.getProperty(mthreads)));
        LOGGER.config("<class init>", "Load a constant: BufferSize = {0}", BufferSize);
        LOGGER.config("<class init>", "Load a constant: MaxThreads = {0}", MaxThreads);
    }
}

