/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.nserver;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import nor.http.HeaderName;
import nor.http.HttpHeader;
import nor.http.HttpMessage;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.Method;
import nor.http.Status;
import nor.http.error.HttpException;
import nor.http.server.HttpRequestHandler;
import nor.network.Connection;
import nor.util.io.NoCloseInputStream;
import nor.util.io.NoCloseOutputStream;
import nor.util.io.NoExceptionOutputStreamFilter;
import nor.util.log.Logger;

class RequestHandleWorker
implements Runnable {
    private final Connection con;
    private final HttpRequestHandler handler;
    private static final Logger LOGGER = Logger.getLogger(RequestHandleWorker.class);

    public RequestHandleWorker(Connection con, HttpRequestHandler handler) {
        LOGGER.entering("<init>", con, handler);
        assert (con != null);
        assert (handler != null);
        this.con = con;
        this.handler = handler;
        LOGGER.exiting("<init>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public synchronized void run() {
        block21: {
            LOGGER.entering("run", new Object[0]);
            LOGGER.finer("run", "Begin to handle the connection; {0}", this.con);
            boolean keepAlive = true;
            while (keepAlive && !Thread.currentThread().isInterrupted()) {
                BufferedInputStream input = new BufferedInputStream(new NoCloseInputStream(this.con.getInputStream()));
                NoExceptionOutputStreamFilter output = new NoExceptionOutputStreamFilter(new BufferedOutputStream(new NoCloseOutputStream(this.con.getOutputStream())));
                HttpRequest request = HttpRequest.create(input);
                if (request == null) {
                    LOGGER.fine("run", "Receive a null request", new Object[0]);
                    keepAlive = false;
                    break;
                }
                if (request.getMethod() == Method.CONNECT) {
                    HttpResponse response;
                    LOGGER.fine("run", "Receive a connect request: {0}", request);
                    try {
                        SocketChannel ch = this.handler.doConnectRequest(request);
                        response = request.createResponse(Status.ConnectionEstablished);
                        response.writeTo(output);
                        output.flush();
                        this.con.requestDelegation(ch);
                        LOGGER.info("run", "{0} > {1} (unknown length)", request.getHeadLine(), response.getHeadLine());
                        break;
                    }
                    catch (HttpException e) {
                        response = e.createResponse(request);
                        response.writeTo(output);
                        output.flush();
                        keepAlive = false;
                        LOGGER.catched(Level.WARNING, "run", e);
                        continue;
                    }
                }
                LOGGER.fine("run", "Receive a {0}", request);
                HttpResponse response = this.handler.doRequest(request);
                HttpHeader header = response.getHeader();
                LOGGER.fine("run", "Return the {0}", response);
                response.writeTo(output);
                response.close();
                output.flush();
                if (header.containsKey(HeaderName.ContentLength)) {
                    LOGGER.info("run", "{0} > {1} ({2} bytes)", request.getHeadLine(), response.getHeadLine(), header.get(HeaderName.ContentLength));
                } else {
                    LOGGER.info("run", "{0} > {1} (unknown length)", request.getHeadLine(), response.getHeadLine());
                }
                keepAlive = output.alive() && this.isKeepingAlive(request) && this.isKeepingAlive(response);
            }
            LOGGER.finer("run", "Finish to handle and closes the connection; {0}", this.con);
            try {
                this.con.close();
            }
            catch (IOException e) {
                LOGGER.catched(Level.WARNING, "run", e);
            }
            break block21;
            catch (IOException e) {
                LOGGER.catched(Level.WARNING, "run", e);
                LOGGER.finer("run", "Finish to handle and closes the connection; {0}", this.con);
                try {
                    this.con.close();
                }
                catch (IOException e2) {
                    LOGGER.catched(Level.WARNING, "run", e2);
                }
            }
            catch (VirtualMachineError e2) {
                LOGGER.catched(Level.SEVERE, "run", e2);
                {
                    catch (Throwable throwable) {
                        LOGGER.finer("run", "Finish to handle and closes the connection; {0}", this.con);
                        try {
                            this.con.close();
                        }
                        catch (IOException e3) {
                            LOGGER.catched(Level.WARNING, "run", e3);
                        }
                        throw throwable;
                    }
                }
                LOGGER.finer("run", "Finish to handle and closes the connection; {0}", this.con);
                try {
                    this.con.close();
                }
                catch (IOException e4) {
                    LOGGER.catched(Level.WARNING, "run", e4);
                }
            }
        }
        LOGGER.exiting("run");
    }

    private boolean isKeepingAlive(HttpMessage msg) {
        return !msg.getHeader().containsValue(HeaderName.Connection, "close");
    }
}

