/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import nor.http.HttpHeader;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.Status;
import nor.http.server.ssl.ConnectHandler;

public class TunnellingHandler
implements ConnectHandler {
    private static final Logger LOGGER = Logger.getLogger(TunnellingHandler.class.getName());
    private static final Pattern ADDRESS = Pattern.compile("([^:]+):([0-9]+)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectHandler.Result doConnect(HttpRequest request, InputStream input, OutputStream output) throws IOException {
        LOGGER.entering(TunnellingHandler.class.getName(), "doConnect", new Object[]{request, input, output});
        assert (request != null);
        assert (input != null);
        assert (output != null);
        String path = request.getPath();
        Matcher m = ADDRESS.matcher(path);
        if (m.find()) {
            try {
                int outRes;
                int inRes;
                SSLContext ctx = SSLContext.getDefault();
                SSLSocketFactory factory = ctx.getSocketFactory();
                String host = m.group(1);
                int port = Integer.parseInt(m.group(2), 10);
                SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
                socket.startHandshake();
                HttpResponse ret = request.createResponse(Status.ConnectionEstablished);
                HttpHeader header = ret.getHeader();
                header.add("Proxy-agent", "not/1.0\n");
                ret.writeTo(output);
                InputStream netIn = socket.getInputStream();
                OutputStream netOut = socket.getOutputStream();
                do {
                    byte[] buf = new byte[1024];
                    inRes = input.read(buf);
                    while (inRes != 0 || inRes != -1) {
                        netOut.write(buf);
                        inRes = input.read(buf);
                    }
                    outRes = netIn.read(buf);
                    while (outRes != 0 || outRes != -1) {
                        output.write(buf);
                        outRes = netIn.read(buf);
                    }
                } while (inRes != -1 && outRes != -1);
                socket.shutdownInput();
                socket.shutdownOutput();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        ConnectHandler.Result result = new ConnectHandler.Result();
        LOGGER.exiting(TunnellingHandler.class.getName(), "doConnect", result);
        return result;
    }
}

