/*
 * Decompiled with CFR 0.152.
 */
package nor.network;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import nor.network.Network;
import nor.network.SelectionEventHandlerAdapter;
import nor.network.SelectionWorker;
import nor.util.log.Logger;

public class Connection
implements Closeable {
    private boolean closed = false;
    private SelectableChannel delegation;
    private final SocketChannelInputStream in;
    private final SocketChannelOutputStream out;
    private final SelectionKey key;
    private static final Logger LOGGER = Logger.getLogger(Connection.class);
    private static final String AlreadyClosed = "This stream has already closed.";

    Connection(SocketChannel ch, SelectionWorker selector) throws IOException {
        LOGGER.entering("<init>", ch, selector);
        this.in = new SocketChannelInputStream();
        this.out = new SocketChannelOutputStream();
        this.key = selector.register(ch, 0, new SelectionEventHandlerAdapter(){

            @Override
            public void onRead(ReadableByteChannel ch) {
                Connection.this.in.onRead(ch);
            }

            @Override
            public void onWrite(WritableByteChannel ch) {
                Connection.this.out.onWrite(ch);
            }
        });
        LOGGER.exiting("<init>");
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public boolean closed() {
        return this.closed;
    }

    @Override
    public void close() throws IOException {
        LOGGER.entering("close", new Object[0]);
        this.in.close();
        this.out.close();
        LOGGER.exiting("close");
    }

    public String toString() {
        LOGGER.entering("toString", new Object[0]);
        String res = String.format("%s(key = %s)", this.getClass().getSimpleName(), this.key);
        LOGGER.exiting("toString", (Object)res);
        return res;
    }

    public void requestDelegation(SelectableChannel ch) throws IOException {
        this.delegation = ch;
    }

    private void addOps(int ops) {
        if (this.key.isValid()) {
            this.key.interestOps(this.key.interestOps() | ops);
            this.key.selector().wakeup();
        }
    }

    private void removeOps(int ops) {
        if (this.key.isValid()) {
            this.key.interestOps(this.key.interestOps() & ~ops);
            this.key.selector().wakeup();
        }
    }

    private void onCloseStream() {
        if (this.in.closed() && this.out.closed()) {
            try {
                if (this.delegation != null) {
                    LOGGER.fine("onCloseStream", "Close streams and delegate to {0}.", this.delegation);
                } else {
                    this.key.cancel();
                    this.key.attach(null);
                    this.key.channel().close();
                }
            }
            catch (IOException e) {
                LOGGER.warning("onCloseStream", e.getMessage(), new Object[0]);
                LOGGER.catched(Level.FINE, "onCloseStream", e);
            }
            this.closed = true;
        }
    }

    private final class SocketChannelOutputStream
    extends OutputStream {
        private boolean closed;
        private IOException error;
        private final ByteBuffer buffer;

        public SocketChannelOutputStream() {
            LOGGER.entering(SocketChannelOutputStream.class, "<init>", new Object[0]);
            this.closed = false;
            this.buffer = ByteBuffer.allocate(Network.BufferSize);
            LOGGER.exiting(SocketChannelOutputStream.class, "<init>");
        }

        @Override
        public void write(int b) throws IOException {
            LOGGER.entering(SocketChannelOutputStream.class, "write", b);
            if (this.closed || Thread.currentThread().isInterrupted()) {
                IOException e = new IOException(Connection.AlreadyClosed);
                LOGGER.throwing(this.getClass(), "write", e);
                throw e;
            }
            if (this.available() == 0) {
                this.flush();
            }
            this.buffer.put((byte)b);
            LOGGER.exiting(SocketChannelOutputStream.class, "write");
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            LOGGER.entering(SocketChannelOutputStream.class, "write", b, off, len);
            if (this.closed || Thread.currentThread().isInterrupted()) {
                IOException e = new IOException(Connection.AlreadyClosed);
                LOGGER.throwing(this.getClass(), "write", e);
                throw e;
            }
            while (len != 0) {
                if (this.available() == 0) {
                    this.flush();
                }
                int putSize = Math.min(len, this.available());
                this.buffer.put(b, off, putSize);
                off += putSize;
                len -= putSize;
            }
            LOGGER.exiting(SocketChannelOutputStream.class, "write");
        }

        @Override
        public synchronized void flush() throws IOException {
            LOGGER.entering(SocketChannelOutputStream.class, "flush", new Object[0]);
            if (this.closed) {
                IOException e = new IOException(Connection.AlreadyClosed);
                LOGGER.throwing(this.getClass(), "flush", e);
                throw e;
            }
            if (this.buffer.position() != 0) {
                LOGGER.finer("flush", "Start flush.", new Object[0]);
                this.error = null;
                this.buffer.flip();
                Connection.this.addOps(4);
                try {
                    this.wait(Network.Timeout);
                }
                catch (InterruptedException e) {
                    LOGGER.catched(Level.FINE, this.getClass(), "flush", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                LOGGER.finer("flush", "End flush.", new Object[0]);
                if (this.error != null || Thread.currentThread().isInterrupted()) {
                    Connection.this.close();
                    IOException e = new IOException("Do not write to the stream.", this.error);
                    LOGGER.throwing(this.getClass(), "flush", e);
                    throw e;
                }
            }
            LOGGER.exiting(SocketChannelOutputStream.class, "flush");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            block4: {
                LOGGER.entering(SocketChannelOutputStream.class, "close", new Object[0]);
                try {
                    if (this.buffer.position() > 0) {
                        this.flush();
                    }
                    if (this.closed) break block4;
                    this.closed = true;
                }
                catch (Throwable throwable) {
                    if (!this.closed) {
                        this.closed = true;
                        LOGGER.fine(this.getClass(), "close", "OutputStream by {0} is closed.", Connection.this);
                        Connection.this.removeOps(4);
                        Connection.this.onCloseStream();
                    }
                    throw throwable;
                }
                LOGGER.fine(this.getClass(), "close", "OutputStream by {0} is closed.", Connection.this);
                Connection.this.removeOps(4);
                Connection.this.onCloseStream();
            }
            LOGGER.exiting(SocketChannelOutputStream.class, "close");
        }

        boolean closed() {
            return this.closed;
        }

        synchronized void onWrite(WritableByteChannel channel) {
            try {
                channel.write(this.buffer);
                if (this.available() == 0) {
                    this.buffer.clear();
                    Connection.this.removeOps(4);
                    this.notify();
                }
            }
            catch (IOException e) {
                LOGGER.fine(this.getClass(), "onWrite", "Socket error ({0}) by {1}", e.getMessage(), Connection.this);
                LOGGER.catched(Level.FINE, this.getClass(), "onWrite", (Throwable)e);
                Connection.this.removeOps(4);
                this.error = e;
                this.notify();
            }
        }

        private int available() {
            return this.buffer.limit() - this.buffer.position();
        }
    }

    private final class SocketChannelInputStream
    extends InputStream {
        private boolean closed;
        private IOException error;
        private final ByteBuffer buffer;

        public SocketChannelInputStream() {
            LOGGER.entering(SocketChannelInputStream.class, "<init>", new Object[0]);
            this.closed = false;
            this.buffer = ByteBuffer.allocate(Network.BufferSize);
            this.buffer.limit(0);
            LOGGER.exiting(SocketChannelInputStream.class, "<init>");
        }

        @Override
        public int read() throws IOException {
            LOGGER.entering(SocketChannelInputStream.class, "read", new Object[0]);
            if (this.closed || Thread.currentThread().isInterrupted()) {
                LOGGER.exiting(SocketChannelInputStream.class, "read", -1);
                return -1;
            }
            if (this.available() == 0) {
                this.reload();
                if (this.available() == 0) {
                    LOGGER.exiting(SocketChannelInputStream.class, "read", -1);
                    return -1;
                }
            }
            int res = this.buffer.get() & 0xFF;
            LOGGER.exiting(SocketChannelInputStream.class, "read", res);
            return res;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            LOGGER.entering(SocketChannelInputStream.class, "read", b, off, len);
            if (b == null) {
                NullPointerException e = new NullPointerException("b is null");
                LOGGER.throwing(this.getClass(), "read", e);
                throw e;
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                IndexOutOfBoundsException e = new IndexOutOfBoundsException("off < 0 or len < 0 or len > b.length - off");
                LOGGER.throwing(this.getClass(), "read", e);
                throw e;
            }
            if (this.closed || Thread.currentThread().isInterrupted()) {
                LOGGER.exiting(SocketChannelInputStream.class, "read", -1);
                return -1;
            }
            if (this.available() == 0) {
                this.reload();
                if (this.available() == 0) {
                    LOGGER.exiting(SocketChannelInputStream.class, "read", -1);
                    return -1;
                }
            }
            int copySize = Math.min(len, this.available());
            this.buffer.get(b, off, copySize);
            LOGGER.exiting(SocketChannelInputStream.class, "read", copySize);
            return copySize;
        }

        @Override
        public int available() {
            LOGGER.entering(SocketChannelInputStream.class, "available", new Object[0]);
            int res = this.buffer.limit() - this.buffer.position();
            assert (res >= 0);
            LOGGER.exiting(SocketChannelInputStream.class, "available", res);
            return res;
        }

        @Override
        public void close() {
            LOGGER.entering(SocketChannelInputStream.class, "close", new Object[0]);
            if (!this.closed) {
                this.closed = true;
                LOGGER.fine(this.getClass(), "close", "InputStream by {0} is closed.", Connection.this);
                Connection.this.removeOps(1);
                Connection.this.onCloseStream();
            }
            LOGGER.exiting(SocketChannelInputStream.class, "close");
        }

        boolean closed() {
            return this.closed;
        }

        synchronized void onRead(ReadableByteChannel channel) {
            try {
                this.buffer.clear();
                if (channel.read(this.buffer) == -1) {
                    Connection.this.removeOps(1);
                    this.notify();
                } else if (this.available() != 0) {
                    this.buffer.flip();
                    Connection.this.removeOps(1);
                    this.notify();
                }
            }
            catch (IOException e) {
                LOGGER.fine(this.getClass(), "onRead", "Socket error ({0}) by {1}", e.getMessage(), Connection.this);
                LOGGER.catched(Level.FINE, this.getClass(), "onRead", (Throwable)e);
                Connection.this.removeOps(1);
                this.error = e;
                this.notify();
            }
        }

        private synchronized void reload() throws IOException {
            if (!this.closed && this.available() == 0) {
                this.error = null;
                Connection.this.addOps(1);
                try {
                    this.wait(Network.Timeout);
                }
                catch (InterruptedException e) {
                    LOGGER.catched(Level.FINE, this.getClass(), "reload", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                if (this.error != null || Thread.currentThread().isInterrupted()) {
                    Connection.this.close();
                    IOException e = new IOException("An error is occuered", this.error);
                    LOGGER.throwing(this.getClass(), "reload", e);
                    throw e;
                }
            }
        }
    }
}

