/*
 * Decompiled with CFR 0.152.
 */
package nor.network;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import nor.network.Connection;
import nor.network.SelectionEventHandlerAdapter;
import nor.network.SelectionWorker;
import nor.util.log.Logger;

public class PortListener
implements Closeable {
    private final SelectionKey key;
    private final List<AcceptEventHandler> handlers = new ArrayList<AcceptEventHandler>();
    private static final Logger LOGGER = Logger.getLogger(PortListener.class);

    PortListener(SocketAddress addr, final SelectionWorker selector) throws IOException {
        LOGGER.entering("<init>", addr, selector);
        assert (addr != null);
        assert (selector != null);
        ServerSocketChannel channel = ServerSocketChannel.open();
        channel.configureBlocking(false);
        channel.socket().setReuseAddress(true);
        channel.socket().bind(addr);
        this.key = selector.register(channel, 16, new SelectionEventHandlerAdapter(){

            @Override
            public void onAccept(ServerSocketChannel ch) {
                try {
                    SocketChannel socketChannel = ch.accept();
                    if (socketChannel != null) {
                        LOGGER.finest("onAccept", "Receive an accsptable key from {0}", socketChannel.socket());
                        Connection con = new Connection(socketChannel, selector);
                        for (AcceptEventHandler h : PortListener.this.handlers) {
                            h.onAccept(con);
                        }
                    } else {
                        LOGGER.finest("onAccept", "Receive an accsptable but null key", new Object[0]);
                    }
                }
                catch (IOException e) {
                    LOGGER.warning(this.getClass(), "onAccept", e.getMessage(), new Object[0]);
                    LOGGER.catched(Level.FINE, "onAccept", e);
                }
            }
        });
        LOGGER.info("<init>", "Bind socket to {0}", addr);
        LOGGER.exiting("<init>");
    }

    @Override
    public void close() throws IOException {
        LOGGER.entering("close", new Object[0]);
        SelectableChannel ch = this.key.channel();
        this.key.cancel();
        this.key.attach(null);
        this.key.selector().wakeup();
        ch.close();
        LOGGER.exiting("close");
    }

    public void addHandler(AcceptEventHandler h) {
        LOGGER.entering("addHandler", h);
        this.handlers.add(h);
        LOGGER.exiting("addHandler");
    }

    public void removeHandler(AcceptEventHandler h) {
        LOGGER.entering("removeHandler", h);
        this.handlers.remove(h);
        LOGGER.exiting("removeHandler");
    }

    public String toString() {
        LOGGER.entering("toString", new Object[0]);
        String res = String.format("%s(key = %s)", this.getClass().getSimpleName(), this.key);
        LOGGER.exiting("toString", (Object)res);
        return res;
    }

    public static interface AcceptEventHandler {
        public void onAccept(Connection var1);
    }
}

