/*
 * Decompiled with CFR 0.152.
 */
package nor.plugin;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.logging.Level;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nor.core.plugin.PluginAdapter;
import nor.core.proxy.filter.FilterRegister;
import nor.core.proxy.filter.MessageHandler;
import nor.core.proxy.filter.MessageHandlerAdapter;
import nor.core.proxy.filter.ReadonlyByteFilter;
import nor.core.proxy.filter.ReadonlyPatternFilterAdapter;
import nor.core.proxy.filter.ReadonlyStringFilter;
import nor.core.proxy.filter.ResponseFilter;
import nor.core.proxy.filter.ResponseFilterAdapter;
import nor.core.proxy.filter.StoringToFileFilter;
import nor.http.HeaderName;
import nor.http.HttpHeader;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.Status;
import nor.util.FixedSizeMap;
import nor.util.io.Stream;
import nor.util.log.Logger;

public class NicoCacheNor
extends PluginAdapter {
    private final Properties properties = new Properties();
    private File dir;
    private final Map<String, String> titleMap = new FixedSizeMap(20);
    private static final Logger LOGGER = Logger.getLogger(NicoCacheNor.class);
    private static final String Folder = "folder";
    private static final String ServerName = "NicoCacheNor/0.2.0";
    private static final String MIMETemplate = "video/%s";
    private static final String TitleURLPattern = "/watch/\\w{2}(\\d+)";
    private static final String VideoURLPattern = "nicovideo\\.jp/smile\\?\\w+=([0-9]+)\\.(?:[0-9]+)(low)?";
    private static final String TitleMIMEPattern = "html";
    private static final String VideoMIMEPattern = "video/(.+)";
    private static final String FindTitlePattern = "<(?:title|TITLE)>(.*)-.*</(?:title|TITLE)>";
    private static final String FilenameTemplate = "sm%s%s-%s.%s";
    private static final String FilenamePattern = "sm%s-.*\\.(.+)";
    private static final String LowFilenamePattern = "sm%slow-.*\\.(.+)";
    private static final String ForbiddenCharacters = "\"|<|>|\\||\u0000|:|\\*|\\?|\\\\|&|/";

    public void init(File common, File local) throws IOException {
        LOGGER.entering("init", new Object[]{common, local});
        if (!common.exists()) {
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("default.conf");
            FileOutputStream out = new FileOutputStream(common);
            Stream.copy((InputStream)in, (OutputStream)out);
            ((OutputStream)out).close();
            in.close();
        }
        FileReader commonIn = new FileReader(common);
        this.properties.load(commonIn);
        ((Reader)commonIn).close();
        if (local.exists()) {
            FileReader localIn = new FileReader(local);
            Properties localProp = new Properties();
            localProp.load(localIn);
            ((Reader)localIn).close();
            this.properties.putAll((Map<?, ?>)localProp);
        }
        this.dir = new File(this.properties.getProperty(Folder));
        this.dir.mkdirs();
        StoringToFileFilter.deleteTemplaryFiles((File)this.dir);
        LOGGER.exiting("init");
    }

    public ResponseFilter[] responseFilters() {
        return new ResponseFilter[]{new ResponseFilterAdapter(TitleURLPattern, TitleMIMEPattern){

            public void update(HttpResponse msg, final MatchResult url, MatchResult cType, FilterRegister reg) {
                LOGGER.entering(((Object)((Object)this)).getClass(), "update", new Object[]{msg, url, cType, reg});
                if (msg.getStatus() == Status.OK) {
                    reg.add((ReadonlyStringFilter)new ReadonlyPatternFilterAdapter(NicoCacheNor.FindTitlePattern){

                        public void update(MatchResult res) {
                            String id = url.group(1);
                            String title = res.group(1).replaceAll(NicoCacheNor.ForbiddenCharacters, "");
                            NicoCacheNor.this.titleMap.put(id, title);
                        }
                    });
                }
                LOGGER.exiting(((Object)((Object)this)).getClass(), "update");
            }
        }, new ResponseFilterAdapter(VideoURLPattern, VideoMIMEPattern){

            public void update(HttpResponse msg, MatchResult url, MatchResult cType, FilterRegister register) {
                HttpHeader header;
                LOGGER.entering(((Object)((Object)this)).getClass(), "update", new Object[]{msg, url, cType, register});
                if (msg.getStatus() == Status.OK && !NicoCacheNor.ServerName.equals((header = msg.getHeader()).get(HeaderName.Server))) {
                    final String id = url.group(1);
                    String cond = url.group(2) != null ? url.group(2) : "";
                    String title = NicoCacheNor.this.titleMap.containsKey(id) ? (String)NicoCacheNor.this.titleMap.get(id) : "";
                    String filename = String.format(NicoCacheNor.FilenameTemplate, id, cond, title, cType.group(1));
                    File dest = new File(NicoCacheNor.this.dir, filename);
                    if (!dest.exists()) {
                        try {
                            StoringToFileFilter f = new StoringToFileFilter(dest);
                            if (url.group(2) == null) {
                                f.addListener(new StoringToFileFilter.CloseEventListener(){

                                    public void close(boolean succeeded) {
                                        if (succeeded) {
                                            File[] fileArray = NicoCacheNor.this.findLowCaches(id);
                                            int n = fileArray.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                File low = fileArray[n2];
                                                low.delete();
                                                LOGGER.info(this.getClass(), "update", "Delete the cache; {0}", new Object[]{low});
                                                ++n2;
                                            }
                                        }
                                    }
                                });
                            }
                            register.add((ReadonlyByteFilter)f);
                            LOGGER.info(((Object)((Object)this)).getClass(), "update", "Store this video to {0}", new Object[]{dest});
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                LOGGER.exiting(((Object)((Object)this)).getClass(), "update");
            }
        }};
    }

    public MessageHandler[] messageHandlers() {
        return new MessageHandler[]{new MessageHandlerAdapter(VideoURLPattern){

            public HttpResponse doRequest(HttpRequest request, MatchResult m) {
                File[] lows;
                LOGGER.entering(((Object)((Object)this)).getClass(), "doRequest", new Object[]{request, m});
                File src = null;
                String id = m.group(1);
                File[] caches = NicoCacheNor.this.findCaches(id);
                if (caches.length != 0) {
                    src = caches[0];
                } else if (m.group(2) != null && (lows = NicoCacheNor.this.findLowCaches(id)).length != 0) {
                    src = lows[0];
                }
                HttpResponse ret = null;
                if (src != null) {
                    String name = src.getName();
                    String ext = name.substring(name.lastIndexOf(".") + 1);
                    try {
                        ret = request.createResponse(Status.OK, (InputStream)new FileInputStream(src));
                        HttpHeader header = ret.getHeader();
                        header.set(HeaderName.ContentLength, Long.toString(src.length()));
                        header.set(HeaderName.Server, NicoCacheNor.ServerName);
                        header.set(HeaderName.ContentType, String.format(NicoCacheNor.MIMETemplate, ext));
                        LOGGER.info(((Object)((Object)this)).getClass(), "doRequest", "Return from the cache: {0}", new Object[]{src});
                    }
                    catch (FileNotFoundException e) {
                        LOGGER.catched(Level.WARNING, ((Object)((Object)this)).getClass(), "doRequest", (Throwable)e);
                    }
                }
                LOGGER.exiting(((Object)((Object)this)).getClass(), "doRequest");
                return ret;
            }
        }};
    }

    private File[] findCaches(String id) {
        Pattern pat = Pattern.compile(String.format(FilenamePattern, id));
        return this.findIfMatches(pat);
    }

    private File[] findLowCaches(String id) {
        Pattern pat = Pattern.compile(String.format(LowFilenamePattern, id));
        return this.findIfMatches(pat);
    }

    private File[] findIfMatches(final Pattern pat) {
        final Stack<File> folders = new Stack<File>();
        ArrayList<File> files = new ArrayList<File>();
        folders.push(this.dir);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    folders.push(file);
                    return false;
                }
                Matcher m = pat.matcher(file.getName());
                return m.matches();
            }
        };
        while (folders.size() != 0) {
            File folder = (File)folders.pop();
            files.addAll(Arrays.asList(folder.listFiles(filter)));
        }
        return files.toArray(new File[0]);
    }
}

