#ifndef BOOTPACK_H_
#define BOOTPACK_H_

extern"C" void BitNosMain(); /* C̓ */
int BitNosMainCpp(); /* C++̓ */

typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned int dword;
typedef unsigned int size_t;

#define NULL 0

#define DEBUG_MESSAGE

// 萔`
const dword ADR_BOOTINFO = 0x900;


extern "C" {
	// ptHg
	extern byte hankaku[256 * 16];
	// ~jtHg
	extern byte minifnt[256 * 12];
}

#include "naskfunc.h"
#include "driver/video/video.h"
#include "driver/video/vesa.h"
#include "driver/io/io.h"
#include "driver/io/eflags.h"
#include "driver/io/cr0.h"
#include "driver/io/gdtr.h"
#include "driver/pic/pic.h"
#include "driver/keyboard/keyboard.h"
#include "driver/mouse/mouse.h"
#include "driver/pit/pit.h"
#include "system/arraylist.h"
#include "system/memory.h"
#include "system/bootinfo.h"
#include "system/desctable.h"
#include "system/font.h"
#include "system/graphic.h"
#include "system/int.h"
#include "system/message.h"
#include "system/sheet.h"
#include "system/timer.h"
#include "std/deque.h"
#include "std/queue.h"
#include <string.h>
#include <stdio.h>

namespace system {
	class DebugWindow {
		int cursor_y_;
		int xpos_, ypos_, xsize_, ysize_;
	public:
		DebugWindow(int xpos, int ypos, int xsize, int ysize)
		{
			cursor_y_ = 0;
			xpos_ = xpos;
			ypos_ = ypos;
			xsize_ = xsize;
			ysize_ = ysize;
		}
		DebugWindow& operator <<(const char* str);
	};
}

using namespace system;
using namespace driver;
using namespace std;

extern Font* font_hankaku;
extern Screen* pscreen;
#ifndef DEBUG_MESSAGE
extern queue<Message*>* task1_fifo;
#else
extern queue<Message>* task1_fifo;
#endif
extern TimerController* g_timerctl;

inline color_16 convC(dword color);
inline dword convC_inv(color_16 color);
color_16 mixC(dword color1, dword color2, int color1_ratio, int color2_ratio);

extern DebugWindow* dbg;

/*
 * fobOp֐
 */
//void dbg(const char* const msg);

#endif
