#include "../bootpack.h"

void system::inthandler20(int *esp)
// ^C}[荞
{
	IO8 ocw2(PIC::PIC0_OCW2);
	
	ocw2 << 0x60; // IRQ-00tPIC֒ʒm
	
	g_timerctl->countup();
	task1_fifo->push(
		Message::create(MSG::TYPE::TIMER)
		);
}

void system::inthandler21(int *esp)
// PS/2L[{[h̊荞
{
	byte data;
	IO8 ocw2(PIC::PIC0_OCW2);
	IO8 keydat(Keyboard::PORT_KEYDAT);
	
	ocw2 << 0x61; // IRQ-01tPIC֒ʒm
	keydat >> data;
	task1_fifo->push(
		Message::create(MSG::TYPE::KEYBOARD, data)
		);
}

void system::inthandler27(int *esp)
{
	/* PIC0̕sS荞ݑ΍ */
	IO8 ocw2(PIC::PIC0_OCW2);
	ocw2 << 0x67; // IRQ-07tPIC֒ʒm
	return;
}

void system::inthandler2c(int *esp)
// PS/2}EX̊荞
{
	byte data;
	IO8 p0ocw2(PIC::PIC0_OCW2);
	IO8 p1ocw2(PIC::PIC1_OCW2);
	IO8 keydat(Keyboard::PORT_KEYDAT);
	p1ocw2 << 0x64; // IRQ-12tPIC1֒ʒm
	p0ocw2 << 0x62; // IRQ-02tPIC0֒ʒm
	keydat >> data;
	task1_fifo->push(
		Message::create(MSG::TYPE::MOUSE, data)
		);
	//dbg("int mouse");
}
