#ifndef MESSAGE_H_
#define MESSAGE_H_

namespace system {
	namespace MSG {
		namespace TYPE {
			const int KEYBOARD = 0;
			const int MOUSE = 1;
			const int TIMER = 2;
			const int SYSTEM = 3;
		}
		namespace KEY {
			const int ARROW_UP = 0x100 + 0;
			const int ARROW_DOWN = 0x100 + 1;
			const int ARROW_RIGHT = 0x100 + 2;
			const int ARROW_LEFT = 0x100 + 3;
			const int PAGE_UP = 0x100 + 4;
			const int PAGE_DOWN = 0x100 + 5;
		}
		namespace MOUSE {
			// arg1
			const int COORDINATE = 0; // W
			const int SCROLL = 1;
			
			// arg4
			const int RIGHT_PUSH = 0x01;
			const int LEFT_PUSH = 0x02;
			const int MIDDLE_PUSH = 0x04;
		}
		namespace SYSTEM {
			const int WINDOW_CHANGE = 0;
			const int WINDOW_ACTIVE = 1;
			const int WINDOW_INACTIVE = 2;
		}
	}
	
	/*
	 * bZ[WNX
	 * 
	 * ^XNɃbZ[W𑗐M
	 * VKbZ[W
	 */
	class Message {
	public:
		int type;
		int from;
		int arg1;
		int arg2;
		int arg3;
		int arg4;
		#ifndef DEBUG_MESSAGE
		static Message* create(
		#else
		static Message& create(
		#endif
			int type = 0, int arg1 = 0, int arg2 = 0, int arg3 = 0, int arg4 = 0
			);
		static void send(int to, Message& msg);
	};
}

#endif /*MESSAGE_H_*/
