#ifndef MTASK_H_
#define MTASK_H_

namespace system {
	/*
	 * tss
	 */
	struct Tss32 {
		/*
		 * 32rbgEɍ킹邽2oCg̋󂫃Xy[XĂ
		 */
		word backlink;	word f1;
		dword esp0;
		word ss0;		word f2;
		dword esp1;
		word ss1;		word f3;
		dword esp2;
		word ss2;		word f4;
		dword cr3;
		dword eip;
		dword eflags;
		dword eax;
		dword ecx;
		dword edx;
		dword ebx;
		dword esp;
		dword ebp;
		dword esi;
		dword edi;
		word es;		word f5;
		word cs;		word f6;
		word ss;		word f7;
		word ds;		word f8;
		word fs;		word f9;
		word gs;		word f10;
		word ldtr;		word f11; // [JfBXNv^e[ũZN^l
		word t; // ŉʃrbg1ȂA^XN؂ւINT1̃tH[g
		word iobase;
	};
	
	const int TASK_KERNEL = 0;
	const int TASK_IDLE = 1;
	const int TASK_KEYBOARD = 2;
	const int TASK_MOUSE = 3;
	const int TASK_TASKBAR = 4;
	const int TASK_CONSOLE = 5;
	
	// ^XNXCb`p^C}[
	extern Timer* g_task_timer;
	
	/*
	 * ^XN
	 */
	class Task {
		// 萔
		static const int FLAG_FREE = 0;
		static const int FLAG_ALLOC = 1;
		static const int FLAG_ACTIVE = 2;
		int selector_, flags_;
		int level_, priority_;
		std::queue<Message> fifo_;
		Tss32 tss_;
		SegmentDescriptor ldt_[2];
		int ds_base_;
	public:
		explicit Task();
		
		void init();
		
		// gp}[Nt
		void use() { flags_ = FLAG_ALLOC; }
		
		// gp}[Nt
		void release() { flags_ = FLAG_FREE; }
		
		// ^XNgpǂ
		bool used() const { return flags_ >= FLAG_ALLOC; }
		
		// }[Nt
		void run() { flags_ = FLAG_ACTIVE; }
		
		// ~}[Nt
		void stop() { flags_ = FLAG_ALLOC; }
		
		// 쒆ǂ
		bool running() { return flags_ == FLAG_ACTIVE; }
		
		// xݒ肷
		void set_level(int level) { level_ = level; }
		
		// x擾
		int get_level() { return level_; }
		
		// Dxݒ肷
		void set_priority(int priority) { priority_ = priority; }
		
		// Dx擾
		int get_priority() { return priority_; }
		
		// ZN^lݒ肷
		void set_selector(int sel) { selector_ = sel; }
		
		// ZN^l擾
		int get_selector() { return selector_; }
		
		// fifoɃf[^𑗂
		void send_message(Message& msg) { fifo_.push(msg); }
		
		// fifoobt@擾
		std::queue<Message>* fifo() { return &fifo_; }
		
		// TSSp̃ZOgݒ
		void set_segmtss(int sel);
		
		// LDTp̃ZOgݒ
		void set_segmldt(int sel);
		
		void set_tss_ldtr(word ldtr) { tss_.ldtr = ldtr; }
		void set_tss_esp(dword esp) { tss_.esp = esp; }
		void set_tss_eip(dword eip) { tss_.eip = eip; }
		void set_tss_es(word es) { tss_.es = es; }
		void set_tss_cs(word cs) { tss_.cs = cs; }
		void set_tss_ss(word ss) { tss_.ss = ss; }
		void set_tss_ds(word ds) { tss_.ds = ds; }
		void set_tss_fs(word fs) { tss_.fs = fs; }
		void set_tss_gs(word gs) { tss_.gs = gs; }
	};
	
	namespace TaskDefinitions {
		const int MAX_TASKS_LV = 256;
		const int MAX_LEVELS = 8;
		const int MAX_TASKS = MAX_TASKS_LV * MAX_LEVELS;
		const int TASK_GDT0 = 3; // TSSGDT̉Ԃ犄蓖Ă̂
	}
	
	class TaskLevel {
		static Task* current_task_;
		int running_;
		int current_;
		Task *tasks_[TaskDefinitions::MAX_TASKS_LV];
		
		Task* reset_current_task() { return current_task_ = tasks_[current_]; }
	public:
		explicit TaskLevel();
		
		// ^XN𓮍샊Xgɉ
		void add(Task* task);
		
		// ^XN𓮍샊Xg폜
		void remove(Task* task);
		
		// 쒆^XN̐擾
		int get_running() { return running_; }
		
		// current_߂
		void nexttask();
		
		// ^XN؂ւ
		void task_switch();
		
		// ^XN؂ւ
		void task_switch2();
		
		Task* get_current_task() {
			return reset_current_task();
			//return current_task_;
		}
		
		Task* get_task(int index) { return tasks_[index]; }
	};
	
	/*
	 * ^XNRg[[
	 */
	class TaskController {
		Task* tasks0_;
		TaskLevel* level_;
		bool level_changed_;
		int current_level_;
		
		// ^XNXCb`̕⏕֐
		void task_switchsub();
	public:
		explicit TaskController();
		~TaskController();
		
		Task* init();
		
		// ^XNP
		Task* alloc(int level = 4, int priority = 2);
		
		// ^XN𓮍샊Xgɉ
		void add(Task* task) { level_[task->get_level()].add(task); }
		
		// ^XN𓮍샊Xg폜
		void remove(Task* task) { level_[task->get_level()].remove(task); }
		
		// ^XN𑖂点
		void run(Task* task, int level = -1, int priority = -1);
		
		// ^XN~iX[vj
		void sleep(Task* task);
		
		// ^XNXCb`
		void task_switch();
		
		// ^XNɃbZ[W𑗂
		void send_message(int to, Message& msg);
		
		// ^XNɃbZ[W𑗂
		void send_message(Task* task, Message& msg);
		
		Task* get_current_task() {
			return level_[current_level_].get_current_task();
		}
		
		// ^XNID擾
		int get_taskid(const Task* task) const { return task - tasks0_; }
	};
	
}

#endif /*MTASK_H_*/
