#ifndef CONSOLE_H_
#define CONSOLE_H_

namespace system {
	/*
	 * R\[NX
	 */
	class Console {
		char* str_;
		int xsize_, ysize_; // TCY
		int xofs_, yofs_; // ItZbgl
		int curx_, cury_;
		int cury_max_;
		int bufx_, bufy_;
		int bufxsize_, bufysize_;
		int showy_; // ݕ\Ăs
		color_16 color_, bgcolor_;
		int xmove_, ymove_; // tHg̑傫i=J[\ړ)
		Font* font_;
		Sheet* sht_;
		Picture* buf_;
		bool cursor_on_;
	public:
		explicit Console(Sheet* sht, int xsize, int ysize,
			int offsetx = 8, int offsety = 37, color_16 color = 0xffff, color_16 bgcolor = 0x0000);
		~Console();
		void set_font(Font* font);
		void putstr(const char* str, bool refresh = true);
		Console& operator <<(const char* str) {
			putstr(str);
			return *this;
		}
		void putchar(char c, bool refresh = true);
		void flush();
		void scroll(int line, bool refresh = true);
		void newline(bool refresh);
		int get_bufysize() { return bufysize_; }
		void cursor(bool on); // J[\̓_ŏԂ̐ݒ
		void cursor_on() { cursor_on_ = true; } // J[\\
		void cursor_off() { cursor_on_ = false; } // J[\\Ȃ
		void clear(); // obt@ƉʃNA
		void clear_line(); // ݍsNA
	};
	
	void cons_runcmd(Console* cons, const char* cmdline);
	void cmd_mem(Console* cons);
	void cmd_cls(Console* cons);
	void cmd_dir(Console* cons);
	void cmd_type(Console* cons, const char* cmdline);
}

#endif /*CONSOLE_H_*/
