#include "../../bootpack.h"
using namespace systemtask;

void system::task_mouse() {
	Picture* buffer_back = g_sheet_back->get_buffer();
	// }EXJ[\̈ʒuLpϐ
	int m_xpos = buffer_back->get_xsize() / 2;
	int m_ypos = buffer_back->get_ysize() / 2;
	int m_xpos_old, m_ypos_old;
	int dm_xpos, dm_ypos; // J[\ړω
	
	bool right_pushed = false;
	bool left_pushed = false;
	bool middle_pushed = false;
	
	int button, scroll;
	
	Task* task = g_taskctl->get_current_task();
	queue<Message>* fifo = task->fifo();
	Message* msg = 0;
	
	Mouse::enable(task);
	
	init_phase = 1; // }EXI̍}
	
	// }EXJ[\pV[g̐
	Sheet* sheet_mouse = g_shtctl->alloc(TASK_MOUSE, true);
	sheet_mouse->init(Mouse::XSIZE, Mouse::YSIZE);
	Picture* buffer_mouse = sheet_mouse->get_buffer();
	sheet_mouse->set_invisible_color(0x0001);
	Mouse::init_cursor(buffer_mouse);
	g_shtctl->slide(sheet_mouse, m_xpos, m_ypos);
	g_shtctl->updown(sheet_mouse, 1000);
	
	// EBhEhbOԂǂ
	bool window_drag = false;
	
	Sheet* on_sheet = 0;
	/*Sheet* */active_sheet = get_sheet_taskid(TASK_KERNEL);
	Picture* buf_on_sheet = 0;
	Sheet* sheet_win1 = active_sheet;
	int xpos_on_sheet = 0, ypos_on_sheet = 0;
	Picture* buffer_win1 = sheet_win1->get_buffer();
	
	Sheet* sheet_taskbar = get_sheet_taskid(TASK_TASKBAR);
	Picture* buffer_taskbar = sheet_taskbar->get_buffer();
	Sheet* sheet_dframe = NULL;
	
	
	char s[256];
	
	*dbg << "mouse";

	for (;;) {
		io_cli();
		if (fifo->size() == 0) {
			g_taskctl->sleep(task);
			io_sti();
			continue;
		}
		msg = &fifo->back();
		io_sti();
		if (msg->type == MSG::TYPE::MOUSE) {
			if (Mouse::decode(msg->arg1)) {
				// fR[h
				m_xpos_old = m_xpos;
				m_ypos_old = m_ypos;
				m_xpos += Mouse::mdec.x;
				m_ypos += Mouse::mdec.y;
				if (m_xpos < 0) { m_xpos = 0; }
				if (m_xpos >= buffer_back->get_xsize()) { m_xpos = buffer_back->get_xsize() - 1; }
				if (m_ypos < 0) { m_ypos = 0; }
				if (m_ypos >= buffer_back->get_ysize()) { m_ypos = buffer_back->get_ysize() - 1; }
				dm_xpos = m_xpos - m_xpos_old;
				dm_ypos = m_ypos - m_ypos_old;
				g_shtctl->slide(sheet_mouse, m_xpos, m_ypos);
				
				button = Mouse::mdec.button;
				scroll = Mouse::mdec.scroll;
				
				if (right_pushed != false && Mouse::mdec.button & 0x02) {
					right_pushed = true;
					
				}
				if (button & 0x04) { middle_pushed = true; }
				
				if (!window_drag) {
					int sid = g_shtctl->get_sheetid(m_xpos, m_ypos);
					on_sheet = g_shtctl->get_sheet(sid);
					buffer_win1->box(10, 55, 10 + 8 * 10 - 1, 55 + 32 - 1, Screen::TASKBAR_COLOR);
					sprintf(s, "%04d, %04d", dm_xpos, dm_ypos);
					buffer_win1->putstr(10, 55, s, convC(0x555555));
					sprintf(s, "scroll %2d", scroll);
					buffer_win1->putstr(10, 55 + 16, s, convC(0x555555));
					g_shtctl->refresh(sheet_win1, 10, 55, 10 + 8 * 10, 55 + 32);
					
					buffer_win1->box(10, 55 + 16 * 3, 10 + 8 * 9 - 1, 55 + 16 * 4 - 1, Screen::TASKBAR_COLOR);
					sprintf(s, "sid = %03d", sid);
					buffer_win1->putstr(10, 55 + 16 * 3, s, 0x0000);
					g_shtctl->refresh(sheet_win1, 10, 55 + 16 * 3, 10 + 8 * 9, 55 + 16 * 4);
				} else {
					#if DRAG_FRAME == 1
					g_shtctl->slide(sheet_dframe,
						sheet_dframe->get_xpos() + dm_xpos,
						sheet_dframe->get_ypos() + dm_ypos);
					#elif DRAG_FRAME == 2
					g_shtctl->slide_dragframe(sheet_dframe,
						sheet_dframe->get_xpos() + dm_xpos,
						sheet_dframe->get_ypos() + dm_ypos);
					#endif
				}
/*
				sprintf(s, "lcr scroll=%d", scroll);
				if (button & 0x01) { s[0] = 'L'; }
				if (button & 0x02) { s[2] = 'R'; }
				if (button & 0x04) { s[1] = 'C'; }
				buffer_back->box(0, 32, strlen(s) * 8 + 7, 48 - 1, Screen::BACKGROUND_COLOR);
				buffer_back->putstr(0, 32, s, 0xffff);
				g_shtctl->refresh(sheet_back, 0, 32, strlen(s) * 8 + 8, 48);
				
				if (scroll != 0 && (button & 0x04) == 0) {
					g_shtctl->slide(sheet_win1,
						sheet_win1->get_xpos(), sheet_win1->get_ypos() + 16 * 3 * scroll);
				} else if (scroll != 0 && (button & 0x04) != 0) {
					g_shtctl->slide(sheet_win1,
						sheet_win1->get_xpos() + 16 * 3 * scroll, sheet_win1->get_ypos());
				}
*/

				if (left_pushed == false && button & 0x01) {
					// left push
					left_pushed = true;
					buf_on_sheet = on_sheet->get_buffer();
					xpos_on_sheet = on_sheet->get_xpos();
					ypos_on_sheet = on_sheet->get_ypos();
					if (xpos_on_sheet <= m_xpos &&
						m_xpos <= xpos_on_sheet + buf_on_sheet->get_xsize() &&
						ypos_on_sheet <= m_ypos &&
						m_ypos <= ypos_on_sheet + buf_on_sheet->get_ysize())
					{
						if (!on_sheet->fixed()) {
							g_shtctl->updown(on_sheet, 1000);
							// active_sheetinactiveɁAon_sheetactiveɐ؂ւ
							swap_active(active_sheet, on_sheet);
							active_sheet = on_sheet;
						}
						if (m_ypos <= ypos_on_sheet + 28 && !on_sheet->fixed())
						{
							// EBhẼ^Cgo[ŃNbN
							window_drag = true;
							sheet_dframe = g_shtctl->alloc();
							#if DRAG_FRAME == 1
							sheet_dframe->init(20, 20);
							#elif DRAG_FRAME == 2
							sheet_dframe->init(
								on_sheet->get_buffer()->get_xsize(), on_sheet->get_buffer()->get_ysize());
							sheet_dframe->set_invisible_color(0x0000);
							#endif
							Picture* buffer_dframe = sheet_dframe->get_buffer();
							
							#if DRAG_FRAME == 1
							buffer_dframe->box(0, 0,
								20 - 1, 20 - 1,
								0x0000);
							buffer_dframe->box(8, 0,
								12 - 1, 20 - 1,
								convC(0xC0C0C0));
							buffer_dframe->box(0, 8,
								20 - 1, 12 - 1,
								convC(0xC0C0C0));
							g_shtctl->slide(sheet_dframe,
								on_sheet->get_xpos() - 10, on_sheet->get_ypos() - 10);
							#elif DRAG_FRAME == 2
							buffer_dframe->box(0, 0,
								buffer_dframe->get_xsize() - 1, buffer_dframe->get_ysize() - 1,
								convC(0xC0C0C0));
							buffer_dframe->box(2, 2,
								buffer_dframe->get_xsize() - 3, buffer_dframe->get_ysize() - 3,
								0x0000);
							g_shtctl->slide_dragframe(sheet_dframe,
								on_sheet->get_xpos(), on_sheet->get_ypos());
							#endif
							g_shtctl->updown(sheet_dframe, 1000);
						} else {
							// ^Cgo[ȊOiEBhEjŃNbN
							int to = g_shtctl->get_taskid(on_sheet);
							sprintf(s, "test %d %d", to, on_sheet->get_height());
							*dbg << s;
							g_taskctl->send_message(to,
								Message::create(MSG::TYPE::MOUSE, MSG::MOUSE::COORDINATE, m_xpos, m_ypos, MSG::MOUSE::RIGHT_PUSH)
							);
						}
					}
				} else if (left_pushed && (button & 0x01) == 0) {
					// left release
					left_pushed = false;
					if (window_drag) {
						g_shtctl->updown(sheet_dframe, -1);
//						g_shtctl->updown(sdf_t, -1);
//						g_shtctl->updown(sdf_b, -1);
//						g_shtctl->updown(sdf_l, -1);
//						g_shtctl->updown(sdf_r, -1);
						#if DRAG_FRAME == 1
						g_shtctl->slide(on_sheet,
							sheet_dframe->get_xpos() + 10, sheet_dframe->get_ypos() + 10);
						#elif DRAG_FRAME == 2
						g_shtctl->slide(on_sheet,
							sheet_dframe->get_xpos(), sheet_dframe->get_ypos());
						#endif
						g_shtctl->free(sheet_dframe);
						window_drag = false;
					}
				} else {
					int to = g_shtctl->get_taskid(on_sheet);
					if (scroll != 0) {
						// XN[𑗂
						g_taskctl->send_message(to,
							Message::create(MSG::TYPE::MOUSE, MSG::MOUSE::SCROLL, scroll)
						);
					//} else if (button != 0) {
					} else {
						// W𑗂
						g_taskctl->send_message(to,
							Message::create(MSG::TYPE::MOUSE, MSG::MOUSE::COORDINATE, m_xpos, m_ypos,/* button*/0)
						);
					}
				}
			}
		} else if (msg->type == MSG::TYPE::SYSTEM) {
			if (msg->arg1 == MSG::SYSTEM::WINDOW_CHANGE) {
				Sheet* old_high = g_shtctl->get_sheet_2();
				Sheet* new_high;
				if (!old_high->fixed() && !window_drag) {
					//g_shtctl->updown(old_high, 3);
					//new_high = g_shtctl->get_sheet_2();
					new_high = g_shtctl->get_sheet(g_shtctl->get_sheetid(3));
					g_shtctl->updown(new_high, 1000);
					// active_sheetinactiveɁAon_sheetactiveɐ؂ւ
					swap_active(old_high, new_high);
					active_sheet = new_high;
				}
			}
		}
		fifo->pop();
	}
}
