#include "../../baygui.h"

namespace baygui {
    namespace awt {
        /** {^ipbgj*/
        static unsigned int button_palette[] = {
                                            0xff040204,
                                            0xff8486dc,
                                            0xffdcdafc,
                                            0xff5456b4,
                                            0xffb4b2fc,
                                            0xfff4f2f4,
                                        };

        /** {^if[^j*/
        static unsigned char button_data[] = {
                                                 0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
                                                 0x0,0x5,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x4,0x0,
                                                 0x0,0x2,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x1,0x0,
                                                 0x0,0x2,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x1,0x0,
                                                 0x0,0x2,0x4,0x4,0x5,0x2,0x2,0x2,0x2,0x2,0x2,0x4,0x4,0x4,0x1,0x0,
                                                 0x0,0x2,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x4,0x4,0x1,0x0,
                                                 0x0,0x2,0x4,0x4,0x5,0x2,0x2,0x2,0x2,0x2,0x2,0x4,0x4,0x4,0x1,0x0,
                                                 0x0,0x2,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x4,0x4,0x1,0x0,
                                                 0x0,0x2,0x4,0x4,0x5,0x2,0x2,0x2,0x2,0x2,0x2,0x4,0x4,0x4,0x1,0x0,
                                                 0x0,0x2,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x4,0x4,0x1,0x0,
                                                 0x0,0x2,0x4,0x4,0x5,0x2,0x2,0x2,0x2,0x2,0x2,0x4,0x4,0x4,0x1,0x0,
                                                 0x0,0x2,0x4,0x4,0x4,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x4,0x4,0x1,0x0,
                                                 0x0,0x2,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x1,0x0,
                                                 0x0,0x2,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x1,0x0,
                                                 0x0,0x2,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x1,0x0,
                                                 0x0,0x4,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x0,
                                                 0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
                                             };

        /** ipbgj*/
        static unsigned int arrow_palette[] = {
                                           0xff040204,
                                           0xffcccecc,
                                           0xfffcfefc,
                                           0xffe4e6e4,
                                       };

        /** if[^j*/
        static unsigned char arrow1_data[] = {
                                                 0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
                                                 0x0,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x3,0x0,
                                                 0x0,0x2,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x1,0x0,
                                                 0x0,0x2,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x1,0x0,
                                                 0x0,0x2,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x1,0x0,
                                                 0x0,0x2,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x1,0x0,
                                                 0x0,0x2,0x3,0x3,0x3,0x3,0x3,0x0,0x0,0x3,0x3,0x3,0x3,0x3,0x1,0x0,
                                                 0x0,0x2,0x3,0x3,0x3,0x3,0x0,0x0,0x0,0x0,0x3,0x3,0x3,0x3,0x1,0x0,
                                                 0x0,0x2,0x3,0x3,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x3,0x3,0x1,0x0,
                                                 0x0,0x2,0x3,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x3,0x1,0x0,
                                                 0x0,0x2,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x1,0x0,
                                                 0x0,0x2,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x1,0x0,
                                                 0x0,0x2,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x1,0x0,
                                                 0x0,0x2,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x1,0x0,
                                                 0x0,0x3,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x0,
                                                 0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
                                             };

        /** if[^j*/
        static unsigned char arrow2_data[] = {
                                                 0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
                                                 0x0,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x3,0x0,
                                                 0x0,0x2,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x1,0x0,
                                                 0x0,0x2,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x1,0x0,
                                                 0x0,0x2,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x1,0x0,
                                                 0x0,0x2,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x1,0x0,
                                                 0x0,0x2,0x3,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x3,0x1,0x0,
                                                 0x0,0x2,0x3,0x3,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x3,0x3,0x1,0x0,
                                                 0x0,0x2,0x3,0x3,0x3,0x3,0x0,0x0,0x0,0x0,0x3,0x3,0x3,0x3,0x1,0x0,
                                                 0x0,0x2,0x3,0x3,0x3,0x3,0x3,0x0,0x0,0x3,0x3,0x3,0x3,0x3,0x1,0x0,
                                                 0x0,0x2,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x1,0x0,
                                                 0x0,0x2,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x1,0x0,
                                                 0x0,0x2,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x1,0x0,
                                                 0x0,0x2,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x1,0x0,
                                                 0x0,0x3,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x0,
                                                 0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
                                             };

        /** VXN[o[\z܂B*/
        Scrollbar::Scrollbar() {
            addClassName(baygui_awt_Scrollbar);
            this->orientation = VERTICAL;
            this->minimum   = 0;
            this->maximum   = 100;
            this->blocksize = 10;
            this->preValue  = 0;
            this->value     = 0;
        }

        /** w肳ꂽ̐VXN[o[\z܂B*/
        Scrollbar::Scrollbar(int orientation) {
            addClassName(baygui_awt_Scrollbar);
            this->orientation = orientation;
            this->minimum   = 0;
            this->maximum   = 100;
            this->blocksize = 10;
            this->preValue  = 0;
            this->value     = 0;
        }

        /** fXgN^łB*/
        Scrollbar::~Scrollbar() {
        }

        /** ̃XN[o[́uubNvlԂ܂B*/
        int Scrollbar::getBlocksize() {
            return this->blocksize;
        }

        /** ̃XN[o[̍őlԂ܂B*/
        int Scrollbar::getMaximum() {
            return this->maximum;
        }

        /** ̃XN[o[̍ŏlԂ܂B*/
        int Scrollbar::getMinimum() {
            return this->minimum;
        }

        /** ̃XN[o[̌ݒlԂ܂B*/
        int Scrollbar::getValue() {
            return this->value;
        }

        /** ̃R|[lgyCg܂B*/
        void Scrollbar::paint(Graphics* g) {
            int w = getWidth();
            int h = getHeight();

            /* Og` */
            g->setColor(Color::gray);
            g->fillRect(0, 0, w, h);
            g->setColor(Color::black);
            g->drawRect(0, 0, w, h);

            /* 񊈐̂Ƃ̓{^`悵Ȃ */
            if (isEnabled() == false) return;

            /* őlƍŏlƂ̓{^`悵Ȃ */
            if ((this->maximum - this->minimum) == 0) return;

            /* XN[o[` */
            if (this->orientation == VERTICAL) {
                /* ` */
                for (int i = 0; i < 16; i++) {
                    for (int j = 0; j < 16; j++) {
                        g->setColor(arrow_palette[arrow1_data[i * 16 + j] & 0xFF]);
                        g->drawPixel(j, i);
                    }
                }
                /* ` */
                for (int i = 0; i < 16; i++) {
                    for (int j = 0; j < 16; j++) {
                        g->setColor(arrow_palette[arrow2_data[i * 16 + j] & 0xFF]);
                        g->drawPixel(j, i + h - 16);
                    }
                }
                /* {^` */
                int offset = 15 + (h - 47) * (this->value - this->minimum) / (this->maximum - this->minimum);
                for (int i = 0; i < 17; i++) {
                    for (int j = 0; j < 16; j++) {
                        g->setColor(button_palette[button_data[i * 16 + j] & 0xFF]);
                        g->drawPixel(j, i + offset);
                    }
                }
            /* XN[o[` */
            } else {
                /* ` */
                for (int i = 0; i < 16; i++) {
                    for (int j = 0; j < 16; j++) {
                        g->setColor(arrow_palette[arrow1_data[i * 16 + j] & 0xFF]);
                        g->drawPixel(i, j);
                    }
                }
                /* E` */
                for (int i = 0; i < 16; i++) {
                    for (int j = 0; j < 16; j++) {
                        g->setColor(arrow_palette[arrow2_data[i * 16 + j] & 0xFF]);
                        g->drawPixel(i + w - 16, j);
                    }
                }
                /* {^` */
                int offset = 15 + (w - 47) * (this->value - this->minimum) / (this->maximum - this->minimum);
                for (int i = 0; i < 17; i++) {
                    for (int j = 0; j < 16; j++) {
                        g->setColor(button_palette[button_data[i * 16 + j] & 0xFF]);
                        g->drawPixel(i + offset, j);
                    }
                }
            }
        }

        /** ̃R|[lgŔ}EXCxg܂B*/
        void Scrollbar::processMouseEvent(MouseEvent* e) {
            Component::processMouseEvent(e);

            if (e->getID() == MouseEvent::MOUSE_PRESSED) {
                int mx = e->getX();
                int my = e->getY();

                /* XN[o[̂Ƃ */
                if (this->orientation == VERTICAL) {
                    if (0 < my && my < 16) {
                        setValue(this->value - this->blocksize);
                    } else if (getHeight() - 16 < my && my < getHeight()) {
                        setValue(this->value + this->blocksize);
                    } else {
                        setValue((my - 16) * (this->maximum - this->minimum) / (getHeight() - 32) + this->minimum);
                    }
                /* XN[o[̂Ƃ */
                } else {
                    if (0 < mx && mx < 16) {
                        setValue(this->value - this->blocksize);
                    } else if (getWidth() - 16 < mx && mx < getWidth()) {
                        setValue(this->value + this->blocksize);
                    } else {
                        setValue((mx - 16) * (this->maximum - this->minimum) / (getWidth() - 32) + this->minimum);
                    }
                }
            }
        }

        /** ̃R|[lgŔ}EX[VCxg܂B*/
        void Scrollbar::processMouseMotionEvent(MouseEvent* e) {
            Component::processMouseMotionEvent(e);

            if (e->getID() == MouseEvent::MOUSE_DRAGGED) {
                int mx = e->getX();
                int my = e->getY();

                /* XN[o[̂Ƃ */
                if (this->orientation == VERTICAL) {
                    if (my < 16) {
                        setValue(this->minimum);
                    } else if (my > getHeight() - 16) {
                        setValue(this->maximum);
                    } else {
                        setValue((my - 16) * (this->maximum - this->minimum) / (getHeight() - 32) + this->minimum);
                    }
                /* XN[o[̂Ƃ */
                } else if (this->orientation == HORIZONTAL) {
                    if (mx < 16) {
                        setValue(this->minimum);
                    } else if (mx > getWidth() - 16) {
                        setValue(this->maximum);
                    } else {
                        setValue((mx - 16) * (this->maximum - this->minimum) / (getWidth() - 32) + this->minimum);
                    }
                }
            }
        }

        /** ̃XN[o[́uubNvlݒ肵܂B*/
        void Scrollbar::setBlocksize(int n) {
            this->blocksize = n;
        }

        /** ̃XN[o[̍őlݒ肵܂B*/
        void Scrollbar::setMaximum(int n) {
            this->maximum = n;
        }

        /** ̃XN[o[̍ŏlݒ肵܂B*/
        void Scrollbar::setMinimum(int n) {
            this->minimum = n;
        }

        /**
         * ̃R|[lgړATCYύX܂B
         * XN[o[͕̎16AXN[o[̂Ƃ͍16ɂȂ܂B
         * ȊO̒lݒ肵Ă16ɂȂ܂B
        */
        void Scrollbar::setBounds(int x, int y, int w, int h) {
            if (this->orientation == VERTICAL) {
                Component::setBounds(x, y, 16, h);
            } else {
                Component::setBounds(x, y, w, 16);
            }
        }

        /** ̃XN[o[̒lAw肳ꂽlɐݒ肵܂B*/
        void Scrollbar::setValue(int value) {
            if (value < this->minimum) {
                this->value = this->minimum;
            } else if (value > this->maximum) {
                this->value = this->maximum;
            } else {
                this->value = value;
            }
            repaint();
            #if 0
            if (value < this->preValue) {
                this->adjustmentEvent.setType(Event::BLOCK_DECLEMENT);
                getParent()->processEvent(&this->adjustmentEvent);
            } else {
                this->adjustmentEvent.setType(Event::BLOCK_INCLEMENT);
                getParent()->processEvent(&this->adjustmentEvent);
            }
            #endif
            this->preValue = value;
        }
    }
}
