#ifndef _SYSTEM_LIST_H_INCLUDED_
#define _SYSTEM_LIST_H_INCLUDED_

/* ϒzNX */
template <class T> class List {
public:
    List();
    List(int size);
    List(int size, int increase);
    ~List();

public:
    void add(T element);
    T    get(int index) const;
    T    operator[](int index);
    T    removeAt(int index);
    T    remove(T element);
    void removeAll();
    int  size() const;
    bool isEmpty() const;
    int  indexOf(T element) const;

private:
    T*  data_;        /* z     */
    int size_;        /* z̃TCY */
    int elements_;    /* vf       */
    int increase_;    /*        */

    /*  */
    void init(int size, int increase);
};

/* RXgN^ */
template <class T> List<T>::List() {
    init(5, 5);
    return;
}

/* Rs[RXgN^ */
template <class T> List<T>::List(int size) {
    init(size, 5);
    return;
}

/* Rs[RXgN^ */
template <class T> List<T>::List(int size, int increase) {
    init(size, increase);
    return;
}

/* fXNgN^ */
template <class T> List<T>::~List() {
    /* ̉ */
    delete[] data_;
    return;
}

/* 󂩂ǂԂ */
template <class T> bool List<T>::isEmpty() const {
    return elements_ == 0;
}

/* vfǉ */
template <class T> void List<T>::add(T element) {
    /* z񂪈tɂȂ */
    if (size_ == elements_) {

        /* z2{ɂ */
        size_ += increase_;
        T* temp = new T[size_];

        /* œKH */
        int numElements = elements_;

        /* IWi̔zVzɃRs[ */
        for (int i = 0; i < numElements; i++) {
            temp[i] = data_[i];
        }

        delete[] data_;
        data_ = temp;
    }

    /* vf̒ǉ */
    data_[elements_] = element;
    elements_++;
    return;
}

/* iԖڂ̗vf𓾂 */
template <class T> T List<T>::get(int index) const {
    /* ͈̓`FbN */
    if (index < 0 || index >=elements_) {
        return (T)NULL;
    }
    return data_[index];
}

/* ẑ悤ɃANZX */
template <class T> T List<T>::operator[](int index) {
    return (this->get(index));
}

/* TCY𓾂 */
template <class T> int List<T>::size() const {
    return elements_;
}

/* iԖڂ̗vf폜 */
template <class T> T List<T>::removeAt(int index) {
    /* ͈̓`FbN */
    if (index < 0 || index >=elements_) {
        return (T)NULL;
    }

    /* 폜vfRs[ */
    T toRemove = data_[index];

    /* 󂫂𖄂߂ */
    int numElements = elements_;
    for (int i = index; i < numElements - 1; i++) {
        data_[i] = data_[i + 1];
    }
    elements_--;
    return toRemove;
}

template <class T> T List<T>::remove(T element) {
    /* œKH */
    int size = this->size();

    for (int i = 0; i < size; i++) {
        /* 폜vf */
        if (data_[i] == element) {
            return (removeAt(i));
        }
    }

    return (T)NULL;
}

template <class T> void List<T>::removeAll() {
    /* ̉ */
    delete[] data_;
    init(5, 5);
}

template <class T> void List<T>::init(int size, int increase) {
    /* vf */
    elements_ = 0;

    /* TCYƑݒ */
    size_     = size     > 0 ? size : 5;
    increase_ = increase > 0 ? increase : 5;

    /* z */
    data_ = new T[size_];
    return;
}

template <class T> int List<T>::indexOf(T element) const {
    /* œKH */
    int size = this->size();

    /* vfT */
    for (int i = 0; i < size; i++) {
        /* vf */
        if (data_[i] == element) {
            return i;
        }
    }

    /* Ȃ */
    return -1;
}

#endif
