; haribote-os boot asm
; TAB=4

[INSTRSET "i486p"]

VBEMODE1 		EQU		0x114
VBEMODE1_COL	EQU		16		; 16bitJ[
VBEMODE1_MODEL	EQU		6		; f(_CNg)
VBEMODE2 		EQU		0x101	; 800 x  600 x 8bitJ[
VBEMODE2_COL	EQU		8		; 8bitJ[
VBEMODE2_MODEL	EQU		4		; f(pbg)
; iʃ[hꗗj
;   0x100 :  640 x  400 x 8bitJ[
;   0x101 :  640 x  480 x 8bitJ[
;   0x103 :  800 x  600 x 8bitJ[
;   0x105 : 1024 x  768 x 8bitJ[
;   0x107 : 1280 x 1024 x 8bitJ[
;   0x111 :  640 x  480 x 16bitJ[
;   0x114 :  800 x  600 x 16bitJ[
;   0x117 : 1024 x  768 x 16bitJ[
;   0x11A : 1280 x 1024 x 16bitJ[

BOTPAK  EQU     0x00280000      ; bootpack̃[h
DSKCAC  EQU     0x00100000      ; fBXNLbV̏ꏊ
DSKCAC0 EQU     0x00008000      ; fBXNLbV̏ꏊiA[hj

; BOOT_INFO֌W
CYLS    EQU     0x0900          ; u[gZN^ݒ肷
VMODE   EQU     0x0904          ; FɊւBrbgJ[H
SCRNX   EQU     0x0908          ; 𑜓xX
SCRNY   EQU     0x090c          ; 𑜓xY
LEDS    EQU     0x0910
VRAM    EQU     0x0914          ; OtBbNobt@̊JnԒn

        ORG     0xc200          ; ̃vOǂɓǂݍ܂̂

; VBE݊mF

        MOV     AX,0x9000
        MOV     ES,AX
        MOV     DI,0
        MOV     AX,0x4f00
        INT     0x10
        CMP     AX,0x004f
        JNE     scrn320

; VBẼo[W`FbN

        MOV     AX,[ES:DI+4]
        CMP     AX,0x0200
        JB      scrn320         ; if (AX < 0x0200) goto scrn320

; ʃ[h𓾂
VBECHECK1:
        MOV     CX,VBEMODE1
        MOV     AX,0x4f01
        INT     0x10
        CMP     AX,0x004f
        JNE     VBECHECK2

; ʃ[h̊mF

        CMP     BYTE [ES:DI+0x19],VBEMODE1_COL
        JNE     VBECHECK2
        CMP     BYTE [ES:DI+0x1b],VBEMODE1_MODEL
        JNE     VBECHECK2
        MOV     AX,[ES:DI+0x00]
        AND     AX,0x0080
        JZ      VBECHECK2        ; [hbit70̂ł߂

; ʃ[h̐؂ւ

        MOV     BX,VBEMODE1+0x4000
        MOV     AX,0x4f02
        INT     0x10

        JMP		VBECHECK_END	; ؂ւI

VBECHECK2:
		JMP		VBECHECK2
        MOV     CX,VBEMODE2
        MOV     AX,0x4f01
        INT     0x10
        CMP     AX,0x004f
        JNE     scrn320

; ʃ[h̊mF

        CMP     BYTE [ES:DI+0x19],VBEMODE2_COL
        JNE     scrn320
        CMP     BYTE [ES:DI+0x1b],VBEMODE2_MODEL
        JNE     scrn320
        MOV     AX,[ES:DI+0x00]
        AND     AX,0x0080
        JZ      scrn320         ; [hbit70̂ł߂

; ʃ[h̐؂ւ

        MOV     BX,VBEMODE2+0x4000
        MOV     AX,0x4f02
        INT     0x10
        
        						; ؂ւI

VBECHECK_END:

		MOV		AL,BYTE [ES:DI+0x19]
        MOV     BYTE [VMODE],AL ; ʃ[hiCꂪQƂj
        MOV     AX,[ES:DI+0x12]
        MOV     [SCRNX],AX
        MOV     AX,[ES:DI+0x14]
        MOV     [SCRNY],AX
        MOV     EAX,[ES:DI+0x28]
        MOV     [VRAM],EAX
        JMP     keystatus

scrn320:
        MOV     AL,0x13         ; VGAOtBbNXA320x200x8bitJ[
        MOV     AH,0x00
        INT     0x10
        MOV     DWORD [VMODE],8  ; ʃ[hiCꂪQƂj
        MOV     DWORD [SCRNX],320
        MOV     DWORD [SCRNY],200
        MOV     DWORD [VRAM],0x000a0000

; L[{[hLEDԂBIOSɋĂ炤

keystatus:
        MOV     AH,0x02
        INT     0x16            ; keyboard BIOS
        MOV     [LEDS],AL

; PIC؂̊荞݂󂯕tȂ悤ɂ
;   AT݊@̎dlł́APIC̏ȂA
;   CLIOɂĂȂƁA܂ɃnOAbv
;   PIC̏͂Ƃł

        MOV     AL,0xff
        OUT     0x21,AL
        NOP                     ; OUT߂AƂ܂Ȃ@킪炵̂
        OUT     0xa1,AL

        CLI                     ; CPUxł荞݋֎~

; CPU1MBȏ̃ɃANZXł悤ɁAA20GATEݒ

        CALL    waitkbdout
        MOV     AL,0xd1
        OUT     0x64,AL
        CALL    waitkbdout
        MOV     AL,0xdf         ; enable A20
        OUT     0x60,AL
        CALL    waitkbdout

; veNg[hڍs

        LGDT    [GDTR0]         ; bGDTݒ
        MOV     EAX,CR0
        AND     EAX,0x7fffffff  ; bit310ɂiy[WO֎~̂߁j
        OR      EAX,0x00000001  ; bit01ɂiveNg[hڍŝ߁j
        MOV     CR0,EAX
        JMP     pipelineflash
pipelineflash:
        MOV     AX,1*8          ;  ǂݏ\ZOg32bit
        MOV     DS,AX
        MOV     ES,AX
        MOV     FS,AX
        MOV     GS,AX
        MOV     SS,AX

; bootpack̓]

        MOV     ESI,bootpack    ; ]
        MOV     EDI,BOTPAK      ; ]
        MOV     ECX,512*1024/4
        CALL    memcpy

; łɃfBXNf[^{̈ʒu֓]

; ܂̓u[gZN^

        MOV     ESI,0x7c00      ; ]
        MOV     EDI,DSKCAC      ; ]
        MOV     ECX,512/4
        CALL    memcpy

; cS

        MOV     ESI,DSKCAC0+512 ; ]
        MOV     EDI,DSKCAC+512  ; ]
        MOV     ECX,0
        MOV     CL,BYTE [CYLS]
        IMUL    ECX,512*18*2/4  ; V_oCg/4ɕϊ
        SUB     ECX,512/4       ; IPL̕
        CALL    memcpy

; asmheadłȂ΂ȂƂ͑SÎŁA
;   ƂbootpackɔC

; bootpack̋N

        MOV     EBX,BOTPAK
        MOV     ECX,[EBX+16]
        ADD     ECX,3           ; ECX += 3;
        SHR     ECX,2           ; ECX /= 4;
        JZ      skip            ; ]ׂ̂Ȃ
        MOV     ESI,[EBX+20]    ; ]
        ADD     ESI,EBX
        MOV     EDI,[EBX+12]    ; ]
        CALL    memcpy
skip:
        MOV     ESP,[EBX+12]    ; X^bNl
        JMP     DWORD 2*8:0x0000001b

waitkbdout:
        IN       AL,0x64
        AND      AL,0x02
        JNZ     waitkbdout      ; ANĎʂ0łȂwaitkbdout
        RET

memcpy:
        MOV     EAX,[ESI]
        ADD     ESI,4
        MOV     [EDI],EAX
        ADD     EDI,4
        SUB     ECX,1
        JNZ     memcpy          ; Zʂ0łȂmemcpy
        RET
; memcpy̓AhXTCYvtBNXYȂ΁AXgO߂ł

        ALIGNB  16
GDT0:
        RESB    8               ; kZN^
        DW      0xffff,0x0000,0x9200,0x00cf ; ǂݏ\ZOg32bit
        DW      0xffff,0x0000,0x9a28,0x0047 ; s\ZOg32bitibootpackpj

        DW      0
GDTR0:
        DW      8*3-1
        DD      GDT0

        ALIGNB  16
bootpack:
