#include "../../bootpack.h"
using namespace systemtask;

void system::task_keyboard() {
	Task* task = g_taskctl->get_current_task();
	BootInfo binfo(reinterpret_cast<BootInfo*>(ADR_BOOTINFO));
	queue<Message>* fifo = task->fifo();
	Message* msg = 0;
	byte data[5] = {0, 0, 0, 0, 0};
	Picture* buffer_back = g_sheet_back->get_buffer();
	char s[256];
	int x, y;
	//queue<int> keycmd(32); // L[{[hɃf[^𑗂邽߂fifo
	Timer* tim = g_timerctl->alloc();
	tim->set_task(task, 100);
	static char keytable0[0x80] = {
		0,   0,   '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '^', 0x08, 0,
		'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '@', '[', 0x0a, 0, 'A', 'S',
		'D', 'F', 'G', 'H', 'J', 'K', 'L', ';', ':', 0,   0,   ']', 'Z', 'X', 'C', 'V',
		'B', 'N', 'M', ',', '.', '/', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', '-', '4', '5', '6', '+', '1',
		'2', '3', '0', '.', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0x5c, 0,  0,   0,   0,   0,   0,   0,   0,   0,   0x5c, 0,  0
	};
	static char keytable1[0x80] = {
		0,   0,   '!', 0x22, '#', '$', '%', '&', 0x27, '(', ')', '~', '=', '~', 0x08, 0,
		'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '`', '{', 0x0a, 0, 'A', 'S',
		'D', 'F', 'G', 'H', 'J', 'K', 'L', '+', '*', 0,   0,   '}', 'Z', 'X', 'C', 'V',
		'B', 'N', 'M', '<', '>', '?', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', '-', '4', '5', '6', '+', '1',
		'2', '3', '0', '.', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   '_', 0,   0,   0,   0,   0,   0,   0,   0,   0,   '|', 0,   0
	};
	
	bool Shift = false;
	//bool NumLock = true;
	bool NumLock = false;
	bool ScrollLock = false;
	bool CapsLock = false;
	int key_leds = (binfo.leds >> 4) & 0x07;
	//int key_leds = 0;
//	if (ScrollLock) { key_leds |= 0x01; }
//	if (NumLock) { key_leds |= 0x02; }
//	if (CapsLock) { key_leds |= 0x04; }
	if (key_leds & 0x01) { ScrollLock = true; }
	if (key_leds & 0x02) { NumLock = true; }
	if (key_leds & 0x04) { CapsLock = true; }
	
	while (init_phase == 0); // }EX̏҂
	
	// HႢh~̂߁Aݒ肵Ă
	Keyboard::out(Keyboard::KEYCMD_LED, key_leds);
	//keycmd.push(Keyboard::KEYCMD_LED);
	//keycmd.push(key_leds);
	
	Keyboard::out(0xf3, 0x00 | 0x00); // L[̃s[gxAx
	
	int keycmd_wait = -1;
	IO8 keydat(Keyboard::PORT_KEYDAT);
	
	for (;;) {
		if (g_keycmd->size() > 0 && keycmd_wait < 0) {
			// f[^Aɏ
			keycmd_wait = g_keycmd->back();
			g_keycmd->pop();
			Keyboard::wait_sendready();
			keydat << keycmd_wait;
		}
		io_cli();
		if (fifo->size() == 0) {
			g_taskctl->sleep(task);
			io_sti();
			continue;
		}
		msg = &fifo->back();
		io_sti();
		if (msg->type == MSG::TYPE::KEYBOARD) {
			int to = g_shtctl->get_taskid(active_sheet);
			data[4] = data[3];
			data[3] = data[2];
			data[2] = data[1];
			data[1] = data[0];
			data[0] = msg->arg1;
			sprintf(s, "KEY CODE : %02X -> %02X -> %02X -> %02X -> %02X",
				data[0], data[1], data[2], data[3], data[4]);
			buffer_back->box(0, 16, strlen(s) * 8 - 1, 32 - 1, Screen::BACKGROUND_COLOR);
			buffer_back->putstr(0, 16, s, 0xffff);
			g_shtctl->refresh(g_sheet_back, 0, 16, strlen(s) * 8, 32);
			if (data[0] == 0x01) { // ESCL[Ńu[g
//				pic0_imr << 0xff; // S荞݋֎~
//				pic1_imr << 0xff;
/*				Mouse::out(0xf5); // f[^M֎~
				while (task1_fifo->size() > 0) {
					task1_fifo->pop();
				}
				for (y = 0; y < buffer_back->get_ysize(); y++) {
					for (x = 0; x < buffer_back->get_xsize(); x++) {
						g_screen->point(x, y,
							mixC(
								convC_inv(g_screen->get_color(x, y)), 0xa0a0a0, 50, 50
								)
							);
					}
				}
				*dbg << "rebooting system.";
				dbg->flush();
				cnt_timeout = 0;
				timer_settime(tim, 100);
*/
				g_taskctl->send_message(TASK_POWER,
					Message::create(MSG::TYPE::SYSTEM, MSG::SYSTEM::REBOOT)
					);
			} else if (data[0] == 0x46) {
				// ScrollLock
				ScrollLock = !ScrollLock;
				key_leds ^= 0x01;
				Keyboard::out(Keyboard::KEYCMD_LED, key_leds);
			} else if (data[0] == 0x45) {
				// NumLock
				NumLock = !NumLock;
				key_leds ^= 0x02;
				Keyboard::out(Keyboard::KEYCMD_LED, key_leds);
			} else if (data[0] == 0x3a) {
				// CapsLock
				CapsLock = !CapsLock;
				key_leds ^= 0x04;
				Keyboard::out(Keyboard::KEYCMD_LED, key_leds);
			} else if (data[0] == 0xfa) {
				// ACKAĂ
				keycmd_wait = -1;
			} else if (data[0] == 0xfe) {
				// Ɏ󂯎ȂAx
				Keyboard::wait_sendready();
				keydat << keycmd_wait;
			} else if (data[1] == 0xe0) {
				// gL[R[h
				if (data[0] == 0x48) {
					key_send(to, MSG::KEY::ARROW_UP);
				} else if (data[0] == 0x50) {
					key_send(to, MSG::KEY::ARROW_DOWN);
				} else if (data[0] == 0x4d) {
					key_send(to, MSG::KEY::ARROW_RIGHT);
				} else if (data[0] == 0x4b) {
					key_send(to, MSG::KEY::ARROW_LEFT);
				} else if (data[0] == 0x49) {
					key_send(to, MSG::KEY::PAGE_UP);
				} else if (data[0] == 0x51) {
					key_send(to, MSG::KEY::PAGE_DOWN);
				}
			} else if (data[0] == 0x0f) {
				// TABL[
				*dbg << "tab";
				g_taskctl->send_message(TASK_MOUSE,
					Message::create(MSG::TYPE::SYSTEM, MSG::SYSTEM::WINDOW_CHANGE)
				);
			} else if (data[0] == 0x2a || data[0] == 0x36) {
				// Eshift
				Shift = true;
			} else if (data[0] == 0x2a + 0x80 || data[0] == 0x36 + 0x80) {
				Shift = false;
			} else if (data[0] == 0x1d) {
				// Ctrl
//			} else if (data[0] == 0x38) {
//				// Alt
			} else {
				if (data[0] < 0x80) {
					char c;
					if (Shift) {
						c = keytable1[data[0]];
					} else {
						c = keytable0[data[0]];
					}
					if (((!Shift && !CapsLock) || (Shift && CapsLock)) &&
						('A' <= c && c <= 'Z')) {
						c += 0x20;
					}
//					if (to != -1) {
//						g_taskctl->send_message(to,
//							Message::create(MSG::TYPE::KEYBOARD, c)
//						);
//					}
					if (c != 0) {
						key_send(to, c);
					}
				}
			}
/*		} else if (msg->type == MSG::TYPE::TIMER) {
			if (msg->arg1 == 100) {
				if (cnt_timeout < 2) {
					sprintf(s, "%d", 2 - cnt_timeout);
					cnt_timeout++;
					timer_settime(tim, 100);
					*dbg << s;
					dbg->flush();
				} else {
					io_cli();
					IO8 KBC(0x64);
					KBC << 0xfe; // reboot
					for (;;) { io_hlt(); }
				}
			}
*/		}
		fifo->pop();
	}
}
