#include "../../bootpack.h"
using namespace systemtask;

using namespace startmenu;

void click_menubutton(Sheet* taskbar, SNode* root, int xpos_, int ypos_);
void move_mouse(Sheet* taskbar, SNode* root, int xpos_, int ypos_);

void handler_1101(Task* fromtask)
{
	Message::send(
		TASK_POWER,
		Message::create(MSG::TYPE::SYSTEM, MSG::SYSTEM::REBOOT)
		);
}

void handler_opencons(Task* fromtask)
{
	Task* task_cons = g_taskctl->alloc(1, 1);
	task_cons->set_tss_esp((dword)malloc(64 * 1024) + 64 * 1024);
	task_cons->set_tss_eip((dword)&system::task_console);
	io_cli();
	g_taskctl->run(task_cons);
	io_sti();
}

void make_menubutton(Sheet* taskbar, bool active)
{
	Picture* buffer = taskbar->get_buffer();
	int xsize = 20 + 8 * 5;
	if (active) {
		buffer->box(1, 1, 20 + 8 * 5 - 2, buffer->get_ysize() - 2, convC(0x006400));
		buffer->box(2,  2, xsize - 3,  2, convC(0x567056));
		buffer->box(2,  3, xsize - 3,  3, convC(0x597b5d));
		buffer->box(2,  4, xsize - 3,  4, convC(0x496e4b));
		buffer->box(2,  5, xsize - 3,  5, convC(0x406641));
		buffer->box(2,  6, xsize - 3,  6, convC(0x385f39));
		buffer->box(2,  7, xsize - 3,  7, convC(0x355c37));
		buffer->box(2,  8, xsize - 3,  8, convC(0x305732));
		buffer->box(2,  9, xsize - 3, 10, convC(0x2d532f));
		buffer->box(2, 11, xsize - 3, 15, convC(0x1b3d1c));
		buffer->box(2, 16, xsize - 3, 16, convC(0x193b19));
		buffer->box(2, 17, xsize - 3, 18, convC(0x1c411c));
		buffer->box(2, 19, xsize - 3, 20, convC(0x235123));
		buffer->box(2, 21, xsize - 3, 21, convC(0x265826));
		buffer->box(2, 22, xsize - 3, 23, convC(0x285c28));
		buffer->box(2, 24, xsize - 3, 24, convC(0x688869));
		buffer->putstr(10 + 4, 5, "", 0xffff);
		g_shtctl->refresh(taskbar, 1, 1, 20 + 8 * 5 - 1, buffer->get_ysize() - 1);
	} else {
		buffer->box(1, 1, 20 + 8 * 5 - 2, buffer->get_ysize() - 2, convC(0x101726));
		buffer->box(2,  2, xsize - 3,  3, convC(0x67737c));
		buffer->box(2,  4, xsize - 3,  5, convC(0x626e78));
		buffer->box(2,  6, xsize - 3,  7, convC(0x5c6974));
		buffer->box(2,  8, xsize - 3,  9, convC(0x5a6773));
		buffer->box(2, 10, xsize - 3, 11, convC(0x556271));
		buffer->box(2, 12, xsize - 3, 13, convC(0x4b5767));
		buffer->box(2, 14, xsize - 3, 15, convC(0x334152));
		buffer->box(2, 16, xsize - 3, 17, convC(0x313e4f));
		buffer->box(2, 18, xsize - 3, 19, convC(0x2d394a));
		buffer->box(2, 20, xsize - 3, 21, convC(0x2a3446));
		buffer->box(2, 22, xsize - 3, 23, convC(0x273142));
		buffer->putstr(10 + 4, 5, "", 0xffff);
		g_shtctl->refresh(taskbar, 1, 1, 20 + 8 * 5 - 1, buffer->get_ysize() - 1);
	}
}

void system::make_menuframe(Sheet* menu, bool root)
{
	Picture* buffer = menu->get_buffer();
	const int xsize = buffer->get_xsize();
	const int ysize = buffer->get_ysize();
	if (root) {
		buffer->box(2,  2, xsize - 3,  3, convC(0x67737c));
		buffer->box(2,  4, xsize - 3,  5, convC(0x626e78));
		buffer->box(2,  6, xsize - 3,  7, convC(0x5c6974));
		buffer->box(2,  8, xsize - 3,  9, convC(0x5a6773));
		buffer->box(2, 10, xsize - 3, 11, convC(0x556271));
		buffer->box(2, 12, xsize - 3, 13, convC(0x4b5767));
		buffer->box(2, 14, xsize - 3, 15, convC(0x334152));
		buffer->box(2, 16, xsize - 3, 17, convC(0x313e4f));
		buffer->box(2, 18, xsize - 3, 19, convC(0x2d394a));
		buffer->box(2, 20, xsize - 3, 21, convC(0x2a3446));
		buffer->box(2, 22, xsize - 3, 23, convC(0x273142));
		buffer->box(2, 24, xsize - 3, 25, convC(0x242d3e));
		buffer->box(3, 26, xsize - 3, 27, convC(0x232a3d));
		buffer->box(3, 28, xsize - 3, 28, convC(0x161d2d));
		buffer->box(0,         0,         xsize - 1,         0, convC(0x161d2d));
		buffer->box(0,         0,         0,         ysize - 1, convC(0x161d2d));
		buffer->box(0,         ysize - 1, xsize - 1, ysize - 1, convC(0x161d2d));
		buffer->box(xsize - 1, 0,         xsize - 1, ysize - 1, convC(0x161d2d));
	
		buffer->box(1,         1,         xsize - 2,         1, convC(0x747c85));
		buffer->box(1,         1,         1,         ysize - 2, convC(0x747c85));
		buffer->box(1,         ysize - 2, xsize - 2, ysize - 2, convC(0x747c85));
		buffer->box(xsize - 2, 1,         xsize - 2, ysize - 2, convC(0x747c85));
	
		buffer->box(2,         29,        xsize - 3, 29,        convC(0x161d2d));
		buffer->box(2,         29,        2,         ysize - 3, convC(0x161d2d));
		buffer->box(2,         ysize - 3, xsize - 3, ysize - 3, convC(0x161d2d));
		buffer->box(xsize - 3, 29,        xsize - 3, ysize - 3, convC(0x161d2d));
	} else {
		buffer->box(0,         0,         xsize - 1,         0, convC(0x161d2d));
		buffer->box(0,         0,         0,         ysize - 1, convC(0x161d2d));
		buffer->box(0,         ysize - 1, xsize - 1, ysize - 1, convC(0x161d2d));
		buffer->box(xsize - 1, 0,         xsize - 1, ysize - 1, convC(0x161d2d));
	
		buffer->box(1,         1,         xsize - 2,         1, convC(0x747c85));
		buffer->box(1,         1,         1,         ysize - 2, convC(0x747c85));
		buffer->box(1,         ysize - 2, xsize - 2, ysize - 2, convC(0x747c85));
		buffer->box(xsize - 2, 1,         xsize - 2, ysize - 2, convC(0x747c85));
	
		buffer->box(2,         2,        xsize - 3, 2,        convC(0x161d2d));
		buffer->box(2,         2,        2,         ysize - 3, convC(0x161d2d));
		buffer->box(2,         ysize - 3, xsize - 3, ysize - 3, convC(0x161d2d));
		buffer->box(xsize - 3, 2,        xsize - 3, ysize - 3, convC(0x161d2d));
	}
}

void click_menubutton(Sheet* taskbar, SNode* root, int xpos_, int ypos_)
{
	static bool open = false; // j[JĂ邩ǂ
	bool exec_close = false; // Ƃ邩ǂ
	int xpos = xpos_; // ^XNo[̍
	int ypos = taskbar->get_ypos() - ypos_; // ^XNo[̏(ɍsق+)
	int i, j;
	int clicked_num = 0; // ォ牽Ԗڂ̗vfNbNꂽ
	Task* task = g_taskctl->get_current_task();
	
	const int tb_ypos = taskbar->get_ypos();
	
	if (sb_xpos1 <= xpos && xpos < sb_xpos2 && sb_ypos1 <= -ypos && -ypos < sb_ypos2) {
		// X^[g{^NbN
		if (!open) {
			open = true;
			depth++;
			now_node = root;
			if (root->get_ysize() != -1) {
				root->show_nodes(depth * 200, tb_ypos - root->get_ysize());
			}
			make_menubutton(taskbar, true);
		} else {
			exec_close = true;
		}
	}
	if (ypos >= 0) {
		// ^XNo[NbNꍇ
		if (open) {
			/*
			 * j[JĂƂȏꍇɎsB
			 * ԊKw̐[ƂNbNĂƂ͌Ȃ̂
			 * NbNKwׂāA܂ŕ\߂B
			 */
			int depth_ = xpos / column_width;
			if (depth_ < depth) {
				j = depth - depth_;
				int ypos0 = now_node->get_ypos();
				int row_height0 = now_node->get_row_height();
				for (; j > 0; j--) {
					if (now_node->get_backlink() != NULL) {
						now_node = now_node->get_backlink();
					}
				}
				ypos0 -= now_node->get_ypos();
				ypos0 /= row_height0;
				if (0 <= ypos0 && ypos0 < now_node->size()) {
					now_node->set_color(ypos0, convC(0x556677), convC(0xffffff));
				}
				for (i = 0; i < now_node->size(); i++) {
					now_node->get(i)->close_nodes();
				}
				depth = depth_;
				move_mouse(taskbar, root, xpos_, ypos_);
			}
		}
		if (depth * column_width <= xpos && xpos < (depth + 1) * column_width) {
			clicked_num = ypos_ - now_node->get_ypos();
			clicked_num -= margin_top;
			if (depth == 0) {
				clicked_num -= 30;
			}
			int temp = clicked_num;
			clicked_num /= now_node->get_row_height();
			if (0 <= clicked_num && clicked_num < now_node->size()) {
				if (now_node->get(clicked_num)->size() != 0) {
					// vfł͂Ȃ
					// ܂ATuj[\
					depth++;
					now_node = now_node->get(clicked_num);
					now_node->show_nodes(
						depth * column_width,
						ypos_ - (temp % now_node->get_row_height()) - margin_top
						);
				} else {
					// vfł
					// ܂AR}hs
					//now_node->set_color(clicked_num, convC(0x556677), convC(0xffffff));
					now_node = now_node->get(clicked_num);
					now_node->event_click(task);
					exec_close = true;
				}
			}
		}
	}
	if (exec_close) {
		root->close_nodes();
		open = false;
		depth = -1;
		now_node = NULL;
		exec_close = false;
		make_menubutton(taskbar, false);
		index_old = -1;
	}
}

void move_mouse(Sheet* taskbar, SNode* root, int xpos_, int ypos_)
{
	int i;
	int index = 0;
	
	if (now_node == NULL) {
		return;
	}
	int depth_ = xpos_ / column_width;

	SNode* temp = now_node;
	for (i = depth; i > depth_; i--) {
		//if (temp->get_backlink() != NULL) {
			temp = temp->get_backlink();
		//}
	}
	index = ypos_ - temp->get_ypos();
	index -= margin_top;
	if (depth_ == 0) {
		index -= 30;
	}
	index /= temp->get_row_height();

	if (0 <= index && index < now_node->size()) {
		if (index_old >= 0 && index_old < now_node->size() && index_old != index) {
			now_node->set_color(index_old, convC(0x556677), convC(0xffffff));
		}
		
		if (depth == depth_) {
			//*dbg << "dbg:1000";
			now_node->set_color(index, convC(0x0000ff), convC(0x00ff00));
			index_old = index;
		} else if (depth_ + 1 == depth && index_old >= 0 && index_old < now_node->size()) {
			//*dbg << "dbg:2000";
			now_node->set_color(index_old, convC(0x556677), convC(0xffffff));
			index_old = index;
		}
	} else if (index_old >= 0 && index_old < now_node->size()) {
		now_node->set_color(index_old, convC(0x556677), convC(0xffffff));
		index_old = index;
	}
}


void system::task_taskbar() {
	Picture* buffer_back = g_sheet_back->get_buffer();
	Task* task = g_taskctl->get_current_task();
	queue<Message>* fifo = task->fifo();
	Message* msg = 0;
	int i;
	int depth = -1; // ݕ\̃j[̐[
	
	int mode = 0; // j[\[h 0: 1:
	
	const int row_height = 32; // j[P̍
	
	DateTime date1, date2;
	char s[256];

	Sheet* taskbar = get_sheet_taskid(g_taskctl->get_taskid(task));
	Picture* buffer = taskbar->get_buffer();
	
	const int height0 = taskbar->get_ypos() - 400; // \郁j[̍
	int height = height0;
	
	make_menubutton(taskbar, false);
	
	Timer* tim1 = g_timerctl->alloc();
	tim1->set_task(task, 1);
	timer_settime(tim1, 5);
	Timer* tim2 = g_timerctl->alloc();
	tim2->set_task(task, 2);
	timer_settime(tim2, 3);
	
	bool menu_open = false;
	Sheet* m1 = NULL;
	Picture* b1 = NULL;
	Sheet* m2 = NULL;
	Picture* b2 = NULL;
	
	
	// ɃX^[gj[ɓeo^
	SNode* root = new SNode("root"); // OύXs
	root->set_xsize(200);
	root->set_ysize(400);
	root->fix_sheet();
	m1 = root->get_sheet();
	b1 = m1->get_buffer();

	SNode* snodes = new SNode[32];
	snodes[0].setname("Power +");
	snodes[1].setname("Reboot");
	snodes[0].add(&snodes[1]);
	snodes[0].fix_sheet();
	
	snodes[2].setname("Accessory +");
	snodes[3].setname("Command Prompt");
	snodes[2].add(&snodes[3]);
	snodes[2].fix_sheet();
	
	snodes[4].setname("My Computer");
	
	snodes[5].setname("My Document");
	
	snodes[6].setname("test menu +");
	snodes[6].add(&snodes[7]);
	snodes[7].setname("001 +");
	snodes[7].add(&snodes[8]);
	snodes[8].setname("002 +");
	snodes[8].add(&snodes[9]);
	snodes[9].setname("003");
	snodes[6].fix_sheet();
	snodes[7].fix_sheet();
	snodes[8].fix_sheet();
	
	root->add(&snodes[0]);
	root->add(&snodes[2]);
	root->add(&snodes[4]);
	root->add(&snodes[5]);
	root->add(&snodes[6]);
	
	snodes[1].set_handler(&handler_1101);
	snodes[3].set_handler(&handler_opencons);
	for (;;) {
		io_cli();
		if (fifo->size() == 0) {
			g_taskctl->sleep(task);
			io_sti();
			continue;
		}
		msg = &fifo->back();
		io_sti();
		if (msg->type == MSG::TYPE::TIMER) {
			if (msg->arg1 == 1) {
				timer_settime(tim1, 100);
				buffer->box(buffer->get_xsize() - 6 * 12 - 2, 6, buffer->get_xsize() - 3, 17, Screen::TASKBAR_COLOR);
				sprintf(s, "%02d/%02d  %02d:%02d",
					date1.month, date1.day, date1.hour, date1.minute, date1.second);
				buffer->putstr(buffer->get_xsize() - 6 * 12 - 2, 6, s, 0x0000, font_mini);
				g_shtctl->refresh(taskbar, buffer->get_xsize() - 6 * 12 - 2, 6, buffer->get_xsize() - 2, 18);
				date1.second++;
				if (date1.second >= 60) {
					date1.second = 0;
					date1.minute++;
				}
				if (date1.minute >= 60) {
					date1.minute = 0;
					date1.hour++;
				}
				if (date1.hour >= 24) {
					date1.hour = 0;
					date1.day++;
				}
				if ((date1.day > 31 &&
					(date1.month == 1 || date1.month == 3 || date1.month == 5 ||
					date1.month == 7 || date1.month == 8 || date1.month == 10 ||
					date1.month == 12)) ||
					(date1.day > 30 &&
					(date1.month == 4 || date1.month == 6 || date1.month == 9 ||
					date1.month == 11)) ||
					(date1.day > 28 && date1.month == 2))
				{
					date1.day = 0;
					date1.month++;
				}
				if (date1.month > 12) {
					date1.month = 0;
					date1.year++;
				}
			} else if (msg->arg1 == 2) {
				timer_settime(tim2, 6000);
				RTC::read(&date1);
				RTC::read(&date2);
				int i = 0;
				while (date1 != date2 ||
					(date1.second < 0 || date1.second > 60) ||
					(date1.minute < 0 || date1.minute > 59) ||
					(date1.hour < 0 || date1.hour > 24) ||
					(date1.day < 1 || date1.day > 31) ||
					(date1.month < 1 || date1.month > 12) ||
					(date1.year < 1990))
				{
					RTC::read(&date1);
					RTC::read(&date2);
					if (i > 5) { break; }
					i++;
				}
			}
		} else if (msg->type == MSG::TYPE::MOUSE && msg->arg1 == MSG::MOUSE::COORDINATE) {
			sprintf(s, "clicked %04d, %03d", msg->arg2, msg->arg3);
			buffer->box(200, 7, 200 + 8 * 17 - 1, 22, Screen::TASKBAR_COLOR);
			buffer->putstr(200, 7, s, 0x0000);
			g_shtctl->refresh(taskbar, 200, 7, 200 + 8 * 17, 23);
			if (msg->arg4 == MSG::MOUSE::RIGHT_PUSH) {
				click_menubutton(taskbar, root, msg->arg2, msg->arg3);
			} else if (msg->arg4 == 0) {
				move_mouse(taskbar, root, msg->arg2, msg->arg3);
			}
		}
		fifo->pop();
	}
}
