/* OtBbN֌W */

#include "bootpack.h"

void init_palette(void)
{
	static unsigned char table_rgb[16 * 3] = {
		0x00, 0x00, 0x00,	/*  0: */
		0xff, 0x00, 0x00,	/*  1:邢 */
		0x00, 0xff, 0x00,	/*  2:邢 */
		0xff, 0xff, 0x00,	/*  3:邢F */
		0x00, 0x00, 0xff,	/*  4:邢 */
		0xff, 0x00, 0xff,	/*  5:邢 */
		0x00, 0xff, 0xff,	/*  6:邢F */
		0xff, 0xff, 0xff,	/*  7: */
		0xc6, 0xc6, 0xc6,	/*  8:邢DF */
		0x84, 0x00, 0x00,	/*  9:Â */
		0x00, 0x84, 0x00,	/* 10:Â */
		0x84, 0x84, 0x00,	/* 11:ÂF */
		0x00, 0x00, 0x84,	/* 12:Â */
		0x84, 0x00, 0x84,	/* 13:Â */
		0x00, 0x84, 0x84,	/* 14:ÂF */
		0x84, 0x84, 0x84	/* 15:ÂDF */
	};
	unsigned char table2[216 * 3];
	int r, g, b;
	set_palette(0, 15, table_rgb);
	for (b = 0; b < 6; b++) {
		for (g = 0; g < 6; g++) {
			for (r = 0; r < 6; r++) {
				table2[(r + g * 6 + b * 36) * 3 + 0] = r * 51;
				table2[(r + g * 6 + b * 36) * 3 + 1] = g * 51;
				table2[(r + g * 6 + b * 36) * 3 + 2] = b * 51;
			}
		}
	}
	set_palette(16, 231, table2);
	return;
}

void set_palette(int start, int end, unsigned char *rgb)
{
	int i, eflags;
	eflags = io_load_eflags();	/* 荞݋tO̒lL^ */
	io_cli(); 					/* tO0ɂĊ荞݋֎~ɂ */
	io_out8(0x03c8, start);
	for (i = start; i <= end; i++) {
		io_out8(0x03c9, rgb[0] / 4);
		io_out8(0x03c9, rgb[1] / 4);
		io_out8(0x03c9, rgb[2] / 4);
		rgb += 3;
	}
	io_store_eflags(eflags);	/* 荞݋tOɖ߂ */
	return;
}

void boxfill8(unsigned char *vram, int xsize, unsigned char c, int x0, int y0, int x1, int y1)
{
	int x, y;
	for (y = y0; y <= y1; y++) {
		for (x = x0; x <= x1; x++)
			vram[y * xsize + x] = c;
	}
	return;
}

void init_screen8(char *vram, int x, int y)
{
  boxfill8(vram, x, COL8_FFFFFF,  0,     0,      x -  1, y - 1);

  backwall(vram,x,y,COL8_000000,COL8_000000);

	boxfill8(vram, x, COL8_FFFFFF,  0,     y - 20, x -  1, y - 1);
	boxfill8(vram, x, COL8_C6C6C6,  0,     y - 20, x -  1, y -  19);
	boxfill8(vram, x, COL8_000000,  0,     y - 20, x -  1, y -  20);
	init_corner_l(vram,x,y);

	return;
}

void putfont8(char *vram, int xsize, int x, int y, char c, char *font)
{
	int i;
	char *p, d /* data */;
	for (i = 0; i < 16; i++) {
		p = vram + (y + i) * xsize + x;
		d = font[i];
		if ((d & 0x80) != 0) { p[0] = c; }
		if ((d & 0x40) != 0) { p[1] = c; }
		if ((d & 0x20) != 0) { p[2] = c; }
		if ((d & 0x10) != 0) { p[3] = c; }
		if ((d & 0x08) != 0) { p[4] = c; }
		if ((d & 0x04) != 0) { p[5] = c; }
		if ((d & 0x02) != 0) { p[6] = c; }
		if ((d & 0x01) != 0) { p[7] = c; }
	}
	return;
}

void putfonts8_asc(char *vram, int xsize, int x, int y, char c, unsigned char *s)
{
	extern char hankaku[4096];
	struct TASK *task = task_now();
	char *nihongo = (char *) *((int *) 0x0fe8), *font;
	int k, t;

	if (task->langmode == 0) {
		for (; *s != 0x00; s++) {
			putfont8(vram, xsize, x, y, c, hankaku + *s * 16);
			x += 8;
		}
	}
	if (task->langmode == 1) {
		for (; *s != 0x00; s++) {
			if (task->langbyte1 == 0) {
				if ((0x81 <= *s && *s <= 0x9f) || (0xe0 <= *s && *s <= 0xfc)) {
					task->langbyte1 = *s;
				} else {
					putfont8(vram, xsize, x, y, c, nihongo + *s * 16);
				}
			} else {
				if (0x81 <= task->langbyte1 && task->langbyte1 <= 0x9f) {
					k = (task->langbyte1 - 0x81) * 2;
				} else {
					k = (task->langbyte1 - 0xe0) * 2 + 62;
				}
				if (0x40 <= *s && *s <= 0x7e) {
					t = *s - 0x40;
				} else if (0x80 <= *s && *s <= 0x9e) {
					t = *s - 0x80 + 63;
				} else {
					t = *s - 0x9f;
					k++;
				}
				task->langbyte1 = 0;
				font = nihongo + 256 * 16 + (k * 94 + t) * 32;
				putfont8(vram, xsize, x - 8, y, c, font     );	/*  */
				putfont8(vram, xsize, x    , y, c, font + 16);	/* E */
			}
			x += 8;
		}
	}
	if (task->langmode == 2) {
		for (; *s != 0x00; s++) {
			if (task->langbyte1 == 0) {
				if (0x81 <= *s && *s <= 0xfe) {
					task->langbyte1 = *s;
				} else {
					putfont8(vram, xsize, x, y, c, nihongo + *s * 16);
				}
			} else {
				k = task->langbyte1 - 0xa1;
				t = *s - 0xa1;
				task->langbyte1 = 0;
				font = nihongo + 256 * 16 + (k * 94 + t) * 32;
				putfont8(vram, xsize, x - 8, y, c, font     );	/*  */
				putfont8(vram, xsize, x    , y, c, font + 16);	/* E */
			}
			x += 8;
		}
	}
	return;
}

void init_mouse_cursor8(char *mouse, char bc)
/* }EXJ[\i16x16j */
{
	static char cursor[16][16] = {
"***.............",
 "*OO***..........",
 "*OOOOO***.......",
 "O*OOOOOOO***....",
 "O*OOOOOOOOOO*...",
 "O*OOOOOOOOO*....",
 ".O*OOOOOOO*.....",
 ".O*OOOOOO*......",
 ".O*OOOOOOO*.....",
 "..O*OOO*OOO*....",
 "..O*OO*O*OOO*...",
 "..O*O*..O*OOO*..",
 "...O*....O*OOO*.",
 "..........O*OOO*",
 "...........O*O*O",
 "............O*O."
	};
	int x, y;

	for (y = 0; y < 16; y++) {
		for (x = 0; x < 16; x++) {
			if (cursor[y][x] == '*') {
				mouse[y * 16 + x] = COL8_000000;
			}
			if (cursor[y][x] == 'O') {
				mouse[y * 16 + x] = COL8_FFFFFF;
			}
			if (cursor[y][x] == '.') {
				mouse[y * 16 + x] = bc;
			}
		}
	}
	return;
}

void putblock8_8(char *vram, int vxsize, int pxsize,
	int pysize, int px0, int py0, char *buf, int bxsize)
{
	int x, y;
	for (y = 0; y < pysize; y++) {
		for (x = 0; x < pxsize; x++) {
			vram[(py0 + y) * vxsize + (px0 + x)] = buf[y * bxsize + x];
		}
	}
	return;
}





void init_corner_l(char *vram,int xsize,int ysize)
/* ǂiWxWj */
{
	static char cursor[8][8] = {

 "*******O",
 "*****O..",
 "***O....",
 "**O.....",
 "*O.......",
 "*O......",
 "*.......",
 "O......."

	};
	int x, y;

	for (y = 0; y < 8; y++) {
		for (x = 0; x < 8; x++) {
			if (cursor[y][x] == '*') {
	  			vram[(ysize-y)*xsize   +    x] = COL8_000000;
			 	vram[(ysize-y)*xsize+xsize -  x-1] = COL8_000000;
				vram[y*xsize + x] = COL8_000000;
				vram[(y+1)*xsize - x-1] = COL8_000000;
			}
			if (cursor[y][x] == 'O') {
			  	vram[(ysize-y)*xsize   +    x] = COL8_848484;
			  	vram[(ysize-y)*xsize+xsize -  x-1] = COL8_848484;
				vram[y*xsize + x] = COL8_848484;
				vram[(y+1)*xsize - x-1] = COL8_848484;				
			}

		}
	}
	return;
}

void backwall(unsigned char *vram, int xv,int yv, unsigned char c,unsigned char bc)
{
	int x, y;

	for (y = 0; y < yv; y=y+4) {
	  for (x = 0; x < xv; x=x+4){

	    if (y%8==0){
	      vram[y*xv+x]=bc;
	    }
	    else{
	      vram[y*xv+x+2]=bc;
	    }


		}
	}

	return;
}



