/* RS232̐
written by uchan
*/
#include "bootpack.h"
#include "string.h"

#define NULL 0

void rs232_cli(void); /* rs232IRQ荞݂𖳌ɂ */
void rs232_sti(void); /* rs232IRQ荞݂Lɂ */
void rs232_baudrate(struct ComPort *COM, int baudrate);

struct ComPort COM1, COM2;

void inthandler23(int *esp)
/* IRQ-3 : COM2 */
{
	io_out8(PIC0_OCW2, 0x63);	/* IRQ-03tPIC0ɒʒm */
	return;
}

void inthandler24(int *esp)
/* IRQ-4 : COM1 */
{
	char intID;
	char intTrig; /* ǂ̊荞ݗvŊ荞񂾂̂ */
	/* ܂C^vgID𒲂ׂ */
	intID = io_in8(0x3fa);

	if((intID & 0x01) != 0)/* 荞ݖ */
	{
		io_out8(PIC0_OCW2, 0x64);	/* IRQ-04tPIC0ɒʒm */
		return;
	}

	intTrig = (intID >> 1) & 0x07;
	if((intID & 0xc0) == 0x00)
	/* 16450݊[hł */
	{
		switch(intTrig)/* DxقǏɏĂ */
		{
		case 0x03: /* Rx line status */
			break;
		case 0x02: /* Rx data */
			fifo32_put(&COM1.RxData, (int)io_in8(0x3f8));
			break;
		case 0x01: /* Tx data empty */
			if(fifo32_status(&COM1.TxData) > 0) /* Mf[^󂶂Ȃ瑗M */
			{
				io_out8(0x3f8, fifo32_get(&COM1.TxData));
			}
			break;
		case 0x00: /* modem status */
			break;
		default:
			break;
		}
	} else if((intID & 0xc0) == 0xc0)
	/* 16550݊[hł */
	{
		switch(intTrig)/* DxقǏɏĂ */
		{
		case 0x03: /* Rx line status */
			break;
		case 0x02: /* Rx FIFO trigger  */
			break;
		case 0x06: /* Rx FIFO time-out */
			break;
		case 0x01: /* Tx FIFO empty */
			break;
		case 0x00: /* modem status */
			break;
		default:
			break;
		}
	}
	io_out8(PIC0_OCW2, 0x64);	/* IRQ-04tPIC0ɒʒm */
	return;
}

void init_rs232(void)
{
	/* 16550݊[h16450݊[h邪A16450݊[hg
	AFIFORg[WX^(0x03FA)bit00ɂB*/

	strcpy(COM1.PortName, "COM1");
	strcpy(COM2.PortName, "COM2");
	fifo32_init(&(COM1.RxData), 128, COM1.RxDataBuf, 0);
	fifo32_init(&(COM1.TxData), 128, COM1.TxDataBuf, 0);
	fifo32_init(&(COM2.RxData), 128, COM2.RxDataBuf, 0);
	fifo32_init(&(COM2.TxData), 128, COM2.TxDataBuf, 0);
	COM1.baudrate = 0;
	COM1.IRQ_enable = 0x03;
	COM1.line_ctrl = 0x03;
	COM1.modem_ctrl = 0x08;
	COM1.task = NULL;
	COM2.baudrate = 0; /* 0 */
	COM2.IRQ_enable = 0x03; /* IRQ́AMf[^荞݂ƁAMf[^󊄂荞 */
	COM2.line_ctrl = 0x03; /* 8bit */
	COM2.modem_ctrl = 0x00; /* PINS */
	COM2.task = NULL;
	/*
	RS232̏B
	*/
	rs232_cli();

//	io_out8(0x3fb, 0x80);
//	io_out8(0x3f8, 0x0c);
	io_out8(0x3fb, COM1.line_ctrl); /* 8bit */
//	io_out8(0x3fb, 0x03);
	io_out8(0x3fc, COM1.modem_ctrl); /* PINS */
//	io_out8(0x3fc, 0x00);
	io_out8(0x3f9, COM1.IRQ_enable); /* IRQ́AMf[^荞݂̂ */
//	io_out8(0x3f9, 0x00);
	rs232_baudrate(&COM1, 9600);

	io_out8(0x2fb, COM2.line_ctrl); /* 8bit */
	io_out8(0x2fc, COM2.modem_ctrl); /* PINS */
	io_out8(0x2f9, COM2.IRQ_enable); /* IRQ́AMf[^荞݂̂ */
	rs232_baudrate(&COM2, 9600);

	io_in8(0x3f8); /* ǂ */
	io_in8(0x2f8); /* ǂ */

	rs232_sti();
	/*
	ݒ芮B
	*/
	io_out8(0x3f8, 'c');
	io_out8(0x3f8, 'o');
	io_out8(0x3f8, 'n');
	io_out8(0x3f8, 'e');
	io_out8(0x3f8, 'c');
	io_out8(0x3f8, 't');
	io_out8(0x3f8, 'e');
	io_out8(0x3f8, 'd');
}

void rs232_cli(void)
/* rs232IRQ荞݂𖳌ɂ */
{
	char status;
	status = io_in8(PIC0_IMR);
	status |= 0x18; /* COM1,2IRQ֎~ */
	io_out8(PIC0_IMR, status);
	return;
}
void rs232_sti(void)
/* rs232IRQ荞݂Lɂ */
{
	char status;
	status = io_in8(PIC0_IMR);
	status &= 0xe7; /* COM1,2IRQ */
	io_out8(PIC0_IMR, status);
	return;
}

void rs232_baudrate(struct ComPort *COM, int baudrate)
/*
{[[gݒ֐

	baudrate : ݒ肵{[[gl(ex.9600)
*/
{
	char LSB = 0, MSB = 0;
	char line_control;
	switch(baudrate)
	{
	case 115200:
		LSB = 0x01;
		break;
	case 57600:
		LSB = 0x02;
		break;
	case 38400:
		LSB = 0x03;
		break;
	case 19200:
		LSB = 0x06;
		break;
	case 9600:
		LSB = 0x0c;
		break;
	case 4800:
		LSB = 0x18;
		break;
	case 2400:
		LSB = 0x30;
		break;
	case 1200:
		LSB = 0x60;
		break;
	case 600:
		LSB = 0xc0;
		break;
	case 300:
		MSB = 0x01;
		LSB = 0x80;
		break;
	default:
		MSB = 0x00;
		LSB = 0x0c;
	}
	if(strcmp(COM->PortName, "COM1") == 0)
	{
		line_control = io_in8(0x03fb);
		io_out8(0x3fb, (line_control | 0x80)); /* {[[gݒ\ɂ */
		io_out8(0x3f8, LSB); /* {[[gLSB */
		io_out8(0x3f9, MSB); /* {[[gMSB(LSBƕ9600bps) */
		io_out8(0x3fb, line_control); /* ݒɖ߂ */
		COM->baudrate = baudrate;
	} else if(strcmp(COM->PortName, "COM2") == 0)
	{
		line_control = io_in8(0x02fb);
		io_out8(0x2fb, (line_control | 0x80)); /* {[[gݒ\ɂ */
		io_out8(0x2f8, LSB); /* {[[gLSB */
		io_out8(0x2f9, MSB); /* {[[gMSB(LSBƕ9600bps) */
		io_out8(0x2fb, line_control); /* ݒɖ߂ */
		COM->baudrate = baudrate;
	}
}

int rs232_put(struct ComPort *COM, char data, struct TASK *task)
{
	static int first = 1;

	if(COM->task != task){ return -3; /* sI */ }

	if(first == 1)/* ߂Ẵf[^M */
	{
		first = 0;
		if(strcmp(COM->PortName, "COM1") == 0)
		{
			io_out8(0x3f8, data);
		} else if(strcmp(COM->PortName, "COM2") == 0)
		{
			io_out8(0x2f8, data);
		}
		return 0; /* I */
	}
	io_cli();
	if((io_in8(0x3fd) & 0x40) == 0x00 && first == 0)
	/* f[^̑MĂȂB܂AM荞݂B */
	{
		fifo32_put(&COM->TxData, data);
		io_sti(); /* f[^FIFOɓOɊ荞܂ƁÃf[^͑MꂸcĂ܂B */
	} else if((io_in8(0x3fd) & 0x40) == 0x40 && first == 0)
	/* f[^̑MĂB܂AɑM */
	{
		io_sti();
		if(strcmp(COM->PortName, "COM1") == 0)
		{
			io_out8(0x3f8, data);
		} else if(strcmp(COM->PortName, "COM2") == 0)
		{
			io_out8(0x2f8, data);
		}
	}
	io_sti();
	return 0; /* I */
}

int rs232_get(struct ComPort *COM, struct TASK *task)
{
	if(COM->task != task){ return -3; /* sI */ }
	return fifo32_get(&COM->RxData);
//	return 'b';
}

signed int open_rs232(struct ComPort *COM, struct TASK *task)
{
	if((int)COM->task == NULL)
	{
		COM->task = task;
		return 0; /* I */
	}
	else
	{
		return -1; /* sI */
	}
	return -3;
}

int close_rs232(struct ComPort *COM, struct TASK *task)
{
	if(COM->task == task)
	{
		COM->task = NULL;
		return 0; /* I */
	}
	else
	{
		return -1; /* sI */
	}
	return -3;
}



