// HaritomoDhtmlDlg.cpp : t@C
//

#include "stdafx.h"
#include "HaritomoDhtml.h"
#include "HaritomoDhtmlDlg.h"
#include "HaritomoAbout.h"

#include <exdispid.h>

#define OSASK_IMAGE_PATH		"OSASK/osask.img"
#define HIYOS_IMAGE_PATH		"HiyOS/hiyos.img"
#define RAPUOS_IMAGE_PATH		"rapuOS/rapuos.img"
#define BAYOS_IMAGE_PATH		"BayOS/fd_image/haribote.img"
#define OSAKKIE_IMAGE_PATH		"OSAkkie/OSAkkie.img"
#define MTORZ_IMAGE_PATH		"Mtorz/mtorz.img"
#define SERIBOTEOS_IMAGE_PATH	"seriboteOS/seribote.img"
#define BITNOS_IMAGE_PATH		"BitNOS/bitnos/bitnos.img"
#define HARIBOTEOS_IMAGE_PATH	"haribote.img"
#define THEBBLOS_IMAGE_PATH		"TheBBL/haribote.img"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// CHaritomoDhtmlDlg _CAO

BEGIN_DHTML_EVENT_MAP(CHaritomoDhtmlDlg)
	DHTML_EVENT_ONCLICK(_T("ButtonOK"), OnButtonOK)
	DHTML_EVENT_ONCLICK(_T("ButtonCancel"), OnButtonCancel)
	DHTML_EVENT_ONCLICK(_T("OSASK"), OnOSASK)
	DHTML_EVENT_ONCLICK(_T("HiyOS"), OnHiyOS)
	DHTML_EVENT_ONCLICK(_T("rapuOS"), OnRapuOS)
	DHTML_EVENT_ONCLICK(_T("BayOS"), OnBayOS)
	DHTML_EVENT_ONCLICK(_T("OSAkkie"), OnOSAkkie)
	DHTML_EVENT_ONCLICK(_T("Mtorz"), OnMtorz)
	DHTML_EVENT_ONCLICK(_T("seriboteOS"), OnSeriboteOS)
	DHTML_EVENT_ONCLICK(_T("BitNOS"), OnBitNOS)
	DHTML_EVENT_ONCLICK(_T("HariboteOS"), OnHariboteOS)
	DHTML_EVENT_ONCLICK(_T("NewMember"), OnNewMember)
	DHTML_EVENT_ONCLICK(_T("THEBBLOS"), OnTHEBBLOS)
	DHTML_EVENT_ONMOUSEOVER(_T("OSASK"), OnOSASKMouseOver)
	DHTML_EVENT_ONMOUSEOVER(_T("HiyOS"), OnHiyOSMouseOver)
	DHTML_EVENT_ONMOUSEOVER(_T("rapuOS"), OnRapuOSMouseOver)
	DHTML_EVENT_ONMOUSEOVER(_T("BayOS"), OnBayOSMouseOver)
	DHTML_EVENT_ONMOUSEOVER(_T("OSAkkie"), OnOSAkkieMouseOver)
	DHTML_EVENT_ONMOUSEOVER(_T("Mtorz"), OnMtorzMouseOver)
	DHTML_EVENT_ONMOUSEOVER(_T("seriboteOS"), OnSeriboteOSMouseOver)
	DHTML_EVENT_ONMOUSEOVER(_T("BitNOS"), OnBitNOSMouseOver)
	DHTML_EVENT_ONMOUSEOVER(_T("HariboteOS"), OnHariboteOSMouseOver)
	DHTML_EVENT_ONMOUSEOVER(_T("NewMember"), OnNewMemberMouseOver)
	DHTML_EVENT_ONMOUSEOVER(_T("THEBBLOS"), OnTHEBBLOSMouseOver)
	DHTML_EVENT_ONMOUSEOVER(_T("Unknown"), OnUnknownMouseOver)
	
	//DHTML_EVENT_TAG_ALL(DISPID_HTMLELEMENTEVENTS_ONMOUSEOVER, OnMouseOverElement )
END_DHTML_EVENT_MAP()

CHaritomoDhtmlDlg::CHaritomoDhtmlDlg(CWnd* pParent /*=NULL*/)
	: CDHtmlDialog(CHaritomoDhtmlDlg::IDD, NULL /*CHaritomoDhtmlDlg::IDH*/, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CHaritomoDhtmlDlg::DoDataExchange(CDataExchange* pDX)
{
	CDHtmlDialog::DoDataExchange(pDX);
	DDX_DHtml_ElementInnerText(pDX, _T("Message"), m_Message);
}

BEGIN_MESSAGE_MAP(CHaritomoDhtmlDlg, CDHtmlDialog)
	ON_WM_SYSCOMMAND()
	//}}AFX_MSG_MAP
	ON_COMMAND(IDM_EXIT, &CHaritomoDhtmlDlg::OnExit)
	ON_COMMAND(IDM_URL_HARITOMO, &CHaritomoDhtmlDlg::OnHaritomo)
	ON_COMMAND(IDM_URL_OSASK, &CHaritomoDhtmlDlg::OnOsask)
	ON_COMMAND(IDM_URL_HIYOS, &CHaritomoDhtmlDlg::OnUrlHiyos)
	ON_COMMAND(IDM_URL_RAPUOS, &CHaritomoDhtmlDlg::OnUrlRapuos)
	ON_COMMAND(IDM_URL_BAYOS, &CHaritomoDhtmlDlg::OnUrlBayos)
	ON_COMMAND(IDM_URL_OSAKKIE, &CHaritomoDhtmlDlg::OnUrlOsakkie)
	ON_COMMAND(IDM_URL_SERIBOTEOS, &CHaritomoDhtmlDlg::OnUrlSeriboteOS)
	ON_COMMAND(IDM_ABOUT, &CHaritomoDhtmlDlg::OnAbout)
	ON_COMMAND(IDM_URL_BITNOS, &CHaritomoDhtmlDlg::OnUrlBitnos)
END_MESSAGE_MAP()

BEGIN_EVENTSINK_MAP(CHaritomoDhtmlDlg, CDHtmlDialog)
	ON_EVENT(CHaritomoDhtmlDlg, AFX_IDC_BROWSER, DISPID_BEFORENAVIGATE2, OnBeforeNavigate2, VTS_DISPATCH VTS_PVARIANT VTS_PVARIANT VTS_PVARIANT VTS_PVARIANT VTS_PVARIANT VTS_PBOOL)
END_EVENTSINK_MAP()

// CHaritomoDhtmlDlg bZ[W nh

BOOL CHaritomoDhtmlDlg::OnInitDialog()
{
	CDHtmlDialog::OnInitDialog();
	// TODO: ɒǉ܂B

	char tmp[MAX_PATH];
	char *ptrEnd;
	GetModuleFileName(NULL, tmp, MAX_PATH);
	if ( (ptrEnd = strrchr(tmp, '\\')) != NULL ) {*ptrEnd = '\0';}
	// eLXgfBNg̐ݒ
	m_TextDir.Format("%s\\text\\", tmp);

	Navigate(_T("file://") + ((CHaritomoDhtmlApp*)AfxGetApp())->m_HaritomoDialogPath);

	if ( (ptrEnd = strrchr(tmp, '\\')) != NULL ) {*ptrEnd = '\0';}

	OSVERSIONINFO OSVersionInfo;
	OSVersionInfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx(&OSVersionInfo);
	IsNT = OSVersionInfo.dwPlatformId == VER_PLATFORM_WIN32_NT;
	IsNT6 = (OSVersionInfo.dwMajorVersion >= 6);

	m_OsImageDir.Format("%s/OS/", tmp);
	m_OsImageDir.Replace("\\", "/");
		
	if(IsNT){
		m_QemuPath.Format("%s\\qemu\\nt\\qemu.exe", tmp);
		m_QemuDir.Format("%s\\qemu\\nt\\", tmp);
	}else{
		m_QemuPath.Format("%s\\qemu\\9x\\qemu.exe", tmp);
		m_QemuDir.Format("%s\\qemu\\9x\\", tmp);
	}
	m_SerialQemuPath.Format("%s\\qemu\\serial\\qemu.exe", tmp);
	m_SerialQemuDir.Format("%s\\qemu\\serial\\", tmp);

	LoadText(m_TextDir + "haritomo.txt", &m_HaritomoMessage);
	LoadText(m_TextDir + "keikaku.txt", &m_KeikakuMessage);
	LoadText(m_TextDir + "OSASK.txt", &m_OSASKMessage);
	LoadText(m_TextDir + "HiyOS.txt", &m_HiyOSMessage);
	LoadText(m_TextDir + "rapuOS.txt", &m_RapuOSMessage);
	LoadText(m_TextDir + "BayOS.txt", &m_BayOSMessage);
	LoadText(m_TextDir + "OSAkkie.txt", &m_OSAkkieMessage);
	LoadText(m_TextDir + "Mtorz.txt", &m_MtorzMessage);
	LoadText(m_TextDir + "seriboteOS.txt", &m_SeriboteOSMessage);
	LoadText(m_TextDir + "BitNOS.txt", &m_BitNOSMessage);
	LoadText(m_TextDir + "HariboteOS.txt", &m_HariboteOSMessage);
	LoadText(m_TextDir + "NewMember.txt", &m_NewMemberMessage);
	LoadText(m_TextDir + "THEBBLOS.txt", &m_THEBBLOSMessage);
	LoadText(m_TextDir + "Unknown.txt", &m_UnknownMessage);

	m_Message = m_OSASKMessage;
	UpdateData(FALSE);

	SetIcon(m_hIcon, TRUE);			// 傫ACR̐ݒ
	SetIcon(m_hIcon, FALSE);		// ACR̐ݒ

	return TRUE;  // tH[JXRg[ɐݒ肵ꍇATRUE Ԃ܂B
}

void CHaritomoDhtmlDlg::LoadText(CString file, CString *message)
{
	char str[64 * 1024 + 1];
	DWORD count;

	HANDLE hFile;
	hFile = CreateFile(file, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if(hFile != INVALID_HANDLE_VALUE){
		ReadFile(hFile, str, 64 * 1024, &count, NULL);
		str[count] = '\0';
		message->Format("%s", str);
	}
	CloseHandle(hFile);
}

void CHaritomoDhtmlDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	CDHtmlDialog::OnSysCommand(nID, lParam);
}

// _CAOɍŏ{^ǉꍇAACR`悷邽߂
//  ̃R[hKvłBhLg/r[ fg MFC AvP[V̏ꍇA
//  ́AFramework ɂĎIɐݒ肳܂B

void CHaritomoDhtmlDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// NCAg̎lp`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR̕`
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDHtmlDialog::OnPaint();
	}
}

// [U[ŏEBhEhbOĂƂɕ\J[\擾邽߂ɁA
//  VXe̊֐Ăяo܂B
HCURSOR CHaritomoDhtmlDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CHaritomoDhtmlDlg::OnBeforeNavigate2(LPDISPATCH pDisp, VARIANT FAR* URL, VARIANT FAR* Flags, VARIANT FAR* TargetFrameName, VARIANT FAR* PostData, VARIANT FAR* Headers, BOOL FAR* Cancel)
{
	static int count = 0;
	if(count < 2){ // , HTMLt@Cւ̈ړ
		count++;
		return;
	}
	*Cancel = TRUE;
	/**/
}

//------------------------------------------------------------------------------------
//  
//  DHTML_EVENT_ONCLICK
//  
//------------------------------------------------------------------------------------

HRESULT CHaritomoDhtmlDlg::OnButtonOK(IHTMLElement* /*pElement*/)
{
//	OnOK();
	return S_OK;
}

HRESULT CHaritomoDhtmlDlg::OnButtonCancel(IHTMLElement* /*pElement*/)
{
	OnCancel();
	return S_OK;
}


HRESULT CHaritomoDhtmlDlg::OnOSASK(IHTMLElement* /*pElement*/)
{
	m_QemuOption = " -L . -m 32 -localtime -std-vga ";
	if(IsNT){
		m_QemuOption += "-soundhw all -fda ";
	}else{
		m_QemuOption += "-fda ";
	}
	m_QemuOption += "\"" + m_OsImageDir + OSASK_IMAGE_PATH + "\"";

	ShellExecute(NULL, "open", m_QemuPath, m_QemuOption, m_QemuDir, SW_SHOWNORMAL);

	return S_OK;
}

HRESULT CHaritomoDhtmlDlg::OnHiyOS(IHTMLElement* /*pElement*/)
{
	m_QemuOption = " -L . -m 32 -localtime -std-vga ";
	if(IsNT){
		m_QemuOption += "-soundhw all -fda ";
	}else{
		m_QemuOption += "-fda ";
	}
	m_QemuOption += "\"" + m_OsImageDir + HIYOS_IMAGE_PATH + "\"";
	ShellExecute(NULL, "open", m_QemuPath, m_QemuOption, m_QemuDir, SW_SHOWNORMAL);
	return S_OK;
}

HRESULT CHaritomoDhtmlDlg::OnRapuOS(IHTMLElement* /*pElement*/)
{
	m_QemuOption = " -L . -m 32 -localtime -std-vga ";
	if(IsNT){
		m_QemuOption += "-soundhw all -fda ";
	}else{
		m_QemuOption += "-fda ";
	}
	m_QemuOption += "\"" + m_OsImageDir + RAPUOS_IMAGE_PATH + "\"";
	ShellExecute(NULL, "open", m_QemuPath, m_QemuOption, m_QemuDir, SW_SHOWNORMAL);
	return S_OK;
}

HRESULT CHaritomoDhtmlDlg::OnBayOS(IHTMLElement* /*pElement*/)
{
	m_QemuOption = " -L . -m 32 -localtime -std-vga ";
	if(IsNT){
		m_QemuOption += "-soundhw all -fda ";
	}else{
		m_QemuOption += "-fda ";
	}
	m_QemuOption += "\"" + m_OsImageDir + BAYOS_IMAGE_PATH + "\"";
	ShellExecute(NULL, "open", m_QemuPath, m_QemuOption, m_QemuDir, SW_SHOWNORMAL);
	return S_OK;
}

HRESULT CHaritomoDhtmlDlg::OnOSAkkie(IHTMLElement* /*pElement*/)
{
	m_QemuOption = " -L . -m 32 -localtime -std-vga ";
	if(IsNT){
		m_QemuOption += "-soundhw all -fda ";
	}else{
		m_QemuOption += "-fda ";
	}
	m_QemuOption += "\"" + m_OsImageDir + OSAKKIE_IMAGE_PATH + "\"";
	ShellExecute(NULL, "open", m_QemuPath, m_QemuOption, m_QemuDir, SW_SHOWNORMAL);
	return S_OK;
}

HRESULT CHaritomoDhtmlDlg::OnMtorz(IHTMLElement* /*pElement*/)
{
	m_QemuOption = " -L . -m 32 -localtime -std-vga ";
	if(IsNT){
		m_QemuOption += "-soundhw all -fda ";
	}else{
		m_QemuOption += "-fda ";
	}
	m_QemuOption += "\"" + m_OsImageDir + MTORZ_IMAGE_PATH + "\"";
	ShellExecute(NULL, "open", m_QemuPath, m_QemuOption, m_QemuDir, SW_SHOWNORMAL);
	return S_OK;
}

HRESULT CHaritomoDhtmlDlg::OnSeriboteOS(IHTMLElement* /*pElement*/)
{
	m_QemuOption = " -L . -m 32 -localtime -std-vga -serial COM1 ";
	if(IsNT6){
		MessageBox("ɐ\󂲂܂񂪁useriboteOSvVista+QEMUł͓삳邱Ƃł܂B\n萔܂@łB");
		return S_FALSE;
	}else if(IsNT){
		m_QemuOption += "-soundhw all -fda ";
	}else{
		MessageBox("ɐ\󂲂܂񂪁useriboteOSv9xpQEMUœ삳邱Ƃł܂B\n萔܂@łB");
		return S_FALSE;
	}
	m_QemuOption += "\"" + m_OsImageDir + SERIBOTEOS_IMAGE_PATH + "\"";

	ShellExecute(NULL, "open", m_SerialQemuPath, m_QemuOption, m_SerialQemuDir, SW_SHOWNORMAL);
	return S_OK;
}

HRESULT CHaritomoDhtmlDlg::OnBitNOS(IHTMLElement* /*pElement*/)
{
	m_QemuOption = " -L . -m 32 -localtime -std-vga ";
	if(IsNT){
		m_QemuOption += "-soundhw all -fda ";
	}else{
		m_QemuOption += "-fda ";
	}
	m_QemuOption += "\"" + m_OsImageDir + BITNOS_IMAGE_PATH + "\"";
	ShellExecute(NULL, "open", m_QemuPath, m_QemuOption, m_QemuDir, SW_SHOWNORMAL);
	return S_OK;
}

HRESULT CHaritomoDhtmlDlg::OnTHEBBLOS(IHTMLElement* /*pElement*/)
{
	m_QemuOption = " -L . -m 32 -localtime -std-vga ";
	if(IsNT){
		m_QemuOption += "-soundhw all -fda ";
	}else{
		m_QemuOption += "-fda ";
	}
	m_QemuOption += "\"" + m_OsImageDir + THEBBLOS_IMAGE_PATH + "\"";
	ShellExecute(NULL, "open", m_QemuPath, m_QemuOption, m_QemuDir, SW_SHOWNORMAL);
	return S_OK;
}

HRESULT CHaritomoDhtmlDlg::OnHariboteOS(IHTMLElement* /*pElement*/)
{
	m_QemuOption = " -L . -m 32 -localtime -std-vga ";
	if(IsNT){
		m_QemuOption += "-soundhw all -fda ";
	}else{
		m_QemuOption += "-fda ";
	}
	m_QemuOption += "\"" + m_OsImageDir + HARIBOTEOS_IMAGE_PATH + "\"";
	ShellExecute(NULL, "open", m_QemuPath, m_QemuOption, m_QemuDir, SW_SHOWNORMAL);
	return S_OK;
}

HRESULT CHaritomoDhtmlDlg::OnNewMember(IHTMLElement* /*pElement*/)
{
	ShellExecute(NULL, "open", "http://haribote.org/", NULL, NULL, SW_SHOWNORMAL);
	return S_OK;
}

//------------------------------------------------------------------------------------
//  
//  DHTML_EVENT_ONMOUSEOVER
//  
//------------------------------------------------------------------------------------


HRESULT CHaritomoDhtmlDlg::OnOSASKMouseOver(IHTMLElement *pElement)
{
	m_Message = m_OSASKMessage;
	UpdateData(FALSE);
	return S_OK;
}

HRESULT CHaritomoDhtmlDlg::OnHiyOSMouseOver(IHTMLElement *pElement)
{
	m_Message = m_HiyOSMessage;
	UpdateData(FALSE);
	return S_OK;
}

HRESULT CHaritomoDhtmlDlg::OnRapuOSMouseOver(IHTMLElement *pElement)
{
	m_Message = m_RapuOSMessage;
	UpdateData(FALSE);
	return S_OK;
}

HRESULT CHaritomoDhtmlDlg::OnBayOSMouseOver(IHTMLElement *pElement)
{
	m_Message = m_BayOSMessage;
	UpdateData(FALSE);
	return S_OK;
}

HRESULT CHaritomoDhtmlDlg::OnOSAkkieMouseOver(IHTMLElement *pElement)
{
	m_Message = m_OSAkkieMessage;
	UpdateData(FALSE);
	return S_OK;
}

HRESULT CHaritomoDhtmlDlg::OnMtorzMouseOver(IHTMLElement *pElement)
{
	m_Message = m_MtorzMessage;
	UpdateData(FALSE);
	return S_OK;
}

HRESULT CHaritomoDhtmlDlg::OnSeriboteOSMouseOver(IHTMLElement *pElement)
{
	m_Message = m_SeriboteOSMessage;
	UpdateData(FALSE);
	return S_OK;
}

HRESULT CHaritomoDhtmlDlg::OnBitNOSMouseOver(IHTMLElement *pElement)
{
	m_Message = m_BitNOSMessage;
	UpdateData(FALSE);
	return S_OK;
}

HRESULT CHaritomoDhtmlDlg::OnHariboteOSMouseOver(IHTMLElement *pElement)
{
	m_Message = m_HariboteOSMessage;
	UpdateData(FALSE);
	return S_OK;
}

HRESULT CHaritomoDhtmlDlg::OnNewMemberMouseOver(IHTMLElement *pElement)
{
	m_Message = m_NewMemberMessage;
	UpdateData(FALSE);
	return S_OK;
}

HRESULT CHaritomoDhtmlDlg::OnUnknownMouseOver(IHTMLElement *pElement)
{
	m_Message = m_UnknownMessage;
	UpdateData(FALSE);
	return S_OK;
}

HRESULT CHaritomoDhtmlDlg::OnTHEBBLOSMouseOver(IHTMLElement *pElement)
{
	m_Message = m_THEBBLOSMessage;
	UpdateData(FALSE);
	return S_OK;
}

//------------------------------------------------------------------------------------
//  
//  j[
//  
//------------------------------------------------------------------------------------

void CHaritomoDhtmlDlg::OnExit()
{
	OnOK();
}

void CHaritomoDhtmlDlg::OnHaritomo()
{
	ShellExecute(NULL, "open", "http://haribote.org/", NULL, NULL, SW_SHOWNORMAL);
}

void CHaritomoDhtmlDlg::OnOsask()
{
	ShellExecute(NULL, "open", "http://osask.jp/", NULL, NULL, SW_SHOWNORMAL);
}

void CHaritomoDhtmlDlg::OnUrlHiyos()
{
	ShellExecute(NULL, "open", "http://hiyos.info/", NULL, NULL, SW_SHOWNORMAL);
}

void CHaritomoDhtmlDlg::OnUrlRapuos()
{
	ShellExecute(NULL, "open", "http://www.rapuos.net/", NULL, NULL, SW_SHOWNORMAL);
}

void CHaritomoDhtmlDlg::OnUrlBayos()
{
	ShellExecute(NULL, "open", "http://caffe-latte.sourceforge.jp/pukiwiki/index.php?TopPage", NULL, NULL, SW_SHOWNORMAL);
}

void CHaritomoDhtmlDlg::OnUrlOsakkie()
{
	ShellExecute(NULL, "open", "http://koya.marokun.net/osakkie/", NULL, NULL, SW_SHOWNORMAL);
}


void CHaritomoDhtmlDlg::OnUrlBitnos()
{
	ShellExecute(NULL, "open", "http://nos.zisaku.com/index.php?FrontPage", NULL, NULL, SW_SHOWNORMAL);
}


void CHaritomoDhtmlDlg::OnUrlSeriboteOS()
{
	ShellExecute(NULL, "open", "http://nos.zisaku.com/index.php?seriboteOS", NULL, NULL, SW_SHOWNORMAL);
}

void CHaritomoDhtmlDlg::OnUrlTHEBBLOS()
{
	ShellExecute(NULL, "open", "http://thebbl.hideyosi.com/", NULL, NULL, SW_SHOWNORMAL);
}

void CHaritomoDhtmlDlg::OnAbout()
{
	CHaritomoAbout dlg;
	dlg.DoModal();
}

//------------------------------------------------------------------------------------
//  
//  s̎c[
//  
//------------------------------------------------------------------------------------

/*
	CString cstr;
	CComBSTR bstr;
	IHTMLStyle *phtmlStyle;
	phtmlElement->get_innerText(&bstr);
	if(bstr){cstr = bstr;}

*/
//	CString cstr = CString(*URL);
//	if(cstr.Find("#OSASK") != -1){OnOSASK(NULL);}
//	else if(cstr.Find("#HiyOS") != -1){OnHiyOS(NULL);}

/*
HRESULT CHaritomoDhtmlDlg::OnMouseOverElement(IHTMLElement *phtmlElement)
{
	CString cstr;
	CComBSTR bstr;
	phtmlElement->get_innerText(&bstr);
	m_Message = bstr;

	if(cstr.Find("OSASK") != -1){m_Message = m_OsMessage[0];}
	else if(cstr.Find("HiyOS") != -1){m_Message = m_OsMessage[1];}
*/
/*
	IHTMLStyle *phtmlStyle;
	phtmlElement->get_style(&phtmlStyle);
	if (phtmlStyle)
	{
		CComBSTR v;
		CString cstr = "url(res:/BMP/#144)";
		v = cstr;
		phtmlStyle->put_background(v);
		phtmlStyle->put_cursor(L"hand");
		phtmlStyle->Release();
	}
	UpdateData(FALSE);

	return S_OK;
}
*/
/*
HRESULT CHaritomoDhtmlDlg::OnMouseOutElement(IHTMLElement *phtmlElement)
{

	IHTMLStyle *phtmlStyle;
	phtmlElement->get_style(&phtmlStyle);
	if (phtmlStyle)
	{
		CComBSTR v;
		CString cstr = "url(res:/BMP/#145)";
		v = cstr;
		phtmlStyle->put_background(v);
		phtmlStyle->put_cursor(L"");
		phtmlStyle->Release();
	}

	UpdateData(FALSE);

	return S_OK;
}
*/
