/*
 * Decompiled with CFR 0.152.
 */
package twitter.task;

import java.util.HashSet;
import java.util.Set;
import twitter.task.ExistTimerIDException;

public class TimerID {
    private static TimerID timerID;
    private Set<String> idList = new HashSet<String>();

    private TimerID() {
    }

    public static synchronized TimerID getInstance() {
        if (timerID == null) {
            timerID = new TimerID();
        }
        return timerID;
    }

    public boolean contains(String id) {
        return this.idList.contains(id);
    }

    public void addID(String id) throws ExistTimerIDException {
        if (this.contains(id)) {
            throw new ExistTimerIDException("\u65e2\u306b\u305d\u306eID\u306f\u5b58\u5728\u3057\u3066\u3044\u307e\u3059");
        }
        if (id == null) {
            throw new NullPointerException();
        }
        this.idList.add(id);
    }

    public boolean removeID(String id) {
        return this.idList.remove(id);
    }

    public static String createSearchTimerID(String searchWord) {
        return "SEARCH:" + searchWord;
    }

    public static String createFavoriteID(String screenName) {
        return "FAV:" + screenName;
    }

    public static String createTimelineID() {
        return "TIMELINE";
    }

    public static String createMentionID() {
        return "MENTION";
    }

    public static String createDirectMessageID() {
        return "DIRECTMESSAGE";
    }

    public static String createSendDirectMessageID() {
        return "SENDDIRECTMESSAGE";
    }

    public static String createUserTimelineID(long userID) {
        return "USERTIMELINE:" + userID;
    }

    public static String createUserListID(String username, long listID) {
        return "LIST:" + username + ":" + listID;
    }
}

