#ifndef _NT_COOKIE_H_ 
#define _NT_COOKIE_H_
#include "utils/nt_std_t.h"

typedef struct tag_nt_cookie_t  *nt_cookie_tp;
typedef struct tag_nt_cookie_t {
	char *db_file_name;
	nt_link_tp cookies; /* the data content is a nt_key_value_tp */
}nt_cookie_t;

extern nt_cookie_tp nt_load_cookies(const char *db_path);
extern void nt_unload_cookie(nt_cookie_tp cookie);
extern BOOL nt_add_cookie(nt_cookie_tp cookiep,
			const char *domain, const char *value);
extern nt_link_tp  nt_get_cookies(nt_cookie_tp cookiep, 
		const char *host_name);

#endif /* _NT_COOKIE_H_ */
