#ifndef _NT_USR_DB_H_ 
#define _NT_USR_DB_H_

typedef struct tag_nt_usr_db_thread_data_t *nt_usr_db_thread_data_tp;
typedef struct tag_nt_usr_db_thread_data_t{
     int read_count;
	 wchar_t *dat_name;
}nt_usr_db_thread_data_t;

extern void nt_usr_db_thread_data_free(void *ptr);
extern int nt_usr_db_get_read_count_by_dat_name(
    nt_link_tp thread_data_list, const wchar_t *dat_name);


extern void* nt_usr_db_init(const char *db_path);
extern void nt_usr_db_finish(void *db_handle);
extern BOOL nt_usr_db_open(void *db_handle);
extern void nt_usr_db_close(void *db_handle);
extern int nt_usr_db_update_read_count(void *db_handle,
     const wchar_t *board_name, const wchar_t *dat_name, int prev_read);
extern nt_link_tp nt_usr_db_query_read_count_list(void *db_handle,
	const wchar_t *board_name);


#endif /* _NT_USR_DB_H_ */
