#include <sys/types.h>
#include <sys/socket.h>
/* OpenSSL headers */
#include <openssl/bio.h>
#include <openssl/ssl.h>
#include <openssl/err.h>

#include "utils/nt_std_t.h"



BOOL nt_ssl_connect(
			const char *connect_host_string,
			const char *pem_path,
			BOOL strict_verify, 
			char *wr_buf, 
			size_t *data_lenp,
			size_t buf_len)
{
	SSL_CTX  *ctx;
	SSL *ssl;
	BIO *bio;
	BOOL result = FALSE;
	int n, idx;
	int data_len;

	data_len = *data_lenp;

	SSL_load_error_strings();
	SSL_library_init();

	ctx = SSL_CTX_new(SSLv23_client_method());
	if(!ctx){
		return FALSE;
	}
	
	if(!SSL_CTX_load_verify_locations(ctx, pem_path, NULL))
		goto ERROR_TRAP2;

	bio = BIO_new_ssl_connect(ctx);
	if(!bio)
		goto ERROR_TRAP2;

	BIO_get_ssl(bio, &ssl);
	SSL_set_mode(ssl, SSL_MODE_AUTO_RETRY);

	BIO_set_conn_hostname(bio, connect_host_string); 

	if(BIO_do_connect(bio) <= 0)
		goto ERROR_TRAP1;
	
	if(SSL_get_verify_result(ssl) != X509_V_OK){
		if(strict_verify)
			goto ERROR_TRAP1;
	}


	idx = 0;
	while(idx < data_len){
		n = BIO_write(bio, wr_buf+idx, data_len-idx);
		if(n <= 0 && !BIO_should_retry(bio))
			goto ERROR_TRAP1;
		idx += n;
	}
	idx = 0;
	while(1){
		n = BIO_read(bio, wr_buf+idx, buf_len-idx);
		if(n < 0)
			goto ERROR_TRAP1;
		if(n == 0)
			break;
		idx += n;
		if(idx >= buf_len)
			goto ERROR_TRAP1;
	}
	*data_lenp = idx;
	
	result = TRUE;


ERROR_TRAP1:
	BIO_free_all(bio);
ERROR_TRAP2:
	SSL_CTX_free(ctx);

	ERR_free_strings();

	return result;
}
