#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <openssl/sha.h>

#include "utils/nt_std_t.h"
#include "utils/base64.h"
#include "utils/crypt.h"


BOOL nt_make_sha1_string(const char *org_name, 
			char *outbuf, size_t outbuf_len)
{
	assert(outbuf != NULL);
	assert(outbuf_len > SHA_DIGEST_LENGTH*2+1);
	assert(org_name != NULL);

	SHA_CTX ctx;
	unsigned char md[SHA_DIGEST_LENGTH]; 
	char *outptr;
	int i , len;
	
	SHA1_Init(&ctx);

	len =  strlen(org_name);
	
	SHA1_Update(&ctx, org_name, len+1);

	SHA1_Final(&(md[0]), &ctx);
 
 	outptr = outbuf;
	for(i = 0; i < SHA_DIGEST_LENGTH; i++){
		sprintf(outptr, "%02x", md[i]);
		outptr += 2;
	}
	while(outptr < (outbuf+outbuf_len)){
		*outptr = '\0';
		outptr++;
	}
	return TRUE;
}
