/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#ifndef _DISP_STRING_H_
#define _DISP_STRING_H_
#include <wchar.h>

extern int nt_add_wch(WINDOW *w, wchar_t wc, attr_t attr);
extern int nt_add_wnch(WINDOW *w, wchar_t wc, 
				attr_t attr, size_t colmns);
extern int nt_add_wstr(WINDOW *w, wchar_t *wc, attr_t attr);
extern int nt_add_wnstr(WINDOW *w, wchar_t *wc, 
				attr_t attr, size_t colmns);

extern int nt_get_wc_count_within_colmns(wchar_t *src, size_t colmns);
extern int nt_get_column_length(const wchar_t *wc);

#endif /* _DISP_STRING_H_ */
