/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#ifndef _NT_SOCKET_H_
#define _NT_SOCKET_H_

#include "utils/nt_mutex.h"

typedef struct tag_nt_socket_t *nt_socket_tp;
typedef struct tag_nt_socket_t{
	struct sockaddr_in  _sockaddr_in;
	nt_mutex_handle h_mutex;
} nt_socket_t;

extern nt_socket_tp nt_socket_init(int port, char *addr);
extern void nt_socket_free(nt_socket_tp socketp);
extern int nt_socket_connect(nt_socket_tp socketp, char* data, int data_len);

extern BOOL nt_ssl_connect(
	const char *connect_host_string,
	const char *pem_path,
	BOOL strict_verify,
	char *wr_buf,
	size_t *data_lenp,
	size_t buf_len);

#endif /* _NT_SOCKET_H_ */
