<?php

require_once(NUE_LIB_ROOT . '/state/CEmptyState.php');

/**
 *	ԂIuWFNgB
 */
class CEntity
{

	/**	ȌԁB */
	private $previousState;

	/**	݂̏ԁB */
	private $currentState;

	/**	̏ԁB */
	private $nextState;

	/**
	 *	RXgN^B
	 *
	 *	@param $firstState ŏ̏ԁBłnullB
	 */
	public function __construct(IState $firstState = null)
	{
		$this->previousState = CEmptyState::getInstance();
		$this->currentState = CEmptyState::getInstance();
		$this->setNextState($firstState);
		$this->commitNextState();
	}

	/**
	 *	fXgN^B
	 */
	function __destruct()
	{
		$this->dispose();
	}

	/**
	 *	ȌԂ擾܂B
	 *
	 *	@return IState ȌԁB
	 */
	public function getPreviousState()
	{
		return $this->previousState;
	}

	/**
	 *	݂̏Ԃ擾܂B
	 *
	 *	@return IState ݂̏ԁB
	 */
	public function getCurrentState()
	{
		return $this->currentState;
	}

	/**
	 *	̏Ԃ擾܂B
	 *
	 *	@return IState ̏ԁB
	 */
	public function getNextState()
	{
		return $this->nextState;
	}

	/**
	 *	̏Ԃݒ肵܂B
	 *
	 *	@patam IState $nextState ̏ԁB
	 */
	public function setNextState(IState $nextState = null)
	{
		$this->nextState = $nextState;
	}

	/**
	 *	s܂B
	 */
	public function execute()
	{
		$this->getCurrentState()->execute($this);
		$this->commitNextState();
	}

	/**
	 *	\񂳂ꂽ̏Ԃm肵܂B
	 *
	 *	@param boolean ԂJڂꍇAtrueB
	 */
	public function commitNextState()
	{
		if($this->getNextState() !== null)
		{
			$this->getCurrentState()->teardown($this);
		}
		$result = $this->getNextState() !== null;
		if($result)
		{
			$this->previousState = $this->currentState;
			$this->currentState = $this->nextState;
			$this->nextState = null;
			$this->getCurrentState()->setup($this);
		}
		return $result;
	}

	/**
	 *	ԂZbg܂B
	 */
	public function dispose()
	{
		$this->setNextState(CEmptyState::getInstance());
		$this->commitNextState();
		$this->previousState = CEmptyState::getInstance();
		$this->currentState = CEmptyState::getInstance();
		$this->nextState = null;
	}
}

?>
