/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import jp.nyatla.nyartoolkit.NyARException;

public class NyARCode {
    private int[][][][] pat;
    private double[] patpow = new double[4];
    private short[][][] patBW;
    private double[] patpowBW = new double[4];
    private int width;
    private int height;

    public int[][][][] getPat() {
        return this.pat;
    }

    public double[] getPatPow() {
        return this.patpow;
    }

    public short[][][] getPatBW() {
        return this.patBW;
    }

    public double[] getPatPowBW() {
        return this.patpowBW;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public NyARCode(int i_width, int i_height) {
        this.width = i_width;
        this.height = i_height;
        this.pat = new int[4][this.height][this.width][3];
        this.patBW = new short[4][this.height][this.width];
    }

    public void loadFromARFile(String filename) throws NyARException {
        try {
            this.loadFromARFile(new FileInputStream(filename));
        }
        catch (Exception e) {
            throw new NyARException(e);
        }
    }

    public void loadFromARFile(InputStream i_stream) throws NyARException {
        try {
            StreamTokenizer st = new StreamTokenizer(new InputStreamReader(i_stream));
            for (int h = 0; h < 4; ++h) {
                int i2;
                int i;
                int l = 0;
                for (int i3 = 0; i3 < 3; ++i3) {
                    for (int i22 = 0; i22 < this.height; ++i22) {
                        for (int i1 = 0; i1 < this.width; ++i1) {
                            switch (st.nextToken()) {
                                case -2: {
                                    break;
                                }
                                default: {
                                    throw new NyARException();
                                }
                            }
                            short j = (short)(255.0 - st.nval);
                            switch (i3) {
                                case 0: {
                                    this.pat[h][i22][i1][2] = j;
                                    break;
                                }
                                case 1: {
                                    this.pat[h][i22][i1][1] = j;
                                    break;
                                }
                                case 2: {
                                    this.pat[h][i22][i1][0] = j;
                                }
                            }
                            if (i3 == 0) {
                                this.patBW[h][i22][i1] = j;
                            } else {
                                short[] sArray = this.patBW[h][i22];
                                int n = i1;
                                sArray[n] = (short)(sArray[n] + j);
                            }
                            if (i3 == 2) {
                                short[] sArray = this.patBW[h][i22];
                                int n = i1;
                                sArray[n] = (short)(sArray[n] / 3);
                            }
                            l += j;
                        }
                    }
                }
                l /= this.height * this.width * 3;
                int m = 0;
                for (i = 0; i < this.height; ++i) {
                    for (i2 = 0; i2 < this.width; ++i2) {
                        for (int i3 = 0; i3 < 3; ++i3) {
                            int[] nArray = this.pat[h][i][i2];
                            int n = i3;
                            nArray[n] = nArray[n] - l;
                            m += this.pat[h][i][i2][i3] * this.pat[h][i][i2][i3];
                        }
                    }
                }
                this.patpow[h] = Math.sqrt(m);
                if (this.patpow[h] == 0.0) {
                    this.patpow[h] = 1.0E-7;
                }
                m = 0;
                for (i = 0; i < this.height; ++i) {
                    for (i2 = 0; i2 < this.width; ++i2) {
                        short[] sArray = this.patBW[h][i];
                        int n = i2;
                        sArray[n] = (short)(sArray[n] - l);
                        m += this.patBW[h][i][i2] * this.patBW[h][i][i2];
                    }
                }
                this.patpowBW[h] = Math.sqrt(m);
                if (this.patpowBW[h] != 0.0) continue;
                this.patpowBW[h] = 1.0E-7;
            }
        }
        catch (Exception e) {
            throw new NyARException(e);
        }
    }
}

