/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARMat;
import jp.nyatla.nyartoolkit.core.NyARParam;
import jp.nyatla.nyartoolkit.core.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.NyARTransRot;

abstract class NyARTransRot_OptimizeCommon
implements NyARTransRot {
    protected final int number_of_vertex;
    protected final double[] array = new double[9];
    protected final NyARParam cparam;
    private final double[] wk_check_dir_world = new double[6];
    private final double[] wk_check_dir_camera = new double[4];
    private final NyARMat wk_check_dir_NyARMat = new NyARMat(3, 3);

    @Override
    public final void initRotByPrevResult(NyARTransMatResult i_prev_result) {
        double[][] prev_array = i_prev_result.getArray();
        double[] L_rot = this.array;
        double[] pt = prev_array[0];
        L_rot[0] = pt[0];
        L_rot[1] = pt[1];
        L_rot[2] = pt[2];
        pt = prev_array[1];
        L_rot[3] = pt[0];
        L_rot[4] = pt[1];
        L_rot[5] = pt[2];
        pt = prev_array[2];
        L_rot[6] = pt[0];
        L_rot[7] = pt[1];
        L_rot[8] = pt[2];
    }

    @Override
    public final double[] getArray() {
        return this.array;
    }

    public NyARTransRot_OptimizeCommon(NyARParam i_param, int i_number_of_vertex) throws NyARException {
        this.number_of_vertex = i_number_of_vertex;
        this.cparam = i_param;
    }

    protected final void check_dir(double[] dir, double[] st, double[] ed, double[] cpara) throws NyARException {
        int i;
        NyARMat mat_a = this.wk_check_dir_NyARMat;
        double[][] a_array = mat_a.getArray();
        for (int j = 0; j < 3; ++j) {
            for (i = 0; i < 3; ++i) {
                a_array[j][i] = cpara[j * 4 + i];
            }
        }
        mat_a.matrixSelfInv();
        double[] world = this.wk_check_dir_world;
        world[0] = a_array[0][0] * st[0] * 10.0 + a_array[0][1] * st[1] * 10.0 + a_array[0][2] * 10.0;
        world[1] = a_array[1][0] * st[0] * 10.0 + a_array[1][1] * st[1] * 10.0 + a_array[1][2] * 10.0;
        world[2] = a_array[2][0] * st[0] * 10.0 + a_array[2][1] * st[1] * 10.0 + a_array[2][2] * 10.0;
        world[3] = world[0] + dir[0];
        world[4] = world[1] + dir[1];
        world[5] = world[2] + dir[2];
        double[] camera = this.wk_check_dir_camera;
        for (i = 0; i < 2; ++i) {
            double h = cpara[8] * world[i * 3 + 0] + cpara[9] * world[i * 3 + 1] + cpara[10] * world[i * 3 + 2];
            if (h == 0.0) {
                throw new NyARException();
            }
            camera[i * 2 + 0] = (cpara[0] * world[i * 3 + 0] + cpara[1] * world[i * 3 + 1] + cpara[2] * world[i * 3 + 2]) / h;
            camera[i * 2 + 1] = (cpara[4] * world[i * 3 + 0] + cpara[5] * world[i * 3 + 1] + cpara[6] * world[i * 3 + 2]) / h;
        }
        double v = (ed[0] - st[0]) * (camera[2] - camera[0]) + (ed[1] - st[1]) * (camera[3] - camera[1]);
        if (v < 0.0) {
            dir[0] = -dir[0];
            dir[1] = -dir[1];
            dir[2] = -dir[2];
        }
    }

    protected static final void check_rotation(double[][] rot) throws NyARException {
        double e4;
        double e3;
        double e2;
        double e1;
        int f;
        double[] v1 = new double[3];
        double[] v2 = new double[3];
        double[] v3 = new double[3];
        v1[0] = rot[0][0];
        v1[1] = rot[0][1];
        v1[2] = rot[0][2];
        v2[0] = rot[1][0];
        v2[1] = rot[1][1];
        v2[2] = rot[1][2];
        v3[0] = v1[1] * v2[2] - v1[2] * v2[1];
        v3[1] = v1[2] * v2[0] - v1[0] * v2[2];
        v3[2] = v1[0] * v2[1] - v1[1] * v2[0];
        double w = Math.sqrt(v3[0] * v3[0] + v3[1] * v3[1] + v3[2] * v3[2]);
        if (w == 0.0) {
            throw new NyARException();
        }
        v3[0] = v3[0] / w;
        v3[1] = v3[1] / w;
        v3[2] = v3[2] / w;
        double cb = v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];
        if (cb < 0.0) {
            cb *= -1.0;
        }
        double ca = (Math.sqrt(cb + 1.0) + Math.sqrt(1.0 - cb)) * 0.5;
        if (v3[1] * v1[0] - v1[1] * v3[0] != 0.0) {
            f = 0;
        } else if (v3[2] * v1[0] - v1[2] * v3[0] != 0.0) {
            w = v1[1];
            v1[1] = v1[2];
            v1[2] = w;
            w = v3[1];
            v3[1] = v3[2];
            v3[2] = w;
            f = 1;
        } else {
            w = v1[0];
            v1[0] = v1[2];
            v1[2] = w;
            w = v3[0];
            v3[0] = v3[2];
            v3[2] = w;
            f = 2;
        }
        if (v3[1] * v1[0] - v1[1] * v3[0] == 0.0) {
            throw new NyARException();
        }
        double k1 = (v1[1] * v3[2] - v3[1] * v1[2]) / (v3[1] * v1[0] - v1[1] * v3[0]);
        double k2 = v3[1] * ca / (v3[1] * v1[0] - v1[1] * v3[0]);
        double k3 = (v1[0] * v3[2] - v3[0] * v1[2]) / (v3[0] * v1[1] - v1[0] * v3[1]);
        double k4 = v3[0] * ca / (v3[0] * v1[1] - v1[0] * v3[1]);
        double b = k1 * k2 + k3 * k4;
        double a = k1 * k1 + k3 * k3 + 1.0;
        double c = k2 * k2 + k4 * k4 - 1.0;
        double d = b * b - a * c;
        if (d < 0.0) {
            throw new NyARException();
        }
        double r1 = (-b + Math.sqrt(d)) / a;
        double p1 = k1 * r1 + k2;
        double q1 = k3 * r1 + k4;
        double r2 = (-b - Math.sqrt(d)) / a;
        double p2 = k1 * r2 + k2;
        double q2 = k3 * r2 + k4;
        if (f == 1) {
            w = q1;
            q1 = r1;
            r1 = w;
            w = q2;
            q2 = r2;
            r2 = w;
            w = v1[1];
            v1[1] = v1[2];
            v1[2] = w;
            w = v3[1];
            v3[1] = v3[2];
            v3[2] = w;
            f = 0;
        }
        if (f == 2) {
            w = p1;
            p1 = r1;
            r1 = w;
            w = p2;
            p2 = r2;
            r2 = w;
            w = v1[0];
            v1[0] = v1[2];
            v1[2] = w;
            w = v3[0];
            v3[0] = v3[2];
            v3[2] = w;
            f = 0;
        }
        if (v3[1] * v2[0] - v2[1] * v3[0] != 0.0) {
            f = 0;
        } else if (v3[2] * v2[0] - v2[2] * v3[0] != 0.0) {
            w = v2[1];
            v2[1] = v2[2];
            v2[2] = w;
            w = v3[1];
            v3[1] = v3[2];
            v3[2] = w;
            f = 1;
        } else {
            w = v2[0];
            v2[0] = v2[2];
            v2[2] = w;
            w = v3[0];
            v3[0] = v3[2];
            v3[2] = w;
            f = 2;
        }
        if (v3[1] * v2[0] - v2[1] * v3[0] == 0.0) {
            throw new NyARException();
        }
        k1 = (v2[1] * v3[2] - v3[1] * v2[2]) / (v3[1] * v2[0] - v2[1] * v3[0]);
        k2 = v3[1] * ca / (v3[1] * v2[0] - v2[1] * v3[0]);
        k3 = (v2[0] * v3[2] - v3[0] * v2[2]) / (v3[0] * v2[1] - v2[0] * v3[1]);
        k4 = v3[0] * ca / (v3[0] * v2[1] - v2[0] * v3[1]);
        b = k1 * k2 + k3 * k4;
        a = k1 * k1 + k3 * k3 + 1.0;
        c = k2 * k2 + k4 * k4 - 1.0;
        d = b * b - a * c;
        if (d < 0.0) {
            throw new NyARException();
        }
        double r3 = (-b + Math.sqrt(d)) / a;
        double p3 = k1 * r3 + k2;
        double q3 = k3 * r3 + k4;
        double r4 = (-b - Math.sqrt(d)) / a;
        double p4 = k1 * r4 + k2;
        double q4 = k3 * r4 + k4;
        if (f == 1) {
            w = q3;
            q3 = r3;
            r3 = w;
            w = q4;
            q4 = r4;
            r4 = w;
            w = v2[1];
            v2[1] = v2[2];
            v2[2] = w;
            w = v3[1];
            v3[1] = v3[2];
            v3[2] = w;
            f = 0;
        }
        if (f == 2) {
            w = p3;
            p3 = r3;
            r3 = w;
            w = p4;
            p4 = r4;
            r4 = w;
            w = v2[0];
            v2[0] = v2[2];
            v2[2] = w;
            w = v3[0];
            v3[0] = v3[2];
            v3[2] = w;
            f = 0;
        }
        if ((e1 = p1 * p3 + q1 * q3 + r1 * r3) < 0.0) {
            e1 = -e1;
        }
        if ((e2 = p1 * p4 + q1 * q4 + r1 * r4) < 0.0) {
            e2 = -e2;
        }
        if ((e3 = p2 * p3 + q2 * q3 + r2 * r3) < 0.0) {
            e3 = -e3;
        }
        if ((e4 = p2 * p4 + q2 * q4 + r2 * r4) < 0.0) {
            e4 = -e4;
        }
        if (e1 < e2) {
            if (e1 < e3) {
                if (e1 < e4) {
                    rot[0][0] = p1;
                    rot[0][1] = q1;
                    rot[0][2] = r1;
                    rot[1][0] = p3;
                    rot[1][1] = q3;
                    rot[1][2] = r3;
                } else {
                    rot[0][0] = p2;
                    rot[0][1] = q2;
                    rot[0][2] = r2;
                    rot[1][0] = p4;
                    rot[1][1] = q4;
                    rot[1][2] = r4;
                }
            } else if (e3 < e4) {
                rot[0][0] = p2;
                rot[0][1] = q2;
                rot[0][2] = r2;
                rot[1][0] = p3;
                rot[1][1] = q3;
                rot[1][2] = r3;
            } else {
                rot[0][0] = p2;
                rot[0][1] = q2;
                rot[0][2] = r2;
                rot[1][0] = p4;
                rot[1][1] = q4;
                rot[1][2] = r4;
            }
        } else if (e2 < e3) {
            if (e2 < e4) {
                rot[0][0] = p1;
                rot[0][1] = q1;
                rot[0][2] = r1;
                rot[1][0] = p4;
                rot[1][1] = q4;
                rot[1][2] = r4;
            } else {
                rot[0][0] = p2;
                rot[0][1] = q2;
                rot[0][2] = r2;
                rot[1][0] = p4;
                rot[1][1] = q4;
                rot[1][2] = r4;
            }
        } else if (e3 < e4) {
            rot[0][0] = p2;
            rot[0][1] = q2;
            rot[0][2] = r2;
            rot[1][0] = p3;
            rot[1][1] = q3;
            rot[1][2] = r3;
        } else {
            rot[0][0] = p2;
            rot[0][1] = q2;
            rot[0][2] = r2;
            rot[1][0] = p4;
            rot[1][1] = q4;
            rot[1][2] = r4;
        }
    }

    protected static final void arGetRot(double a, double b, double c, double[] o_rot) {
        double sina = Math.sin(a);
        double cosa = Math.cos(a);
        double sinb = Math.sin(b);
        double cosb = Math.cos(b);
        double sinc = Math.sin(c);
        double cosc = Math.cos(c);
        double CACA = cosa * cosa;
        double SASA = sina * sina;
        double SACA = sina * cosa;
        double SASB = sina * sinb;
        double CASB = cosa * sinb;
        double SACACB = SACA * cosb;
        o_rot[0] = CACA * cosb * cosc + SASA * cosc + SACACB * sinc - SACA * sinc;
        o_rot[1] = -CACA * cosb * sinc - SASA * sinc + SACACB * cosc - SACA * cosc;
        o_rot[2] = CASB;
        o_rot[3] = SACACB * cosc - SACA * cosc + SASA * cosb * sinc + CACA * sinc;
        o_rot[4] = -SACACB * sinc + SACA * sinc + SASA * cosb * cosc + CACA * cosc;
        o_rot[5] = SASB;
        o_rot[6] = -CASB * cosc - SASB * sinc;
        o_rot[7] = CASB * sinc - SASB * cosc;
        o_rot[8] = cosb;
    }

    protected final int arGetAngle(double[] o_abc) {
        double c;
        double a;
        double[] rot = this.array;
        if (rot[8] > 1.0) {
            rot[8] = 1.0;
        } else if (rot[8] < -1.0) {
            rot[8] = -1.0;
        }
        double cosb = rot[8];
        double b = Math.acos(cosb);
        double sinb = Math.sin(b);
        if (b >= 1.0E-6 || b <= -1.0E-6) {
            double cosa = rot[2] / sinb;
            double sina = rot[5] / sinb;
            if (cosa > 1.0) {
                cosa = 1.0;
                sina = 0.0;
            }
            if (cosa < -1.0) {
                cosa = -1.0;
                sina = 0.0;
            }
            if (sina > 1.0) {
                sina = 1.0;
                cosa = 0.0;
            }
            if (sina < -1.0) {
                sina = -1.0;
                cosa = 0.0;
            }
            a = Math.acos(cosa);
            if (sina < 0.0) {
                a = -a;
            }
            double tmp = rot[2] * rot[2] + rot[5] * rot[5];
            double sinc = (rot[7] * rot[2] - rot[6] * rot[5]) / tmp;
            double cosc = -(rot[2] * rot[6] + rot[5] * rot[7]) / tmp;
            if (cosc > 1.0) {
                cosc = 1.0;
                sinc = 0.0;
            }
            if (cosc < -1.0) {
                cosc = -1.0;
                sinc = 0.0;
            }
            if (sinc > 1.0) {
                sinc = 1.0;
                cosc = 0.0;
            }
            if (sinc < -1.0) {
                sinc = -1.0;
                cosc = 0.0;
            }
            c = Math.acos(cosc);
            if (sinc < 0.0) {
                c = -c;
            }
        } else {
            b = 0.0;
            a = 0.0;
            cosb = 1.0;
            double cosa = 1.0;
            sinb = 0.0;
            double sina = 0.0;
            double cosc = rot[0];
            double sinc = rot[1];
            if (cosc > 1.0) {
                cosc = 1.0;
                sinc = 0.0;
            }
            if (cosc < -1.0) {
                cosc = -1.0;
                sinc = 0.0;
            }
            if (sinc > 1.0) {
                sinc = 1.0;
                cosc = 0.0;
            }
            if (sinc < -1.0) {
                sinc = -1.0;
                cosc = 0.0;
            }
            c = Math.acos(cosc);
            if (sinc < 0.0) {
                c = -c;
            }
        }
        o_abc[0] = a;
        o_abc[1] = b;
        o_abc[2] = c;
        return 0;
    }
}

