/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kyutech.ai.ylab.shiva.utils.nativecapable;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;

public class NaiveCapableClassLoader
extends URLClassLoader {
    private ClassPool pool;
    private Collection<String> targets;
    private List<File> cachedJarFiles = new ArrayList<File>();
    private boolean delegateTargets = false;

    NaiveCapableClassLoader(URL[] urls, ClassLoader parent, File installDir) {
        super(urls, parent);
        this.pool = new ClassPool();
        this.pool.appendSystemPath();
        System.out.println("urls = " + Arrays.asList(urls));
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        block9: {
            if (name.equals("jp.ac.kyutech.ai.ylab.shiva.utils.nativecapable.NativeCapableModule") || name.equals("jp.ac.kyutech.ai.ylab.shiva.utils.nativecapable.LibInstaller")) {
                return this.getParent().loadClass(name);
            }
            if (this.targets != null) {
                if (!this.delegateTargets) {
                    for (String str : this.targets) {
                        if (!name.startsWith(str)) continue;
                        break block9;
                    }
                    return this.getParent().loadClass(name);
                }
                for (String str : this.targets) {
                    if (!name.startsWith(str)) continue;
                    return this.getParent().loadClass(name);
                }
            }
        }
        Class<?> c = null;
        try {
            c = this.findClass(name);
        }
        catch (ClassNotFoundException cnfEx) {
            System.out.println("try loading from url = " + name);
        }
        if (c == null) {
            c = super.findClass(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            String path = name.replace('.', '/').concat(".class");
            InputStream is = null;
            try {
                is = this.getResourceAsStream(path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (is == null) {
                for (File file : this.cachedJarFiles) {
                    try {
                        JarFile jf = new JarFile(file);
                        JarEntry je = jf.getJarEntry(path);
                        if (je == null) continue;
                        System.out.println("loading : " + je);
                        is = jf.getInputStream(je);
                        break;
                    }
                    catch (IOException e) {
                    }
                }
            }
            if (is != null) {
                CtClass cc = this.pool.makeClass(is);
                is.close();
                try {
                    cc.instrument(new ExprEditor(){

                        public void edit(MethodCall m) throws CannotCompileException {
                            if (m.getMethodName().equals("loadLibrary")) {
                                try {
                                    if ("java.lang.System".equals(m.getMethod().getDeclaringClass().getName())) {
                                        m.replace("{ try{$_ = $proceed($$); }catch(java.lang.Error e){System.out.println(e);System.out.println(\"might be loaded in advance\");}}");
                                    }
                                }
                                catch (NotFoundException notFoundException) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                    byte[] b = cc.toBytecode();
                    return this.defineClass(name, b, 0, b.length);
                }
                catch (CannotCompileException e) {
                    System.err.println(cc);
                    e.printStackTrace();
                    throw new ClassNotFoundException();
                }
            }
            throw new ClassNotFoundException();
        }
        catch (IOException e) {
            throw new ClassNotFoundException();
        }
    }

    public void setTargets(Collection<String> targets) {
        this.targets = targets;
    }

    public void setDelegateTargets(boolean delegateTargets) {
        this.delegateTargets = delegateTargets;
    }
}

