/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterfilter.rgb2bin;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2bin.INyARRasterFilter_RgbToBin;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARBufferReader;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARRasterFilter_ARToolkitThreshold
implements INyARRasterFilter_RgbToBin {
    private int _threshold;

    public NyARRasterFilter_ARToolkitThreshold(int i_threshold) {
        this._threshold = i_threshold;
    }

    public void setThreshold(int i_threshold) {
        this._threshold = i_threshold;
    }

    public void doFilter(INyARRgbRaster i_input, NyARBinRaster i_output) throws NyARException {
        INyARBufferReader in_buffer_reader = i_input.getBufferReader();
        INyARBufferReader out_buffer_reader = i_output.getBufferReader();
        int in_buf_type = in_buffer_reader.getBufferType();
        assert (out_buffer_reader.isEqualBufferType(262146));
        assert (this.checkInputType(in_buf_type));
        assert (i_input.getSize().isEqualSize(i_output.getSize()));
        int[] out_buf = (int[])out_buffer_reader.getBuffer();
        byte[] in_buf = (byte[])in_buffer_reader.getBuffer();
        NyARIntSize size = i_output.getSize();
        switch (in_buffer_reader.getBufferType()) {
            case 65537: 
            case 65538: {
                this.convert24BitRgb(in_buf, out_buf, size);
                break;
            }
            case 65793: {
                this.convert32BitRgbx(in_buf, out_buf, size);
                break;
            }
            default: {
                throw new NyARException();
            }
        }
    }

    private void convert24BitRgb(byte[] i_in, int[] i_out, NyARIntSize i_size) {
        int w;
        int th = this._threshold * 3;
        int bp = (i_size.w * i_size.h - 1) * 3;
        int pix_count = i_size.h * i_size.w;
        int pix_mod_part = pix_count - pix_count % 8;
        int xy = pix_count - 1;
        while (xy >= pix_mod_part) {
            w = (i_in[bp] & 0xFF) + (i_in[bp + 1] & 0xFF) + (i_in[bp + 2] & 0xFF);
            i_out[xy] = w <= th ? 0 : 1;
            bp -= 3;
            --xy;
        }
        while (xy >= 0) {
            w = (i_in[bp] & 0xFF) + (i_in[bp + 1] & 0xFF) + (i_in[bp + 2] & 0xFF);
            i_out[xy] = w <= th ? 0 : 1;
            w = (i_in[bp -= 3] & 0xFF) + (i_in[bp + 1] & 0xFF) + (i_in[bp + 2] & 0xFF);
            i_out[--xy] = w <= th ? 0 : 1;
            w = (i_in[bp -= 3] & 0xFF) + (i_in[bp + 1] & 0xFF) + (i_in[bp + 2] & 0xFF);
            i_out[--xy] = w <= th ? 0 : 1;
            w = (i_in[bp -= 3] & 0xFF) + (i_in[bp + 1] & 0xFF) + (i_in[bp + 2] & 0xFF);
            i_out[--xy] = w <= th ? 0 : 1;
            w = (i_in[bp -= 3] & 0xFF) + (i_in[bp + 1] & 0xFF) + (i_in[bp + 2] & 0xFF);
            i_out[--xy] = w <= th ? 0 : 1;
            w = (i_in[bp -= 3] & 0xFF) + (i_in[bp + 1] & 0xFF) + (i_in[bp + 2] & 0xFF);
            i_out[--xy] = w <= th ? 0 : 1;
            w = (i_in[bp -= 3] & 0xFF) + (i_in[bp + 1] & 0xFF) + (i_in[bp + 2] & 0xFF);
            i_out[--xy] = w <= th ? 0 : 1;
            w = (i_in[bp -= 3] & 0xFF) + (i_in[bp + 1] & 0xFF) + (i_in[bp + 2] & 0xFF);
            i_out[--xy] = w <= th ? 0 : 1;
            bp -= 3;
            --xy;
        }
    }

    private void convert32BitRgbx(byte[] i_in, int[] i_out, NyARIntSize i_size) {
        int w;
        int th = this._threshold * 3;
        int bp = (i_size.w * i_size.h - 1) * 4;
        int pix_count = i_size.h * i_size.w;
        int pix_mod_part = pix_count - pix_count % 8;
        int xy = pix_count - 1;
        while (xy >= pix_mod_part) {
            w = (i_in[bp] & 0xFF) + (i_in[bp + 1] & 0xFF) + (i_in[bp + 2] & 0xFF);
            i_out[xy] = w <= th ? 0 : 1;
            bp -= 4;
            --xy;
        }
        while (xy >= 0) {
            w = (i_in[bp] & 0xFF) + (i_in[bp + 1] & 0xFF) + (i_in[bp + 2] & 0xFF);
            i_out[xy] = w <= th ? 0 : 1;
            w = (i_in[bp -= 4] & 0xFF) + (i_in[bp + 1] & 0xFF) + (i_in[bp + 2] & 0xFF);
            i_out[--xy] = w <= th ? 0 : 1;
            w = (i_in[bp -= 4] & 0xFF) + (i_in[bp + 1] & 0xFF) + (i_in[bp + 2] & 0xFF);
            i_out[--xy] = w <= th ? 0 : 1;
            w = (i_in[bp -= 4] & 0xFF) + (i_in[bp + 1] & 0xFF) + (i_in[bp + 2] & 0xFF);
            i_out[--xy] = w <= th ? 0 : 1;
            w = (i_in[bp -= 4] & 0xFF) + (i_in[bp + 1] & 0xFF) + (i_in[bp + 2] & 0xFF);
            i_out[--xy] = w <= th ? 0 : 1;
            w = (i_in[bp -= 4] & 0xFF) + (i_in[bp + 1] & 0xFF) + (i_in[bp + 2] & 0xFF);
            i_out[--xy] = w <= th ? 0 : 1;
            w = (i_in[bp -= 4] & 0xFF) + (i_in[bp + 1] & 0xFF) + (i_in[bp + 2] & 0xFF);
            i_out[--xy] = w <= th ? 0 : 1;
            w = (i_in[bp -= 4] & 0xFF) + (i_in[bp + 1] & 0xFF) + (i_in[bp + 2] & 0xFF);
            i_out[--xy] = w <= th ? 0 : 1;
            bp -= 4;
            --xy;
        }
    }

    private boolean checkInputType(int i_input_type) throws NyARException {
        switch (i_input_type) {
            case 65537: 
            case 65538: 
            case 65793: 
            case 66049: {
                return true;
            }
        }
        return false;
    }
}

