/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterreader;

import jp.nyatla.nyartoolkit.core.rasterreader.INyARRgbPixelReader;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARRgbPixelReader_RGB24
implements INyARRgbPixelReader {
    protected byte[] _ref_buf;
    private NyARIntSize _size;

    public NyARRgbPixelReader_RGB24(byte[] i_buf, NyARIntSize i_size) {
        this._ref_buf = i_buf;
        this._size = i_size;
    }

    public void getPixel(int i_x, int i_y, int[] o_rgb) {
        byte[] ref_buf = this._ref_buf;
        int bp = (i_x + i_y * this._size.w) * 3;
        o_rgb[0] = ref_buf[bp + 0] & 0xFF;
        o_rgb[1] = ref_buf[bp + 1] & 0xFF;
        o_rgb[2] = ref_buf[bp + 2] & 0xFF;
    }

    public void getPixelSet(int[] i_x, int[] i_y, int i_num, int[] o_rgb) {
        int width = this._size.w;
        byte[] ref_buf = this._ref_buf;
        int i = i_num - 1;
        while (i >= 0) {
            int bp = (i_x[i] + i_y[i] * width) * 3;
            o_rgb[i * 3 + 0] = ref_buf[bp + 0] & 0xFF;
            o_rgb[i * 3 + 1] = ref_buf[bp + 1] & 0xFF;
            o_rgb[i * 3 + 2] = ref_buf[bp + 2] & 0xFF;
            --i;
        }
    }
}

