/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.param;

import jp.nyatla.nyartoolkit.core.NyARMat;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix34;

public final class NyARPerspectiveProjectionMatrix
extends NyARDoubleMatrix34 {
    private static final double dot(double a1, double a2, double a3, double b1, double b2, double b3) {
        return a1 * b1 + a2 * b2 + a3 * b3;
    }

    private static final double norm(double a, double b, double c) {
        return Math.sqrt(a * a + b * b + c * c);
    }

    public void decompMat(NyARMat o_cpara, NyARMat o_trans) {
        int c;
        double c23;
        double c22;
        double c21;
        double c20;
        double c13;
        double c12;
        double c11;
        double c10;
        double c03;
        double c02;
        double c01;
        double c00;
        if (this.m23 >= 0.0) {
            c00 = this.m00;
            c01 = this.m01;
            c02 = this.m02;
            c03 = this.m03;
            c10 = this.m10;
            c11 = this.m11;
            c12 = this.m12;
            c13 = this.m13;
            c20 = this.m20;
            c21 = this.m21;
            c22 = this.m22;
            c23 = this.m23;
        } else {
            c00 = -this.m00;
            c01 = -this.m01;
            c02 = -this.m02;
            c03 = -this.m03;
            c10 = -this.m10;
            c11 = -this.m11;
            c12 = -this.m12;
            c13 = -this.m13;
            c20 = -this.m20;
            c21 = -this.m21;
            c22 = -this.m22;
            c23 = -this.m23;
        }
        double[][] cpara = o_cpara.getArray();
        double[][] trans = o_trans.getArray();
        int r = 0;
        while (r < 3) {
            c = 0;
            while (c < 4) {
                cpara[r][c] = 0.0;
                ++c;
            }
            ++r;
        }
        cpara[2][2] = NyARPerspectiveProjectionMatrix.norm(c20, c21, c22);
        trans[2][0] = c20 / cpara[2][2];
        trans[2][1] = c21 / cpara[2][2];
        trans[2][2] = c22 / cpara[2][2];
        trans[2][3] = c23 / cpara[2][2];
        cpara[1][2] = NyARPerspectiveProjectionMatrix.dot(trans[2][0], trans[2][1], trans[2][2], c10, c11, c12);
        double rem1 = c10 - cpara[1][2] * trans[2][0];
        double rem2 = c11 - cpara[1][2] * trans[2][1];
        double rem3 = c12 - cpara[1][2] * trans[2][2];
        cpara[1][1] = NyARPerspectiveProjectionMatrix.norm(rem1, rem2, rem3);
        trans[1][0] = rem1 / cpara[1][1];
        trans[1][1] = rem2 / cpara[1][1];
        trans[1][2] = rem3 / cpara[1][1];
        cpara[0][2] = NyARPerspectiveProjectionMatrix.dot(trans[2][0], trans[2][1], trans[2][2], c00, c01, c02);
        cpara[0][1] = NyARPerspectiveProjectionMatrix.dot(trans[1][0], trans[1][1], trans[1][2], c00, c01, c02);
        rem1 = c00 - cpara[0][1] * trans[1][0] - cpara[0][2] * trans[2][0];
        rem2 = c01 - cpara[0][1] * trans[1][1] - cpara[0][2] * trans[2][1];
        rem3 = c02 - cpara[0][1] * trans[1][2] - cpara[0][2] * trans[2][2];
        cpara[0][0] = NyARPerspectiveProjectionMatrix.norm(rem1, rem2, rem3);
        trans[0][0] = rem1 / cpara[0][0];
        trans[0][1] = rem2 / cpara[0][0];
        trans[0][2] = rem3 / cpara[0][0];
        trans[1][3] = (c13 - cpara[1][2] * trans[2][3]) / cpara[1][1];
        trans[0][3] = (c03 - cpara[0][1] * trans[1][3] - cpara[0][2] * trans[2][3]) / cpara[0][0];
        r = 0;
        while (r < 3) {
            c = 0;
            while (c < 3) {
                double[] dArray = cpara[r];
                int n = c++;
                dArray[n] = dArray[n] / cpara[2][2];
            }
            ++r;
        }
    }

    public void changeScale(double i_scale) {
        this.m00 *= i_scale;
        this.m10 *= i_scale;
        this.m01 *= i_scale;
        this.m11 *= i_scale;
        this.m02 *= i_scale;
        this.m12 *= i_scale;
        this.m03 *= i_scale;
        this.m13 *= i_scale;
    }
}

