/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyar4psg;

import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.NyARRgbRaster_BasicClass;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARBufferReader;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARRgbPixelReader;
import jp.nyatla.nyartoolkit.core.rasterreader.NyARBufferReader;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import processing.core.PImage;

class NyARRgbRaster_PImage
extends NyARRgbRaster_BasicClass
implements INyARRgbRaster {
    private INyARRgbPixelReader _rgb_reader = new PixelReader(this);
    private INyARBufferReader _buffer_reader = new BufferReader(this);
    private PImage _ref_image;

    public NyARRgbRaster_PImage(int i_width, int i_height) {
        super(new NyARIntSize(i_width, i_height));
    }

    public void bindImage(PImage i_img) {
        this._ref_image = i_img;
        this._ref_image.updatePixels();
    }

    public void unBindImage(PImage i_img) {
        this._ref_image = null;
    }

    public INyARRgbPixelReader getRgbPixelReader() {
        return this._rgb_reader;
    }

    public INyARBufferReader getBufferReader() {
        return this._buffer_reader;
    }

    private class PixelReader
    implements INyARRgbPixelReader {
        private NyARRgbRaster_PImage _parent;

        public PixelReader(NyARRgbRaster_PImage i_parent) {
            this._parent = i_parent;
        }

        public void getPixel(int i_x, int i_y, int[] o_rgb) {
            int[] ref_buf = ((NyARRgbRaster_PImage)this._parent)._ref_image.pixels;
            int bp = ref_buf[i_x + i_y * ((NyARRgbRaster_PImage)this._parent)._size.w];
            o_rgb[0] = bp >> 16 & 0xFF;
            o_rgb[1] = bp >> 8 & 0xFF;
            o_rgb[2] = bp & 0xFF;
        }

        public void getPixelSet(int[] i_x, int[] i_y, int i_num, int[] o_rgb) {
            int[] ref_buf = ((NyARRgbRaster_PImage)this._parent)._ref_image.pixels;
            int width = ((NyARRgbRaster_PImage)this._parent)._size.w;
            int i = i_num - 1;
            while (i >= 0) {
                int bp = ref_buf[i_x[i] + i_y[i] * width];
                o_rgb[i * 3 + 0] = bp >> 16 & 0xFF;
                o_rgb[i * 3 + 1] = bp >> 8 & 0xFF;
                o_rgb[i * 3 + 2] = bp & 0xFF;
                --i;
            }
        }
    }

    public class BufferReader
    extends NyARBufferReader {
        NyARRgbRaster_PImage _parent;

        public BufferReader(NyARRgbRaster_PImage i_parent) {
            this._buffer_type = 262402;
            this._parent = i_parent;
        }

        public Object getBuffer() {
            return ((NyARRgbRaster_PImage)this._parent)._ref_image.pixels;
        }
    }
}

