/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.pickup;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARMat;
import jp.nyatla.nyartoolkit.core.NyARSquare;
import jp.nyatla.nyartoolkit.core.pickup.INyARColorPatt;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARRgbPixelReader;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint;

public class NyARColorPatt_O3
implements INyARColorPatt {
    private static final int AR_PATT_SAMPLE_NUM = 64;
    private int[][][] extpat;
    private int width;
    private int height;
    private final NyARMat wk_get_cpara_a = new NyARMat(8, 8);
    private final NyARMat wk_get_cpara_b = new NyARMat(8, 1);
    private final int[][] wk_pickFromRaster_world = new int[][]{{100, 100}, {110, 100}, {110, 110}, {100, 110}};
    private final NyARMat wk_pickFromRaster_cpara = new NyARMat(8, 1);
    private double[] wk_updateExtpat_para00_xw;
    private double[] wk_updateExtpat_para10_xw;
    private double[] wk_updateExtpat_para20_xw;
    private int[] wk_updateExtpat_rgb_buf;
    private int[] wk_updateExtpat_x_rgb_index;
    private int[] wk_updateExtpat_y_rgb_index;
    private int[] wk_updateExtpat_i_rgb_index;
    private int wk_updateExtpat_buffer_size = 0;

    public NyARColorPatt_O3(int i_width, int i_height) {
        this.width = i_width;
        this.height = i_height;
        this.extpat = new int[i_height][i_width][3];
    }

    public int[][][] getPatArray() {
        return this.extpat;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private boolean get_cpara(NyARIntPoint[] i_vertex, NyARMat o_para) throws NyARException {
        int[][] world = this.wk_pickFromRaster_world;
        NyARMat a = this.wk_get_cpara_a;
        double[][] a_array = a.getArray();
        NyARMat b = this.wk_get_cpara_b;
        double[][] b_array = b.getArray();
        int i = 0;
        while (i < 4) {
            double[] a_pt0 = a_array[i * 2];
            double[] a_pt1 = a_array[i * 2 + 1];
            int[] world_pti = world[i];
            a_pt0[0] = world_pti[0];
            a_pt0[1] = world_pti[1];
            a_pt0[2] = 1.0;
            a_pt0[3] = 0.0;
            a_pt0[4] = 0.0;
            a_pt0[5] = 0.0;
            a_pt0[6] = -world_pti[0] * i_vertex[i].x;
            a_pt0[7] = -world_pti[1] * i_vertex[i].x;
            a_pt1[0] = 0.0;
            a_pt1[1] = 0.0;
            a_pt1[2] = 0.0;
            a_pt1[3] = world_pti[0];
            a_pt1[4] = world_pti[1];
            a_pt1[5] = 1.0;
            a_pt1[6] = -world_pti[0] * i_vertex[i].y;
            a_pt1[7] = -world_pti[1] * i_vertex[i].y;
            b_array[i * 2 + 0][0] = i_vertex[i].x;
            b_array[i * 2 + 1][0] = i_vertex[i].y;
            ++i;
        }
        if (!a.matrixSelfInv()) {
            return false;
        }
        o_para.matrixMul(a, b);
        return true;
    }

    private static void initValue_wk_pickFromRaster_ext_pat2(int[][][] i_ext_pat2, int i_width, int i_height) {
        int i = i_height - 1;
        while (i >= 0) {
            int[][] pt2 = i_ext_pat2[i];
            int i2 = i_width - 1;
            while (i2 >= 0) {
                int[] pt1 = pt2[i2];
                pt1[0] = 0;
                pt1[1] = 0;
                pt1[2] = 0;
                --i2;
            }
            --i;
        }
    }

    public boolean pickFromRaster(INyARRgbRaster image, NyARSquare i_square) throws NyARException {
        NyARMat cpara = this.wk_pickFromRaster_cpara;
        NyARIntPoint[] local = i_square.imvertex;
        int w1 = local[0].x - local[1].x;
        int w2 = local[0].y - local[1].y;
        w1 = local[2].x - local[3].x;
        w2 = local[2].y - local[3].y;
        int l2 = w1 * w1 + w2 * w2;
        int l1 = w1 * w1 + w2 * w2;
        if (l2 > l1) {
            l1 = l2;
        }
        l1 /= 4;
        int xdiv2 = this.width;
        while (xdiv2 * xdiv2 < l1) {
            xdiv2 *= 2;
        }
        if (xdiv2 > 64) {
            xdiv2 = 64;
        }
        w1 = local[1].x - local[2].x;
        w2 = local[1].y - local[2].y;
        w1 = local[3].x - local[0].x;
        w2 = local[3].y - local[0].y;
        l2 = w1 * w1 + w2 * w2;
        l1 = w1 * w1 + w2 * w2;
        if (l2 > l1) {
            l1 = l2;
        }
        int ydiv2 = this.height;
        l1 /= 4;
        while (ydiv2 * ydiv2 < l1) {
            ydiv2 *= 2;
        }
        if (ydiv2 > 64) {
            ydiv2 = 64;
        }
        if (!this.get_cpara(local, cpara)) {
            return false;
        }
        this.updateExtpat(image, cpara, xdiv2, ydiv2);
        return true;
    }

    private void reservWorkBuffers(int i_xdiv2) {
        if (this.wk_updateExtpat_buffer_size < i_xdiv2) {
            this.wk_updateExtpat_para00_xw = new double[i_xdiv2];
            this.wk_updateExtpat_para10_xw = new double[i_xdiv2];
            this.wk_updateExtpat_para20_xw = new double[i_xdiv2];
            this.wk_updateExtpat_rgb_buf = new int[i_xdiv2 * 3];
            this.wk_updateExtpat_x_rgb_index = new int[i_xdiv2];
            this.wk_updateExtpat_y_rgb_index = new int[i_xdiv2];
            this.wk_updateExtpat_i_rgb_index = new int[i_xdiv2];
            this.wk_updateExtpat_buffer_size = i_xdiv2;
        }
    }

    private void updateExtpat(INyARRgbRaster image, NyARMat i_cpara, int i_xdiv2, int i_ydiv2) throws NyARException {
        int[] extpat_j_i;
        int[][] extpat_j;
        int img_x = image.getWidth();
        int img_y = image.getHeight();
        int[][][] L_extpat = this.extpat;
        int L_WIDTH = this.width;
        int L_HEIGHT = this.height;
        NyARColorPatt_O3.initValue_wk_pickFromRaster_ext_pat2(L_extpat, L_WIDTH, L_HEIGHT);
        double[][] cpara_array = i_cpara.getArray();
        double para00 = cpara_array[0][0];
        double para01 = cpara_array[1][0];
        double para02 = cpara_array[2][0];
        double para10 = cpara_array[3][0];
        double para11 = cpara_array[4][0];
        double para12 = cpara_array[5][0];
        double para20 = cpara_array[6][0];
        double para21 = cpara_array[7][0];
        int xdiv = i_xdiv2 / L_WIDTH;
        int ydiv = i_ydiv2 / L_HEIGHT;
        this.reservWorkBuffers(i_xdiv2);
        double[] para00_xw = this.wk_updateExtpat_para00_xw;
        double[] para10_xw = this.wk_updateExtpat_para10_xw;
        double[] para20_xw = this.wk_updateExtpat_para20_xw;
        int[] x_rgb_index = this.wk_updateExtpat_x_rgb_index;
        int[] y_rgb_index = this.wk_updateExtpat_y_rgb_index;
        int[] i_rgb_index = this.wk_updateExtpat_i_rgb_index;
        int[] rgb_buf = this.wk_updateExtpat_rgb_buf;
        int i = 0;
        while (i < i_xdiv2) {
            double xw = 102.5 + 5.0 * ((double)i + 0.5) / (double)i_xdiv2;
            para20_xw[i] = para20 * xw;
            para00_xw[i] = para00 * xw;
            para10_xw[i] = para10 * xw;
            ++i;
        }
        INyARRgbPixelReader reader = image.getRgbPixelReader();
        int j = 0;
        while (j < i_ydiv2) {
            double yw = 102.5 + 5.0 * ((double)j + 0.5) / (double)i_ydiv2;
            double para21_x_yw = para21 * yw + 1.0;
            double para11_x_yw = para11 * yw + para12;
            double para01_x_yw = para01 * yw + para02;
            extpat_j = L_extpat[j / ydiv];
            int index_num = 0;
            i = 0;
            while (i < i_xdiv2) {
                double d = para20_xw[i] + para21_x_yw;
                if (d == 0.0) {
                    throw new NyARException();
                }
                int xc = (int)((para00_xw[i] + para01_x_yw) / d);
                int yc = (int)((para10_xw[i] + para11_x_yw) / d);
                if (xc >= 0 && xc < img_x && yc >= 0 && yc < img_y) {
                    x_rgb_index[index_num] = xc;
                    y_rgb_index[index_num] = yc;
                    i_rgb_index[index_num] = i / xdiv;
                    ++index_num;
                }
                ++i;
            }
            reader.getPixelSet(x_rgb_index, y_rgb_index, index_num, rgb_buf);
            i = index_num - 1;
            while (i >= 0) {
                extpat_j_i = extpat_j[i_rgb_index[i]];
                extpat_j_i[0] = extpat_j_i[0] + rgb_buf[i * 3 + 0];
                extpat_j_i[1] = extpat_j_i[1] + rgb_buf[i * 3 + 1];
                extpat_j_i[2] = extpat_j_i[2] + rgb_buf[i * 3 + 2];
                --i;
            }
            ++j;
        }
        int xdiv_x_ydiv = xdiv * ydiv;
        j = L_HEIGHT - 1;
        while (j >= 0) {
            extpat_j = L_extpat[j];
            i = L_WIDTH - 1;
            while (i >= 0) {
                extpat_j_i = extpat_j[i];
                extpat_j_i[0] = extpat_j_i[0] / xdiv_x_ydiv;
                extpat_j_i[1] = extpat_j_i[1] / xdiv_x_ydiv;
                extpat_j_i[2] = extpat_j_i[2] / xdiv_x_ydiv;
                --i;
            }
            --j;
        }
    }
}

