/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core2.rasterfilter.rgb2gs;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.NyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.INyARRasterFilter_RgbToGs;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARBufferReader;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARRasterFilter_RgbAve
implements INyARRasterFilter_RgbToGs {
    public void doFilter(INyARRgbRaster i_input, NyARGrayscaleRaster i_output) throws NyARException {
        INyARBufferReader in_buffer_reader = i_input.getBufferReader();
        INyARBufferReader out_buffer_reader = i_output.getBufferReader();
        assert (i_input.getSize().isEqualSize(i_output.getSize()));
        int[] out_buf = (int[])out_buffer_reader.getBuffer();
        byte[] in_buf = (byte[])in_buffer_reader.getBuffer();
        NyARIntSize size = i_output.getSize();
        switch (in_buffer_reader.getBufferType()) {
            case 65537: 
            case 65538: {
                this.convert24BitRgb(in_buf, out_buf, size);
                break;
            }
            case 65793: {
                this.convert32BitRgbx(in_buf, out_buf, size);
                break;
            }
            default: {
                throw new NyARException();
            }
        }
    }

    private void convert24BitRgb(byte[] i_in, int[] i_out, NyARIntSize i_size) {
        int bp = 0;
        int y = 0;
        while (y < i_size.h) {
            int x = 0;
            while (x < i_size.w) {
                i_out[y * i_size.w + x] = ((i_in[bp] & 0xFF) + (i_in[bp + 1] & 0xFF) + (i_in[bp + 2] & 0xFF)) / 3;
                bp += 3;
                ++x;
            }
            ++y;
        }
    }

    private void convert32BitRgbx(byte[] i_in, int[] i_out, NyARIntSize i_size) {
        int bp = 0;
        int y = 0;
        while (y < i_size.h) {
            int x = 0;
            while (x < i_size.w) {
                i_out[y * i_size.w + x] = ((i_in[bp] & 0xFF) + (i_in[bp + 1] & 0xFF) + (i_in[bp + 2] & 0xFF)) / 3;
                bp += 4;
                ++x;
            }
            ++y;
        }
    }
}

