/* 
 * PROJECT: NyARToolkit for proce55ing.
 * --------------------------------------------------------------------------------
 * The MIT License
 * Copyright (c) 2008 nyatla
 * airmail(at)ebony.plala.or.jp
 * http://nyatla.jp/nyartoolkit/
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 */

package jp.nyatla.nyar4psg;
import javax.media.opengl.*;
import processing.core.*;
import processing.opengl.*;

import jp.nyatla.nyartoolkit.*;
import jp.nyatla.nyartoolkit.core.*;
import jp.nyatla.nyartoolkit.core.param.*;
import jp.nyatla.nyartoolkit.core.raster.*;
import jp.nyatla.nyartoolkit.core.raster.rgb.*;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2bin.*;
import jp.nyatla.nyartoolkit.core.rasterreader.*;
import jp.nyatla.nyartoolkit.core.types.*;
import jp.nyatla.nyartoolkit.core.transmat.*;
import jp.nyatla.nyartoolkit.detector.*;


class ARToolkitThreshold4PImage implements INyARRasterFilter_RgbToBin
{
	private int _threshold;

	public ARToolkitThreshold4PImage()
	{
	}
	public void setThreshold(int i_threshold)
	{
		this._threshold = i_threshold;
	}

	public void doFilter(INyARRgbRaster i_input, NyARBinRaster i_output) throws NyARException
	{
		INyARBufferReader in_buffer_reader=i_input.getBufferReader();	
		INyARBufferReader out_buffer_reader=i_output.getBufferReader();

		assert (out_buffer_reader.isEqualBufferType(INyARBufferReader.BUFFERFORMAT_INT1D_BIN_8));
		assert (in_buffer_reader.isEqualBufferType(INyARBufferReader.BUFFERFORMAT_INT1D_X8R8G8B8_32));
		assert (i_input.getSize().isEqualSize(i_output.getSize()) == true);

		NyARIntSize size = i_output.getSize();
		convert((int[]) in_buffer_reader.getBuffer(), (int[]) out_buffer_reader.getBuffer(), size);
		return;
	}

	private void convert(int[] i_in, int[] i_out, NyARIntSize i_size)
	{
		final int th=this._threshold*3;
		int w;
		int xy;
		final int pix_count   =i_size.h*i_size.w;
		final int pix_mod_part=pix_count-(pix_count%8);
		for(xy=pix_count-1;xy>=pix_mod_part;xy--){
			w=i_in[xy];
			i_out[xy]=(w&0xff)+((w>>8)&0xff)+((w>>16)&0xff)<=th?0:1;
		}
		//^CO
		for (;xy>=0;) {
			w=i_in[xy];
			i_out[xy]=(w&0xff)+((w>>8)&0xff)+((w>>16)&0xff)<=th?0:1;
			xy--;
			w=i_in[xy];
			i_out[xy]=(w&0xff)+((w>>8)&0xff)+((w>>16)&0xff)<=th?0:1;
			xy--;
			w=i_in[xy];
			i_out[xy]=(w&0xff)+((w>>8)&0xff)+((w>>16)&0xff)<=th?0:1;
			xy--;
			w=i_in[xy];
			i_out[xy]=(w&0xff)+((w>>8)&0xff)+((w>>16)&0xff)<=th?0:1;
			xy--;
			w=i_in[xy];
			i_out[xy]=(w&0xff)+((w>>8)&0xff)+((w>>16)&0xff)<=th?0:1;
			xy--;
			w=i_in[xy];
			i_out[xy]=(w&0xff)+((w>>8)&0xff)+((w>>16)&0xff)<=th?0:1;
			xy--;
			w=i_in[xy];
			i_out[xy]=(w&0xff)+((w>>8)&0xff)+((w>>16)&0xff)<=th?0:1;
			xy--;
			w=i_in[xy];
			i_out[xy]=(w&0xff)+((w>>8)&0xff)+((w>>16)&0xff)<=th?0:1;
			xy--;
		}
		return;
	}
}


class NyARRgbRaster_PImage extends NyARRgbRaster_BasicClass implements INyARRgbRaster
{
	private class PixelReader implements INyARRgbPixelReader
	{
		private NyARRgbRaster_PImage _parent;

		public PixelReader(NyARRgbRaster_PImage i_parent)
		{
			this._parent = i_parent;
		}

		public void getPixel(int i_x, int i_y, int[] o_rgb)
		{
			int[] ref_buf = this._parent._ref_image.pixels;
			int bp = ref_buf[(i_x + i_y * this._parent._size.w)];
			o_rgb[0] = ((bp>>16) & 0xff);// R
			o_rgb[1] = ((bp>>8) & 0xff);// G
			o_rgb[2] = (bp & 0xff);// B
			return;
		}

		public void getPixelSet(int[] i_x, int[] i_y, int i_num, int[] o_rgb)
		{
			int[] ref_buf = this._parent._ref_image.pixels;
			int width = _parent._size.w;
			int bp;
			for (int i = i_num - 1; i >= 0; i--) {
				bp =ref_buf[(i_x[i] + i_y[i] * width)];
				o_rgb[i * 3 + 0] = (bp>>16) & 0xff;// R
				o_rgb[i * 3 + 1] = (bp>>8) & 0xff;// G
				o_rgb[i * 3 + 2] = (bp & 0xff);// B
			}
			return;
		}
	}
	public class BufferReader extends NyARBufferReader
	{
		NyARRgbRaster_PImage _parent;
		public BufferReader(NyARRgbRaster_PImage i_parent)
		{
			super();
			this._buffer_type=INyARBufferReader.BUFFERFORMAT_INT1D_X8R8G8B8_32;
			this._parent=i_parent;
		}
		public Object getBuffer()
		{
			return this._parent._ref_image.pixels;
		}
	}
	private INyARRgbPixelReader _rgb_reader;
	private INyARBufferReader _buffer_reader;

	public NyARRgbRaster_PImage(int i_width, int i_height)
	{
		super(new NyARIntSize(i_width,i_height));

		this._rgb_reader = new PixelReader(this);
		this._buffer_reader=new BufferReader(this);
		return;
	}
	private PImage _ref_image;
	public void bindImage(PImage i_img)
	{
		this._ref_image=i_img;
		this._ref_image.updatePixels();
	}
	public void unBindImage(PImage i_img)
	{
		this._ref_image=null;
		return;
	}
	public INyARRgbPixelReader getRgbPixelReader()
	{
		return this._rgb_reader;
	}
	public INyARBufferReader getBufferReader()
	{
		return this._buffer_reader;
	}
}

/**
 * ̃NX́APImageARToolKit̕ϊs߂NXłB
 * }[JP̔ɌĂāA𒆐SɂWnvZ܂B
 * o\ȃ}[J͂PށAPłB
 *
 */
public class NyARBoard
{
	/**
	 * o[WłB
	 */
	public final String VERSION = "NyAR4psg/0.2.0;NyARToolkit for java/2.2.0;ARToolKit/2.72.1";
	/**
	 * xB}[JAw񐔂͉ߋ̏ێB
	 */
	public int lostDelay =10;
	/**
	 * x񐔁B̒l0<n<lostCountƂ܂B
	 */
	public int lostCount = 0;
	/**
	 * }[J̍Wϊs臒lB0.0<n<1.0̒lƂ܂B
	 * ̐lvx傫ꍇ̂݁A}[JoƔ肳AWvZs܂B
	 */
	public double cfThreshold=0.4;
	/**
	 * OpenGLProjectionzBRXgN^ŏ܂B
	 */
	public final double[] projection=new double[16];
	/**
	 * }[Jx,y,žXpxłB
	 */
	public final PVector angle=new PVector();
	/**
	 * }[Jx,y,z̕sړʂłB
	 */
	public final PVector trans=new PVector();
	/**
	 * o}[J̈vxłB
	 */
	public double confidence=0.0;
	/**
	 * o}[J4̂Q摜̈ʒułB
	 */
	public final int[][] pos2d=new int[4][2];
	/**
	 * o}[J̕ϊsłB
	 */
	public final double[] transmat=new double[16];
	/**
	 * }[JõO[XP[臒lw肵܂B̒ĺA0<=n<=255܂B
	 */
	public int gsThreshold=110;
	
	
	
	private final NyARTransMatResult _result=new NyARTransMatResult();
	private PApplet _pa;
	private NyARCustomSingleDetectMarker _nya;
	private NyARParam _ar_param;
	private NyARRgbRaster_PImage _raster;
	private ARToolkitThreshold4PImage _filter;
	/**
	 * 
	 * @param parent
	 * processing̃CX^Xw肵܂B
	 * @param i_width
	 * ͉摜̕w肵܂B
	 * @param i_htight
	 * ͉摜̍w肵܂B
	 * @param i_cparam
	 * ARToolKit̃p[^t@Cw肵܂Bp[^t@CdatafBNgɂĉB
	 * @param i_patt
	 * }[J̃p^[t@Cw肵܂Bp^[t@ĆAdatafBNgɂĉB
	 * @param i_patt_width
	 * }[J̃TCYw肵܂BPʂmmłB
	 */
	public NyARBoard(PApplet parent, int i_width,int i_htight,String i_cparam,String i_patt,int i_patt_width)
	{
		NyARCode code;
		this._pa=parent;
		try{
			this._raster=new NyARRgbRaster_PImage(i_width, i_htight);
			this._ar_param=new NyARParam();
			this._ar_param.loadARParam(this._pa.createInput(i_cparam));
			this._ar_param.changeScreenSize(i_width, i_htight);
			initProjection(this._ar_param,projection);
			code=new NyARCode(16,16);
			code.loadARPatt(this._pa.createInput(i_patt));
			this._filter=new ARToolkitThreshold4PImage();
			this._nya=new NyARCustomSingleDetectMarker(this._ar_param,code,(double)i_patt_width,this._filter);
		}catch(NyARException e){
			this._pa.die("Error while setting up NyARToolkit for java", e);
		}
	}
	/**
	 * i_imagełvx̍}[JoAcfThresholdȏ̈vxł΁A
	 * pos2d,angle,trans,confidence,transmat̃vpeBXV܂B
	 * @param i_image
	 * oC[Wݒ肵܂B
	 * @return
	 * }[JoALȒlTRUEԂ܂B
	 * TRUEł΁AvpeBXVĂ܂B
	 */
	public boolean detect(PImage i_image)
	{
		boolean is_marker_exist=false;
		try{
			this._raster.bindImage(i_image);
			//}[J̌oB
			this._filter.setThreshold(this.gsThreshold);
			is_marker_exist = this._nya.detectMarkerLite(this._raster);
			//}[JvxmF
			if(is_marker_exist){
				double cf=this._nya.getConfidence();
				if(cf<this.cfThreshold){
					is_marker_exist=false;
				}
			}
			//}[JƂďH
			if(is_marker_exist){
				final NyARIntPoint[] pts=this._nya.refSquarePosition();
				for(int i=0;i<4;i++){
					this.pos2d[i][0]=pts[i].x;
					this.pos2d[i][1]=pts[i].y;
				}
				this.confidence=this._nya.getConfidence();
				this.lostCount=0;
				//Wϊ
				this._nya.getTransmationMatrix(this._result);
				updateTransmat(this._result);

			}else if(this.lostCount<this.lostDelay){
				this.lostCount++;
				is_marker_exist=true;
			}else{
				is_marker_exist=false;				
			}
			
			this._raster.unBindImage(i_image);
			return is_marker_exist;
		}catch(NyARException e){
			this._pa.die("Error while marker detecting up NyARToolkit for java", e);
		}
		return is_marker_exist;
	}
	//LbV
	private GL _gl=null;
	private PGraphicsOpenGL _pgl=null;

	/**
	 * WϊsMatrix܂B
	 * @param i_pgl
	 * PGraphicsOpenGLCX^Xݒ肵܂BprocessinggoLXgĐݒ肵ĂB
	 */
	public void beginTransform(PGraphicsOpenGL i_pgl)
	{
		if(this._pgl!=null){
			this._pa.die("The function beginTransform is already called.", null);			
		}
		this._pgl=i_pgl;
		this._gl = i_pgl.beginGL();  // always use the GL object returned by beginGL
		this._gl.glMatrixMode(GL.GL_PROJECTION);
		this._pa.pushMatrix();
		this._pa.resetMatrix();
		this._gl.glLoadMatrixd(this.projection,0);
		this._gl.glMatrixMode(GL.GL_MODELVIEW);
		this._pa.pushMatrix();
		this._pa.resetMatrix();
		this._gl.glLoadMatrixd(this.transmat,0);  
		this._pa.pushMatrix();
		return;
	}
	/**
	 * WϊsMatrix܂B
	 */
	public void endTransform()
	{
		if(this._pgl==null){
			this._pa.die("The function beginTransform is never called.", null);			
		}
		this._pa.popMatrix();
		this._pa.popMatrix();
		this._gl.glMatrixMode(GL.GL_PROJECTION);
		this._pa.popMatrix();
		this._gl.glMatrixMode(GL.GL_MODELVIEW);
		this._pgl.endGL();
		this._gl=null;
		this._pgl=null;
		return;
	}

	private static void initProjection(NyARParam i_param,double[] o_projection)
	{
		NyARMat trans_mat = new NyARMat(3, 4);
		NyARMat icpara_mat = new NyARMat(3, 4);
		double[][] p = new double[3][3], q = new double[4][4];
		int i, j;

		final NyARIntSize size=i_param.getScreenSize();
		final int width = size.w;
		final int height = size.h;
		
		i_param.getPerspectiveProjectionMatrix().decompMat(icpara_mat, trans_mat);

		double[][] icpara = icpara_mat.getArray();
		double[][] trans = trans_mat.getArray();
		for (i = 0; i < 4; i++) {
			icpara[1][i] = (height - 1) * (icpara[2][i]) - icpara[1][i];
		}

		for (i = 0; i < 3; i++) {
			for (j = 0; j < 3; j++) {
				p[i][j] = icpara[i][j] / icpara[2][2];
			}
		}
		q[0][0] = (2.0 * p[0][0] / (width - 1));
		q[0][1] = (2.0 * p[0][1] / (width - 1));
		q[0][2] = -((2.0 * p[0][2] / (width - 1)) - 1.0);
		q[0][3] = 0.0;

		q[1][0] = 0.0;
		q[1][1] = -(2.0 * p[1][1] / (height - 1));
		q[1][2] = -((2.0 * p[1][2] / (height - 1)) - 1.0);
		q[1][3] = 0.0;

		q[2][0] = 0.0;
		q[2][1] = 0.0;
		q[2][2] = (view_distance_max + view_distance_min) / (view_distance_min - view_distance_max);
		q[2][3] = 2.0 * view_distance_max * view_distance_min / (view_distance_min - view_distance_max);

		q[3][0] = 0.0;
		q[3][1] = 0.0;
		q[3][2] = -1.0;
		q[3][3] = 0.0;

		q[2][2] = q[2][2] * -1;
		q[2][3] = q[2][3] * -1;
		for (i = 0; i < 4; i++) { // Row.
			// First 3 columns of the current row.
			for (j = 0; j < 3; j++) { // Column.
				o_projection[i + j * 4] = q[i][0] * trans[0][j] + q[i][1] * trans[1][j] + q[i][2] * trans[2][j];
			}
			// Fourth column of the current row.
			o_projection[i + 3 * 4] = q[i][0] * trans[0][3] + q[i][1] * trans[1][3] + q[i][2] * trans[2][3] + q[i][3];
		}
		return;	
	}
	private void updateTransmat(NyARTransMatResult i_src)
	{
		this.transmat[0 + 0 * 4] = i_src.m00; 
		this.transmat[0 + 1 * 4] = i_src.m01;
		this.transmat[0 + 2 * 4] = i_src.m02;
		this.transmat[0 + 3 * 4] = i_src.m03;
		this.transmat[1 + 0 * 4] = -i_src.m10;
		this.transmat[1 + 1 * 4] = -i_src.m11;
		this.transmat[1 + 2 * 4] = -i_src.m12;
		this.transmat[1 + 3 * 4] = -i_src.m13;
		this.transmat[2 + 0 * 4] = -i_src.m20;
		this.transmat[2 + 1 * 4] = -i_src.m21;
		this.transmat[2 + 2 * 4] = -i_src.m22;
		this.transmat[2 + 3 * 4] = -i_src.m23;
		this.transmat[3 + 0 * 4] = 0.0;
		this.transmat[3 + 1 * 4] = 0.0;
		this.transmat[3 + 2 * 4] = 0.0;
		this.transmat[3 + 3 * 4] = 1.0;
		//angle
		this.angle.x=(float)i_src.angle.x;
		this.angle.y=(float)i_src.angle.y;
		this.angle.z=(float)i_src.angle.z;
		//trans
		this.trans.x=(float)i_src.m03;
		this.trans.y=(float)i_src.m13;
		this.trans.z=(float)i_src.m23;
		
		return;	
	}
	
	private final static double view_distance_min = 100;//#define VIEW_DISTANCE_MIN		0.1			// Objects closer to the camera than this will not be displayed.
	private final static double view_distance_max = 10000.0;//#define VIEW_DISTANCE_MAX		100.0		// Objects further away from the camera than this will not be displayed.
	public String version()
	{
		return VERSION;
	}
}
