/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.labeling.artoolkit;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.labeling.artoolkit.NyARLabelingLabel;
import jp.nyatla.nyartoolkit.core.labeling.artoolkit.NyARLabelingLabelStack;
import jp.nyatla.nyartoolkit.core.raster.NyARRaster_BasicClass;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARLabelingImage
extends NyARRaster_BasicClass {
    private static final int MAX_LABELS = 32768;
    protected int[] _ref_buf;
    protected NyARLabelingLabelStack _label_list;
    protected int[] _index_table;
    protected boolean _is_index_table_enable;

    public NyARLabelingImage(int i_width, int i_height) throws NyARException {
        super(new NyARIntSize(i_width, i_height), 262144);
        this._ref_buf = new int[i_height * i_width];
        this._label_list = new NyARLabelingLabelStack(32768);
        this._index_table = new int[32768];
        this._is_index_table_enable = false;
        this.drawFrameEdge();
    }

    public Object getBuffer() {
        return this._ref_buf;
    }

    public boolean hasBuffer() {
        return this._ref_buf != null;
    }

    public void wrapBuffer(Object i_ref_buf) throws NyARException {
        NyARException.notImplement();
    }

    public void drawFrameEdge() {
        int w = this._size.w;
        int h = this._size.h;
        int[] img = this._ref_buf;
        int bottom_ptr = (h - 1) * w;
        int i = 0;
        while (i < w) {
            img[i] = 0;
            img[bottom_ptr + i] = 0;
            ++i;
        }
        i = 0;
        while (i < h) {
            img[i * w] = 0;
            img[(i + 1) * w - 1] = 0;
            ++i;
        }
    }

    public int[] getIndexArray() {
        return this._is_index_table_enable ? this._index_table : null;
    }

    public NyARLabelingLabelStack getLabelStack() {
        return this._label_list;
    }

    public void reset(boolean i_label_index_enable) {
        assert (i_label_index_enable);
        this._label_list.clear();
        this._is_index_table_enable = i_label_index_enable;
    }

    public int getTopClipTangentX(NyARLabelingLabel i_label) throws NyARException {
        int i_label_id = i_label.id;
        int[] index_table = this._index_table;
        int[] limage = this._ref_buf;
        int limage_ptr = i_label.clip_t * this._size.w;
        int clip1 = i_label.clip_r;
        int i = i_label.clip_l;
        while (i <= clip1) {
            int pix = limage[limage_ptr + i];
            if (pix > 0 && index_table[pix - 1] == i_label_id) {
                return i;
            }
            ++i;
        }
        throw new NyARException();
    }
}

