/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.rpf.mklib;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.rpf.reality.nyartk.NyARRealityTarget;

public class CardDetect {
    public static final int MORE_FRONT_CENTER = 0;
    public static final int ESTIMATE_NOW = 1;
    public static final int ESTIMATE_COMPLETE = 2;
    public static final int FAILED_ESTIMATE = 3;
    public static final int FAILED_TARGET_MISSMATCH = 4;

    public void detectCardDirection(NyARRealityTarget i_target, UnknownRectInfo io_result) throws NyARException {
        double d4;
        double t2;
        if (io_result._success_point > 20) {
            io_result.last_status = 2;
            return;
        }
        if (io_result._failed > 10) {
            io_result.last_status = 3;
            return;
        }
        NyARDoublePoint2d[] pos = i_target.refTargetVertex();
        int i = 0;
        while (i < 4) {
            if (CardDetect.getAbsSin(pos[0 + i], pos[(1 + i) % 4], pos[(2 + i) % 4]) < 0.984) {
                io_result.last_status = 0;
                return;
            }
            ++i;
        }
        double d1 = Math.sqrt(pos[0].sqDist(pos[1]));
        double d2 = Math.sqrt(pos[1].sqDist(pos[2]));
        double d3 = Math.sqrt(pos[2].sqDist(pos[3]));
        double t = d1 + d3 * 0.5;
        double t3 = t / (t2 = d2 + (d4 = Math.sqrt(pos[3].sqDist(pos[0]))) * 0.5);
        double d = t3 = t3 < 1.0 ? 1.0 / t3 : t3;
        if (io_result._target_serial == -1L) {
            io_result._target_serial = i_target.getSerialId();
            io_result.rate = t3;
            io_result._success_point = 0;
            io_result._failed = 0;
            io_result.artk_direction = t < t2 ? 1 : 0;
        } else {
            if (io_result._target_serial != i_target.getSerialId()) {
                io_result.last_status = 4;
                return;
            }
            if (t3 / io_result.rate > 0.98 && t3 / io_result.rate < 1.02) {
                io_result.rate = (io_result.rate + t3) * 0.5;
                ++io_result._success_point;
            } else {
                ++io_result._failed;
            }
        }
        io_result.last_status = 1;
    }

    public static final double getAbsSin(NyARDoublePoint2d p1, NyARDoublePoint2d p2, NyARDoublePoint2d p3) {
        double cp = NyARDoublePoint2d.crossProduct3Point(p1, p2, p3);
        return (cp /= Math.sqrt(p1.sqDist(p2)) * Math.sqrt(p2.sqDist(p3))) > 0.0 ? cp : -cp;
    }

    public static class UnknownRectInfo {
        public long _target_serial = -1L;
        public int _success_point;
        public int _failed;
        public double rate;
        public int artk_direction;
        public int last_status;
    }
}

