/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyar4psg;

import jp.nyatla.nyar4psg.NyAR4PsgConfig;
import jp.nyatla.nyar4psg.SingleMarkerBaseClass;
import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquare;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.processor.SingleARMarkerProcesser;
import processing.core.PApplet;
import processing.core.PImage;

public class SingleARTKMarker
extends SingleMarkerBaseClass {
    public static final int ST_NOMARKER = 0;
    public static final int ST_NEWMARKER = 1;
    public static final int ST_UPDATEMARKER = 2;
    public static final int ST_REMOVEMARKER = 3;
    public int markerid;
    private MarkerProcessor _marker_proc;
    private boolean _registerd_marker = false;

    public int getMarkerId() {
        return this.markerid;
    }

    public SingleARTKMarker(PApplet parent, int i_width, int i_height, String i_cparam, NyAR4PsgConfig i_config) {
        try {
            this.initInstance(parent, i_cparam, i_width, i_height, i_config);
            this._marker_proc = new MarkerProcessor(this, this._ar_param, this._src_raster.getBufferType());
        }
        catch (NyARException e) {
            this._ref_papplet.die("Error on SingleARTKMarker", (Exception)((Object)e));
        }
    }

    public SingleARTKMarker(PApplet parent, int i_width, int i_height, String i_cparam) {
        try {
            this.initInstance(parent, i_cparam, i_width, i_height, NyAR4PsgConfig.CONFIG_DEFAULT);
            this._marker_proc = new MarkerProcessor(this, this._ar_param, this._src_raster.getBufferType());
        }
        catch (NyARException e) {
            this._ref_papplet.die("Error on SingleARTKMarker", (Exception)((Object)e));
        }
    }

    public void setARCodes(String i_patt_name, int i_patt_size) {
        if (this._registerd_marker) {
            this._ref_papplet.die("Error already called setARCodes.", (Exception)((Object)new NyARException()));
        }
        try {
            NyARCode[] codes = new NyARCode[]{new NyARCode(16, 16)};
            codes[0].loadARPatt(this._ref_papplet.createInput(i_patt_name));
            this._marker_proc.setARCodeTable(codes, 16, i_patt_size);
            this._registerd_marker = true;
        }
        catch (NyARException e) {
            this._ref_papplet.die("Error on setARCodes", (Exception)((Object)e));
        }
    }

    public void setARCodes(String[] i_patt_names, int i_marker_size) {
        if (this._registerd_marker) {
            this._ref_papplet.die("Error already called setARCodes.", (Exception)((Object)new NyARException()));
        }
        try {
            NyARCode[] codes = new NyARCode[i_patt_names.length];
            int i = 0;
            while (i < i_patt_names.length) {
                codes[i] = new NyARCode(16, 16);
                codes[i].loadARPatt(this._ref_papplet.createInput(i_patt_names[i]));
                ++i;
            }
            this._marker_proc.setARCodeTable(codes, 16, i_marker_size);
            this._registerd_marker = true;
        }
        catch (NyARException e) {
            this._ref_papplet.die("Error on setARCodes", (Exception)((Object)e));
        }
    }

    public void setConfidenceThreshold(double i_new_cf, double i_exist_cf) {
        this._marker_proc.setConfidenceThreshold(i_new_cf, i_exist_cf);
    }

    public int detect(PImage i_image) {
        if (!this._registerd_marker) {
            this._ref_papplet.die("Must call setARCodes function in the first.");
        }
        try {
            this._src_raster.wrapBuffer(i_image);
            this._marker_proc.initSequence();
            this._marker_proc.detectMarker((INyARRgbRaster)this._src_raster);
            switch (this._marker_proc.status) {
                case 0: 
                case 3: {
                    this.markerid = -1;
                    break;
                }
                case 1: {
                    this.markerid = this._marker_proc.current_code;
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new NyARException();
                }
            }
        }
        catch (NyARException e) {
            this._ref_papplet.die("Error while marker detecting up NyARToolkit for java", (Exception)((Object)e));
        }
        return this._marker_proc.status;
    }

    private class MarkerProcessor
    extends SingleARMarkerProcesser {
        private SingleMarkerBaseClass _parent;
        public int current_code = -1;
        public int status;
        private boolean _is_prev_onenter;

        public MarkerProcessor(SingleMarkerBaseClass i_parent, NyARParam i_cparam, int i_raster_format) throws NyARException {
            this._parent = i_parent;
            this.initInstance(i_cparam, i_raster_format);
            this.status = 0;
        }

        public void initSequence() {
            this.status = this.status == 3 ? 0 : this.status;
        }

        protected void onEnterHandler(int i_code) {
            this.current_code = i_code;
            this.status = 1;
            this._is_prev_onenter = true;
        }

        protected void onLeaveHandler() {
            this.current_code = -1;
            this.status = 3;
        }

        protected void onUpdateHandler(NyARSquare i_square, NyARTransMatResult result) {
            this._parent.updateTransmat(i_square, result);
            this.status = this._is_prev_onenter ? 1 : 2;
            this._is_prev_onenter = false;
        }
    }
}

