/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyar4psg;

import java.io.InputStream;
import java.util.ArrayList;
import jp.nyatla.nyar4psg.NyAR4PsgConfig;
import jp.nyatla.nyar4psg.NyARPsgBaseClass;
import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.analyzer.raster.threshold.NyARRasterThresholdAnalyzer_SlidePTile;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattDeviationColorData;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattResult;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPatt_Color_WITHOUT_PCA;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.pickup.NyARColorPatt_Perspective_O2;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.raster.NyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2gs.NyARRasterFilter_Rgb2Gs_RgbAve192;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARCoord2Linear;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquare;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquareContourDetector_Rle;
import jp.nyatla.nyartoolkit.core.transmat.INyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARRectOffset;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMat_ARToolKit;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;
import jp.nyatla.nyartoolkit.core.types.NyARIntCoordinates;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntRect;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;
import jp.nyatla.nyartoolkit.nyidmarker.NyIdMarkerParam;
import jp.nyatla.nyartoolkit.nyidmarker.NyIdMarkerPattern;
import jp.nyatla.nyartoolkit.nyidmarker.NyIdMarkerPickup;
import jp.nyatla.nyartoolkit.nyidmarker.data.INyIdMarkerData;
import jp.nyatla.nyartoolkit.nyidmarker.data.NyIdMarkerDataEncoder_RawBitId;
import jp.nyatla.nyartoolkit.nyidmarker.data.NyIdMarkerData_RawBitId;
import processing.core.PApplet;
import processing.core.PGraphics3D;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix3D;
import processing.core.PVector;

public class MultiMarker
extends NyARPsgBaseClass {
    public static final double DEFAULT_CF_THRESHOLD = 0.51;
    public static final int DEFAULT_LOST_DELAY = 10;
    public static final int THLESHOLD_AUTO = -1;
    private NyARRasterThresholdAnalyzer_SlidePTile _threshold_detect;
    private int _threshold = -1;
    private int _current_th;
    private RleDetector _rel_detector;
    private NyARGrayscaleRaster _gs_raster;
    private NyARRasterFilter_Rgb2Gs_RgbAve192 _tobin_filter;
    private INyARTransMat _transmat_inst;
    private final NyARIntRect _img_rect = new NyARIntRect();
    private PMatrix3D _old_matrix = null;

    public void setConfidenceThreshold(double i_val) {
        this._rel_detector._cf_threshold = i_val;
    }

    public void setLostDelay(int i_val) {
        this._rel_detector._max_lost_delay = i_val;
    }

    public void setThreshold(int i_th) {
        this._threshold = i_th;
    }

    public int getCurrentThreshold() {
        return this._current_th * 256 / 192;
    }

    public MultiMarker(PApplet parent, int i_width, int i_height, String i_cparam_file, NyAR4PsgConfig i_config) {
        try {
            this.initInstance(parent, i_cparam_file, i_width, i_height, i_config);
        }
        catch (Exception e) {
            e.printStackTrace();
            parent.die("Exception occurred at MultiMarker.MultiMarker");
        }
    }

    public MultiMarker(PApplet parent, int i_width, int i_height, String i_cparam_file) {
        try {
            this.initInstance(parent, i_cparam_file, i_width, i_height, NyAR4PsgConfig.CONFIG_DEFAULT);
        }
        catch (Exception e) {
            e.printStackTrace();
            parent.die("Exception occurred at MultiMarker.MultiMarker");
        }
    }

    @Override
    protected void initInstance(PApplet parent, String i_cparam_file, int i_width, int i_height, NyAR4PsgConfig i_config) throws NyARException {
        super.initInstance(parent, i_cparam_file, i_width, i_height, i_config);
        this._rel_detector = new RleDetector(this, this._ar_param);
        this._gs_raster = new NyARGrayscaleRaster(i_width, i_height, true);
        this._tobin_filter = new NyARRasterFilter_Rgb2Gs_RgbAve192(this._src_raster.getBufferType());
        switch (i_config.env_transmat_mode) {
            case 0: {
                this._transmat_inst = new NyARTransMat_ARToolKit(this._ar_param);
                break;
            }
            case 1: {
                this._transmat_inst = new NyARTransMat(this._ar_param);
                break;
            }
            default: {
                throw new NyARException();
            }
        }
        this._img_rect.setValue(0, 0, i_width, i_height);
        int skip = i_height / 120;
        this._threshold_detect = new NyARRasterThresholdAnalyzer_SlidePTile(15, this._gs_raster.getBufferType(), skip < 1 ? 1 : skip);
    }

    public void beginTransform(int i_id) {
        if (this._old_matrix != null) {
            this._ref_papplet.die("The function beginTransform is already called.", null);
        }
        if (!(this._ref_papplet.g instanceof PGraphics3D)) {
            this._ref_papplet.die("NyAR4Psg require PGraphics3D instance.");
        }
        this._old_matrix = new PMatrix3D((PMatrix)((PGraphics3D)this._ref_papplet.g).projection);
        this.setARPerspective();
        this._ref_papplet.pushMatrix();
        this._ref_papplet.setMatrix(this.getMarkerMatrix(i_id));
    }

    public void endTransform() {
        if (this._old_matrix == null) {
            this._ref_papplet.die("The function beginTransform is never called.", null);
        }
        this._ref_papplet.popMatrix();
        this.setPerspective(this._old_matrix);
        this._old_matrix = null;
    }

    public void detect(PImage i_image) {
        try {
            this._src_raster.wrapBuffer(i_image);
            this._tobin_filter.doFilter((INyARRgbRaster)this._src_raster, this._gs_raster);
            this._current_th = this._threshold == -1 ? (this._threshold_detect.analyzeRaster((INyARRaster)this._gs_raster) + this._current_th) / 2 : this._threshold * 192 / 256;
            this._rel_detector.prevDetection((INyARRgbRaster)this._src_raster);
            this._rel_detector.detectMarker(this._gs_raster, this._img_rect, this._current_th);
            this._rel_detector.finishDetection(this._transmat_inst);
        }
        catch (Exception e) {
            e.printStackTrace();
            this._ref_papplet.die("Exception occurred at MultiARTookitMarker.detect");
        }
    }

    public int addARMarker(String i_file_name, int i_patt_resolution, int i_edge_percentage, float i_width) {
        try {
            TMarkerData item = new TMarkerData(this._ref_papplet.createInput(i_file_name), i_patt_resolution, i_edge_percentage, i_width);
            this._rel_detector.marker_sl.add(item);
        }
        catch (Exception e) {
            e.printStackTrace();
            this._ref_papplet.die("Exception occurred at MultiARTookitMarker.addMarker");
        }
        return this._rel_detector.marker_sl.size() - 1;
    }

    public int addARMarker(String i_file_name, int i_patt_resolution, float i_width) {
        return this.addARMarker(i_file_name, i_patt_resolution, 25, i_width);
    }

    public int addARMarker(String i_file_name, float i_width) {
        return this.addARMarker(i_file_name, 16, 25, i_width);
    }

    public int addNyIdMarker(int i_nyid, int i_width) {
        return this.addNyIdMarker(i_nyid, i_nyid, i_width);
    }

    public int addNyIdMarker(int i_nyid_range_s, int i_nyid_range_e, int i_width) {
        try {
            TMarkerData item = new TMarkerData(i_nyid_range_s, i_nyid_range_e, i_width);
            this._rel_detector.marker_sl.add(item);
        }
        catch (Exception e) {
            e.printStackTrace();
            this._ref_papplet.die("Exception occurred at MultiARTookitMarker.addNyIdMarker");
        }
        return this._rel_detector.marker_sl.size() - 1;
    }

    public PVector[] getMarkerVertex2D(int i_id) {
        PVector[] r = new PVector[4];
        try {
            TMarkerData item = this._rel_detector.marker_sl.get(i_id);
            int i = 0;
            while (i < 4) {
                r[i] = new PVector((float)item.sq.sqvertex[i].x, (float)item.sq.sqvertex[i].y);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this._ref_papplet.die("Exception occurred at MultiARTookitMarker.addNyIdMarker");
        }
        return r;
    }

    public PMatrix3D getMarkerMatrix(int i_id) {
        PMatrix3D p = new PMatrix3D();
        if (!this.isExistMarker(i_id)) {
            this._ref_papplet.die("Marker id " + i_id + " is not exist on image.", null);
        }
        TMarkerData item = this._rel_detector.marker_sl.get(i_id);
        MultiMarker.matResult2PMatrix3D((NyARDoubleMatrix44)item.tmat, this._config._coordinate_system, p);
        return p;
    }

    public double getConfidence(int i_id) {
        TMarkerData item = this._rel_detector.marker_sl.get(i_id);
        if (item.mktype != 0) {
            this._ref_papplet.die("Marker id " + i_id + " is not AR Marker.", null);
        }
        if (!this.isExistMarker(i_id)) {
            this._ref_papplet.die("Marker id " + i_id + " is not on image.", null);
        }
        return item.cf;
    }

    public long getNyId(int i_id) {
        TMarkerData item = this._rel_detector.marker_sl.get(i_id);
        if (item.mktype != 1) {
            this._ref_papplet.die("Marker id " + i_id + " is not NyId Marker.", null);
        }
        if (!this.isExistMarker(i_id)) {
            this._ref_papplet.die("Marker id " + i_id + " is not on image.", null);
        }
        return item.nyid;
    }

    public boolean isExistMarker(int i_id) {
        TMarkerData item = this._rel_detector.marker_sl.get(i_id);
        return item.lost_count < this._rel_detector._max_lost_delay;
    }

    public int getLostCount(int i_id) {
        if (!this.isExistMarker(i_id)) {
            this._ref_papplet.die("Marker id " + i_id + " is not on image.", null);
        }
        TMarkerData item = this._rel_detector.marker_sl.get(i_id);
        return item.lost_count;
    }

    public long getLife(int i_id) {
        if (!this.isExistMarker(i_id)) {
            this._ref_papplet.die("Marker id " + i_id + " is not on image.", null);
        }
        TMarkerData item = this._rel_detector.marker_sl.get(i_id);
        return item.life;
    }

    public PVector marker2ScreenCoordSystem(int i_id, double i_x, double i_y, double i_z) {
        NyARDoublePoint3d pos = new NyARDoublePoint3d();
        this._rel_detector.marker_sl.get((int)i_id).tmat.transform3d(i_x, i_y, i_z, pos);
        NyARDoublePoint2d pos2d = new NyARDoublePoint2d();
        this._frustum.project(pos, pos2d);
        PVector ret = new PVector();
        ret.x = (float)pos2d.x;
        ret.y = (float)pos2d.y;
        ret.z = 0.0f;
        return ret;
    }

    public PVector screen2MarkerCoordSystem(int i_id, int i_x, int i_y) {
        return this.screen2MarkerCoordSystem((NyARDoubleMatrix44)this._rel_detector.marker_sl.get((int)i_id).tmat, i_x, i_y);
    }

    public PImage pickupMarkerImage(int i_id, int i_x1, int i_y1, int i_x2, int i_y2, int i_x3, int i_y3, int i_x4, int i_y4, int i_out_w_pix, int i_out_h_pix) {
        return this.pickupMarkerImage((NyARDoubleMatrix44)this._rel_detector.marker_sl.get((int)i_id).tmat, i_x1, i_y1, i_x2, i_y2, i_x3, i_y3, i_x4, i_y4, i_out_w_pix, i_out_h_pix);
    }

    public PImage pickupRectMarkerImage(int i_id, int i_l, int i_t, int i_w, int i_h, int i_out_w_pix, int i_out_h_pix) {
        return this.pickupMarkerImage(i_id, i_l + i_w - 1, i_t + i_h - 1, i_l, i_t + i_h - 1, i_l, i_t, i_l + i_w - 1, i_t, i_out_w_pix, i_out_h_pix);
    }

    private class MultiResolutionPattPickup {
        private ArrayList<Item> items = new ArrayList();

        private MultiResolutionPattPickup() {
        }

        public NyARMatchPattDeviationColorData refDeviationColorData(TMarkerData i_marker) {
            int mk_resolution = i_marker.patt_resolution;
            int mk_edge = i_marker.patt_edge_percentage;
            Item item = null;
            int i = this.items.size() - 1;
            while (i >= 0) {
                Item ptr = this.items.get(i);
                if (ptr._pickup.getSize().isEqualSize(mk_resolution, mk_resolution) && ptr._patt_edge == mk_edge) {
                    return this.items.get(i)._patt_d;
                }
                --i;
            }
            item = new Item(mk_resolution, mk_edge);
            this.items.add(item);
            return item._patt_d;
        }

        public boolean makePattDeviationColorData(INyARRgbRaster i_image, NyARIntPoint2d[] i_vertexs) throws NyARException {
            int i = this.items.size() - 1;
            while (i >= 0) {
                Item item = this.items.get(i);
                if (!item._pickup.pickFromRaster(i_image, i_vertexs)) {
                    return false;
                }
                item._patt_d.setRaster((INyARRgbRaster)item._pickup);
                --i;
            }
            return true;
        }

        private class Item {
            private NyARColorPatt_Perspective_O2 _pickup;
            private NyARMatchPattDeviationColorData _patt_d;
            private int _patt_edge;

            public Item(int i_resolution, int i_edge_percentage) {
                int r = 1;
                while (i_resolution * r < 64) {
                    r *= 2;
                }
                this._patt_d = new NyARMatchPattDeviationColorData(i_resolution, i_resolution);
                this._pickup = new NyARColorPatt_Perspective_O2(i_resolution, i_resolution, r, i_edge_percentage, 262402);
                this._patt_edge = i_edge_percentage;
            }
        }
    }

    private class RleDetector
    extends NyARSquareContourDetector_Rle {
        private final NyIdMarkerPickup _id_pickup;
        private final MultiResolutionPattPickup _mpickup;
        private final NyARIntPoint2d[] _vertexs;
        private NyARCoord2Linear _coordline;
        private final NyARMatchPattResult _patt_result;
        private INyARRgbRaster _ref_src_raster;
        private NyARRectOffset _offset;
        public final ArrayList<TMarkerData> marker_sl;
        public double _cf_threshold;
        public int _max_lost_delay;
        private final NyIdMarkerPattern _id_patt;
        private final NyIdMarkerParam _id_param;
        private final NyIdMarkerDataEncoder_RawBitId _id_encoder;
        private final NyIdMarkerData_RawBitId _id_data;

        public RleDetector(MultiMarker i_parent, NyARParam i_param) throws NyARException {
            super(i_param.getScreenSize());
            this._id_pickup = new NyIdMarkerPickup();
            this._mpickup = new MultiResolutionPattPickup();
            this._vertexs = new NyARIntPoint2d[4];
            this._patt_result = new NyARMatchPattResult();
            this._offset = new NyARRectOffset();
            this.marker_sl = new ArrayList();
            this._cf_threshold = 0.51;
            this._max_lost_delay = 10;
            this._id_patt = new NyIdMarkerPattern();
            this._id_param = new NyIdMarkerParam();
            this._id_encoder = new NyIdMarkerDataEncoder_RawBitId();
            this._id_data = new NyIdMarkerData_RawBitId();
            this._coordline = new NyARCoord2Linear(i_param.getScreenSize(), i_param.getDistortionFactor());
        }

        protected void onSquareDetect(NyARIntCoordinates i_coord, int[] i_vertex_index) throws NyARException {
            int i2 = 0;
            while (i2 < 4) {
                this._vertexs[i2] = i_coord.items[i_vertex_index[i2]];
                ++i2;
            }
            if (this._id_pickup.pickFromRaster(this._ref_src_raster, this._vertexs, this._id_patt, this._id_param)) {
                if (!this._id_encoder.encode(this._id_patt, (INyIdMarkerData)this._id_data)) {
                    return;
                }
                int i = this.marker_sl.size() - 1;
                while (i >= 0) {
                    long s;
                    TMarkerData item = this.marker_sl.get(i);
                    if (item.mktype == 1 && item.nyid_range_s <= (s = this._id_data.marker_id) && s <= item.nyid_range_e) {
                        item.nyid = s;
                        item.lost_count = 0;
                        this.setItemSquare(this._id_param.direction, i_coord, i_vertex_index, item.sq);
                        return;
                    }
                    --i;
                }
                return;
            }
            if (!this._mpickup.makePattDeviationColorData(this._ref_src_raster, this._vertexs)) {
                return;
            }
            double best_cf = 0.0;
            int best_id = -1;
            int best_dir = -1;
            int i = this.marker_sl.size() - 1;
            while (i >= 0) {
                TMarkerData item = this.marker_sl.get(i);
                if (item.mktype == 0 && item.matchpatt.evaluate(this._mpickup.refDeviationColorData(item), this._patt_result) && !(this._patt_result.confidence < this._cf_threshold) && !(best_cf > this._patt_result.confidence)) {
                    best_cf = this._patt_result.confidence;
                    best_dir = this._patt_result.direction;
                    best_id = i;
                }
                --i;
            }
            if (best_id < 0) {
                return;
            }
            TMarkerData item = this.marker_sl.get(best_id);
            if (item.cf > best_cf) {
                return;
            }
            item.cf = best_cf;
            item.lost_count = 0;
            this.setItemSquare(best_dir, i_coord, i_vertex_index, item.sq);
        }

        private void setItemSquare(int i_dir, NyARIntCoordinates i_coord, int[] i_vertex_index, NyARSquare i_sq) throws NyARException {
            int i = 0;
            while (i < 4) {
                int idx = (i + 4 - i_dir) % 4;
                this._coordline.coord2Line(i_vertex_index[idx], i_vertex_index[(idx + 1) % 4], i_coord, i_sq.line[i]);
                ++i;
            }
            i = 0;
            while (i < 4) {
                if (!i_sq.line[i].crossPos(i_sq.line[(i + 3) % 4], i_sq.sqvertex[i])) {
                    throw new NyARException();
                }
                ++i;
            }
        }

        public void prevDetection(INyARRgbRaster i_src) {
            this._ref_src_raster = i_src;
            int i = this.marker_sl.size() - 1;
            while (i >= 0) {
                TMarkerData item = this.marker_sl.get(i);
                item.cf = 0.0;
                if (item.lost_count < this._max_lost_delay) {
                    ++item.lost_count;
                    ++item.life;
                } else {
                    item.life = 0L;
                }
                --i;
            }
        }

        public void finishDetection(INyARTransMat i_transmat) throws NyARException {
            int i = this.marker_sl.size() - 1;
            while (i >= 0) {
                TMarkerData item = this.marker_sl.get(i);
                this._offset.setSquare(item.marker_size);
                i_transmat.transMatContinue(item.sq, this._offset, item.tmat, item.tmat);
                --i;
            }
        }
    }

    private class TMarkerData {
        public static final int MK_AR = 0;
        public static final int MK_NyId = 1;
        public final int mktype;
        public final NyARMatchPatt_Color_WITHOUT_PCA matchpatt;
        public final double marker_size;
        public double cf;
        public final int patt_resolution;
        public final int patt_edge_percentage;
        public long life;
        public final long nyid_range_s;
        public final long nyid_range_e;
        public long nyid;
        public final NyARSquare sq = new NyARSquare();
        public final NyARTransMatResult tmat = new NyARTransMatResult();
        public int lost_count = Integer.MAX_VALUE;

        public TMarkerData(InputStream i_patt, int i_patt_resolution, int i_patt_edge_percentage, double i_patt_size) throws NyARException {
            NyARCode c = new NyARCode(i_patt_resolution, i_patt_resolution);
            this.mktype = 0;
            c.loadARPatt(i_patt);
            this.matchpatt = new NyARMatchPatt_Color_WITHOUT_PCA(c);
            this.marker_size = i_patt_size;
            this.patt_resolution = i_patt_resolution;
            this.patt_edge_percentage = i_patt_edge_percentage;
            this.nyid_range_s = 0L;
            this.nyid_range_e = 0L;
        }

        public TMarkerData(int i_nyid_range_s, int i_nyid_range_e, double i_patt_size) {
            this.mktype = 1;
            this.marker_size = i_patt_size;
            this.nyid_range_s = i_nyid_range_s;
            this.nyid_range_e = i_nyid_range_e;
            this.patt_resolution = 0;
            this.patt_edge_percentage = 0;
            this.matchpatt = null;
        }
    }
}

