/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyar4psg;

import java.io.InputStream;
import jp.nyatla.nyar4psg.NyAR4PsgConfig;
import jp.nyatla.nyar4psg.SingleMarkerBaseClass;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;
import jp.nyatla.nyartoolkit.detector.NyARSingleDetectMarker;
import processing.core.PApplet;
import processing.core.PImage;

public class NyARBoard
extends SingleMarkerBaseClass {
    public int lostDelay = 10;
    public int lostCount = 0;
    public double cfThreshold = 0.4;
    public double confidence = 0.0;
    public int gsThreshold = 110;
    private NyARSingleDetectMarker _nya;
    private final NyARTransMatResult _rettmp = new NyARTransMatResult();

    public NyARBoard(PApplet pApplet, int n, int n2, String string, String string2, int n3, NyAR4PsgConfig nyAR4PsgConfig) {
        try {
            this.initInstance(pApplet, string, string2, n, n2, n3, nyAR4PsgConfig);
        }
        catch (Exception exception) {
            this._ref_papplet.die("Error at NyARBoard", exception);
        }
    }

    public NyARBoard(PApplet pApplet, int n, int n2, String string, String string2, int n3) {
        try {
            this.initInstance(pApplet, string, string2, n, n2, n3, NyAR4PsgConfig.CONFIG_DEFAULT);
        }
        catch (Exception exception) {
            this._ref_papplet.die("Error at NyARBoard", exception);
        }
    }

    private void initInstance(PApplet pApplet, String string, String string2, int n, int n2, int n3, NyAR4PsgConfig nyAR4PsgConfig) throws NyARException {
        super.initInstance(pApplet, string, n, n2, nyAR4PsgConfig);
        NyARCode nyARCode = NyARCode.createFromARPattFile((InputStream)this._ref_papplet.createInput(string2), (int)16, (int)16);
        int n4 = nyAR4PsgConfig.env_transmat_mode == 0 ? 1 : 2;
        this._nya = NyARSingleDetectMarker.createInstance((NyARParam)this._ar_param, (NyARCode)nyARCode, (double)n3, (int)n4);
        this._nya.setContinueMode(true);
    }

    public boolean detect(PImage pImage) {
        pImage.loadPixels();
        return this.detectWithoutLoadPixels(pImage);
    }

    public boolean detectWithoutLoadPixels(PImage pImage) {
        boolean bl = false;
        try {
            double d;
            this._src_raster.wrapBuffer(pImage);
            bl = this._nya.detectMarkerLite((INyARRgbRaster)this._src_raster, this.gsThreshold);
            if (bl && (d = this._nya.getConfidence()) < this.cfThreshold) {
                bl = false;
            }
            if (bl) {
                this.confidence = this._nya.getConfidence();
                this.lostCount = 0;
                this._nya.getTransmationMatrix((NyARDoubleMatrix44)this._rettmp);
                this.updateTransmat(this._nya.refSquare(), (NyARDoubleMatrix44)this._rettmp);
            } else if (this.lostCount < this.lostDelay) {
                ++this.lostCount;
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }
        catch (NyARException nyARException) {
            this._ref_papplet.die("Error while marker detecting up NyARToolkit for java", (Exception)((Object)nyARException));
            return bl;
        }
    }
}

