/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyar4psg;

import jp.nyatla.nyar4psg.NyAR4PsgConfig;
import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PMatrix3D;
import processing.opengl.PGraphicsOpenGL;

public abstract class NyARPsgBaseClass {
    public final float FRUSTUM_DEFAULT_NEAR_CLIP = 100.0f;
    public final float FRUSTUM_DEFAULT_FAR_CLIP = 100000.0f;
    public static final String VERSION = "NyAR4psg/2.0.0;NyARToolkit/4.1.1";
    protected PApplet _ref_papplet;
    protected final PMatrix3D _ps_background_mv = new PMatrix3D();
    protected NyAR4PsgConfig _config;
    private float _clip_far;
    private float _clip_near;
    private static final PMatrix3D _lh_mat = new PMatrix3D(-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);

    protected NyARPsgBaseClass() {
    }

    protected void initInstance(PApplet pApplet, NyAR4PsgConfig nyAR4PsgConfig) throws NyARException {
        this._ref_papplet = pApplet;
        this._config = nyAR4PsgConfig;
        this.setARClipping(100.0f, 100000.0f);
    }

    public abstract PMatrix3D getProjectionMatrix();

    public abstract PMatrix3D getProjectionMatrix(PMatrix3D var1);

    public void drawBackground(PImage pImage) {
        PApplet pApplet = this._ref_papplet;
        PGraphicsOpenGL pGraphicsOpenGL = (PGraphicsOpenGL)pApplet.g;
        pGraphicsOpenGL.pushProjection();
        this.setBackgroundOrtho(pImage.width, pImage.height);
        pApplet.pushMatrix();
        pApplet.setMatrix(this._ps_background_mv);
        pApplet.image(pImage, (float)(-pImage.width / 2), (float)(-pImage.height / 2));
        pApplet.popMatrix();
        pGraphicsOpenGL.popProjection();
    }

    public void setARClipping(float f, float f2) {
        this._clip_far = f2;
        this._clip_near = f;
        this._ps_background_mv.reset();
        this._ps_background_mv.translate(0.0f, 0.0f, -f2);
    }

    public void setBackgroundOrtho(int n, int n2) {
        this._ref_papplet.ortho(0.0f, (float)n, 0.0f, (float)n2, this._clip_near, this._clip_far + 1.0f);
    }

    public void setARPerspective() {
        this.setPerspective(this.getProjectionMatrix());
    }

    public void setPerspective(PMatrix3D pMatrix3D) {
        float f = pMatrix3D.m23 / (pMatrix3D.m22 + 1.0f);
        float f2 = pMatrix3D.m23 / (pMatrix3D.m22 - 1.0f);
        this._ref_papplet.frustum((pMatrix3D.m02 - 1.0f) * f2 / pMatrix3D.m00, (pMatrix3D.m02 + 1.0f) * f2 / pMatrix3D.m00, (pMatrix3D.m12 - 1.0f) * f2 / pMatrix3D.m11, (pMatrix3D.m12 + 1.0f) * f2 / pMatrix3D.m11, f2, f);
    }

    protected static void PMatrix2GLProjection(PMatrix3D pMatrix3D, float[] fArray) {
        fArray[0] = pMatrix3D.m00;
        fArray[1] = pMatrix3D.m10;
        fArray[2] = pMatrix3D.m20;
        fArray[3] = pMatrix3D.m30;
        fArray[4] = pMatrix3D.m01;
        fArray[5] = pMatrix3D.m11;
        fArray[6] = pMatrix3D.m21;
        fArray[7] = pMatrix3D.m31;
        fArray[8] = pMatrix3D.m02;
        fArray[9] = pMatrix3D.m12;
        fArray[10] = pMatrix3D.m22;
        fArray[11] = pMatrix3D.m32;
        fArray[12] = pMatrix3D.m03;
        fArray[13] = pMatrix3D.m13;
        fArray[14] = pMatrix3D.m23;
        fArray[15] = pMatrix3D.m33;
    }

    protected static void PMatrix2GLProjection(PMatrix3D pMatrix3D, double[] dArray) {
        dArray[0] = pMatrix3D.m00;
        dArray[1] = pMatrix3D.m10;
        dArray[2] = pMatrix3D.m20;
        dArray[3] = pMatrix3D.m30;
        dArray[4] = pMatrix3D.m01;
        dArray[5] = pMatrix3D.m11;
        dArray[6] = pMatrix3D.m21;
        dArray[7] = pMatrix3D.m31;
        dArray[8] = pMatrix3D.m02;
        dArray[9] = pMatrix3D.m12;
        dArray[10] = pMatrix3D.m22;
        dArray[11] = pMatrix3D.m32;
        dArray[12] = pMatrix3D.m03;
        dArray[13] = pMatrix3D.m13;
        dArray[14] = pMatrix3D.m23;
        dArray[15] = pMatrix3D.m33;
    }

    protected static void nyarMat2PsMat(NyARDoubleMatrix44 nyARDoubleMatrix44, PMatrix3D pMatrix3D) {
        pMatrix3D.m00 = (float)nyARDoubleMatrix44.m00;
        pMatrix3D.m01 = (float)nyARDoubleMatrix44.m01;
        pMatrix3D.m02 = (float)nyARDoubleMatrix44.m02;
        pMatrix3D.m03 = (float)nyARDoubleMatrix44.m03;
        pMatrix3D.m10 = (float)nyARDoubleMatrix44.m10;
        pMatrix3D.m11 = (float)nyARDoubleMatrix44.m11;
        pMatrix3D.m12 = (float)nyARDoubleMatrix44.m12;
        pMatrix3D.m13 = (float)nyARDoubleMatrix44.m13;
        pMatrix3D.m20 = (float)nyARDoubleMatrix44.m20;
        pMatrix3D.m21 = (float)nyARDoubleMatrix44.m21;
        pMatrix3D.m22 = (float)nyARDoubleMatrix44.m22;
        pMatrix3D.m23 = (float)nyARDoubleMatrix44.m23;
        pMatrix3D.m30 = (float)nyARDoubleMatrix44.m30;
        pMatrix3D.m31 = (float)nyARDoubleMatrix44.m31;
        pMatrix3D.m32 = (float)nyARDoubleMatrix44.m32;
        pMatrix3D.m33 = (float)nyARDoubleMatrix44.m33;
    }

    protected static void matResult2PMatrix3D(NyARDoubleMatrix44 nyARDoubleMatrix44, int n, PMatrix3D pMatrix3D) {
        pMatrix3D.m00 = (float)nyARDoubleMatrix44.m00;
        pMatrix3D.m01 = (float)nyARDoubleMatrix44.m01;
        pMatrix3D.m02 = (float)nyARDoubleMatrix44.m02;
        pMatrix3D.m03 = (float)nyARDoubleMatrix44.m03;
        pMatrix3D.m10 = (float)nyARDoubleMatrix44.m10;
        pMatrix3D.m11 = (float)nyARDoubleMatrix44.m11;
        pMatrix3D.m12 = (float)nyARDoubleMatrix44.m12;
        pMatrix3D.m13 = (float)nyARDoubleMatrix44.m13;
        pMatrix3D.m20 = (float)(-nyARDoubleMatrix44.m20);
        pMatrix3D.m21 = (float)(-nyARDoubleMatrix44.m21);
        pMatrix3D.m22 = (float)(-nyARDoubleMatrix44.m22);
        pMatrix3D.m23 = (float)(-nyARDoubleMatrix44.m23);
        pMatrix3D.m30 = 0.0f;
        pMatrix3D.m31 = 0.0f;
        pMatrix3D.m32 = 0.0f;
        pMatrix3D.m33 = 1.0f;
        if (n == 1) {
            pMatrix3D.apply(_lh_mat);
        }
    }

    protected static void matResult2GLArray(NyARDoubleMatrix44 nyARDoubleMatrix44, double[] dArray) {
        dArray[0] = nyARDoubleMatrix44.m00;
        dArray[4] = nyARDoubleMatrix44.m01;
        dArray[8] = nyARDoubleMatrix44.m02;
        dArray[12] = nyARDoubleMatrix44.m03;
        dArray[1] = -nyARDoubleMatrix44.m10;
        dArray[5] = -nyARDoubleMatrix44.m11;
        dArray[9] = -nyARDoubleMatrix44.m12;
        dArray[13] = -nyARDoubleMatrix44.m13;
        dArray[2] = -nyARDoubleMatrix44.m20;
        dArray[6] = -nyARDoubleMatrix44.m21;
        dArray[10] = -nyARDoubleMatrix44.m22;
        dArray[14] = -nyARDoubleMatrix44.m23;
        dArray[3] = 0.0;
        dArray[7] = 0.0;
        dArray[11] = 0.0;
        dArray[15] = 1.0;
    }
}

