/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.db.model;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Calendar;
import jp.nyx.common.util.CalendarUtility;

public abstract class DefaultModel
implements Serializable {
    private static CalendarUtility calUtil = new CalendarUtility();
    private Calendar now = Calendar.getInstance();
    private Calendar maxCal = Calendar.getInstance();
    private Timestamp verifyStartdate;
    private Timestamp verifyEnddate;
    private String registUid;
    private String updateUid;
    private Timestamp lastUpdate;
    private boolean enable = true;

    public DefaultModel() {
        this.maxCal.add(1, 100);
    }

    public boolean isEnable() {
        return this.enable;
    }

    public String getEnableString() {
        return this.enable ? "t" : "f";
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public Timestamp getLastUpdate() {
        if (this.lastUpdate == null) {
            this.lastUpdate = new Timestamp(this.now.getTimeInMillis());
        }
        return this.lastUpdate;
    }

    public void setLastUpdate(Timestamp lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public void setLastUpdate(Calendar lastUpdate) {
        this.lastUpdate = new Timestamp(lastUpdate.getTimeInMillis());
    }

    public String getRegistUid() {
        return this.registUid;
    }

    public void setRegistUid(String registUid) {
        this.registUid = registUid;
    }

    public String getUpdateUid() {
        return this.updateUid;
    }

    public void setUpdateUid(String updateUid) {
        this.updateUid = updateUid;
    }

    public Timestamp getVerifyEnddate() {
        if (this.verifyEnddate == null) {
            this.verifyEnddate = new Timestamp(this.maxCal.getTimeInMillis());
        }
        return this.verifyEnddate;
    }

    public void setVerifyEnddate(Timestamp verifyEnddate) {
        this.verifyEnddate = verifyEnddate;
    }

    public String getVerifyEndDay() {
        return calUtil.formatCalendar(this.getVerifyEnddate(), "yyyy/MM/dd");
    }

    public String getVerifyEndTime() {
        return calUtil.formatCalendar(this.getVerifyEnddate(), "HH:mm");
    }

    public Timestamp getVerifyStartdate() {
        if (this.verifyStartdate == null) {
            this.verifyStartdate = new Timestamp(this.now.getTimeInMillis());
        }
        return this.verifyStartdate;
    }

    public void setVerifyStartdate(Timestamp verifyStartdate) {
        this.verifyStartdate = verifyStartdate;
    }

    public String getVerifyStartDay() {
        return calUtil.formatCalendar(this.getVerifyStartdate(), "yyyy/MM/dd");
    }

    public String getVerifyStartTime() {
        return calUtil.formatCalendar(this.getVerifyStartdate(), "HH:mm");
    }
}

