/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.util;

import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Date;
import jp.nyx.NyxException;
import jp.nyx.common.util.PkiUtility;
import jp.nyx.common.util.spec.AuthorityKeyIdentifierExtension;
import jp.nyx.common.util.spec.BasicConstraintsExtension;
import jp.nyx.common.util.spec.CRLNumberExtension;
import jp.nyx.common.util.spec.IssuerAltNameExtension;
import jp.nyx.common.util.spec.IssuingDistributionPointExtension;
import jp.nyx.common.util.spec.KeyUsageExtension;
import jp.nyx.common.util.spec.SubjectAltNameExtension;
import jp.nyx.common.util.spec.SubjectKeyIdentifierExtension;
import org.bouncycastle.asn1.DEREncodable;

public abstract class Extension {
    public static final String EXTENSION_OID_BASE = "2.5.29.";
    private static ArrayList<Class> CERT_EXTENSIONS = new ArrayList();
    private static ArrayList<Class> CRL_EXTENSIONS = new ArrayList();
    private PkiUtility.GenCertType certGentype;
    private String issuerDN;
    private PublicKey issuerPublicKey;
    private PrivateKey issuerPrivateKey;
    private BigInteger issuerSN;
    private Date notAfter;
    private Date notBefore;
    private String subjectDN;
    private PublicKey subjectPublicKey;
    private BigInteger subjectSN;
    private BigInteger crlNumber;

    protected static int getCertExtensionCount() {
        return CERT_EXTENSIONS.size();
    }

    protected static Class getCertExtension(int index) {
        return CERT_EXTENSIONS.get(index);
    }

    protected static int getCrlExtensionCount() {
        return CRL_EXTENSIONS.size();
    }

    protected static Class getCrlExtension(int index) {
        return CRL_EXTENSIONS.get(index);
    }

    public abstract DEREncodable generateExtension() throws NyxException;

    public abstract String getOID();

    public abstract boolean getCritical();

    protected PkiUtility.GenCertType getCertGentype() {
        return this.certGentype;
    }

    protected void setCertGentype(PkiUtility.GenCertType certGentype) {
        this.certGentype = certGentype;
    }

    protected String getIssuerDN() {
        return this.issuerDN;
    }

    protected void setIssuerDN(String issuerDN) {
        this.issuerDN = issuerDN;
    }

    protected PrivateKey getIssuerPrivateKey() {
        return this.issuerPrivateKey;
    }

    protected void setIssuerPrivateKey(PrivateKey issuerPrivateKey) {
        this.issuerPrivateKey = issuerPrivateKey;
    }

    protected PublicKey getIssuerPublicKey() {
        return this.issuerPublicKey;
    }

    protected void setIssuerPublicKey(PublicKey issuerPublicKey) {
        this.issuerPublicKey = issuerPublicKey;
    }

    protected Date getNotAfter() {
        return this.notAfter;
    }

    protected void setNotAfter(Date notAfter) {
        this.notAfter = notAfter;
    }

    protected Date getNotBefore() {
        return this.notBefore;
    }

    protected void setNotBefore(Date notBefore) {
        this.notBefore = notBefore;
    }

    protected String getSubjectDN() {
        return this.subjectDN;
    }

    protected void setSubjectDN(String subjectDN) {
        this.subjectDN = subjectDN;
    }

    public PublicKey getSubjectPublicKey() {
        return this.subjectPublicKey;
    }

    public void setSubjectPublicKey(PublicKey subjectPublicKey) {
        this.subjectPublicKey = subjectPublicKey;
    }

    public BigInteger getIssuerSN() {
        return this.issuerSN;
    }

    public void setIssuerSN(BigInteger issuerSN) {
        this.issuerSN = issuerSN;
    }

    public BigInteger getSubjectSN() {
        return this.subjectSN;
    }

    public void setSubjectSN(BigInteger subjectSN) {
        this.subjectSN = subjectSN;
    }

    public BigInteger getCrlNumber() {
        return this.crlNumber;
    }

    public void setCrlNumber(BigInteger crlNumber) {
        this.crlNumber = crlNumber;
    }

    static {
        CERT_EXTENSIONS.add(BasicConstraintsExtension.class);
        CERT_EXTENSIONS.add(KeyUsageExtension.class);
        CERT_EXTENSIONS.add(SubjectAltNameExtension.class);
        CERT_EXTENSIONS.add(SubjectKeyIdentifierExtension.class);
        CRL_EXTENSIONS.add(AuthorityKeyIdentifierExtension.class);
        CRL_EXTENSIONS.add(CRLNumberExtension.class);
        CRL_EXTENSIONS.add(IssuerAltNameExtension.class);
        CRL_EXTENSIONS.add(IssuingDistributionPointExtension.class);
    }
}

